@extends('layouts.app')
@section('leftbar-orders-active', 'active')



@section('content-body')
<div class="content-body">
  <section>
    @if (\Session::has('success'))
    <div class="alert alert-success">
      <ul>
        <li>{!! \Session::get('success') !!}</li>
      </ul>
    </div>
    @endif

    <div class="container">
      <div class="row">
        <div class="card" style="    width: 100%;">
          <div class="card-content">
            <div class="col-12 col-md-12 col-lg-12">
              <ul class="nav nav-tabs nav-justified" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" data-toggle="tab" href="#general" role="tab" aria-controls="general"
                    aria-selected="true">General</a>
                </li>
                <li class="nav-item disabled">
                  <a class="nav-link disabled" data-toggle="tab" href="#contacts" role="tab" aria-controls="contacts"
                    aria-selected="false">Contacts</a>
                </li>
                <li class="nav-item disabled">
                  <a class="nav-link disabled" data-toggle="tab" href="#addresses" role="tab" aria-controls="addresses"
                    aria-selected="false">Addresses</a>
                </li>
                <li class="nav-item disabled">
                  <a class="nav-link disabled" data-toggle="tab" href="#history" role="tab" aria-controls="history"
                    aria-selected="false">History</a>
                </li>
                <li class="nav-item disabled">
                  <a class="nav-link disabled" data-toggle="tab" href="#emu2" role="tab" aria-controls="emu2"
                    aria-selected="false">Payment & Credit Card</a>
                </li>
              </ul>

              <div class="tab-content mt-3">

                <div class="tab-pane active" id="general" role="tabpanel" aria-labelledby="general-tab">

                  <form class="form" action="{{ route('customer.store') }}" method="POST">
                    @csrf
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="userCompany" class="required-field">Company Name</label>
                                    <input type="text" id="userCompany" class="form-control" placeholder="Company Name" name="userCompany" required >
                                </div>
                            </div>
                         
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="companyName" class="required-field">Email</label>
                                    <input type="email" id="email" class="form-control" name="email" placeholder="Email" >
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="phone" class="required-field">Phone</label>
                                    <input type="text" id="phone" class="form-control" name="phone" placeholder="Phone" required>
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="phone">Phone #2</label>
                                    <input type="text" id="phone" class="form-control" name="phone" placeholder="Phone" >
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="userWebsite">Website</label>
                                    <input type="text" id="userWebsite" class="form-control"
                                        name="userWebsite" placeholder="Website" >
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="userFax">Fax</label>
                                    <input type="text" id="userFax" class="form-control" name="userFax" placeholder="Fax" >
                                </div>
                            </div>
                
                            <div class="col-md-8 col-12">
                                <div class="form-group">
                                    <label for="userAddress" class="required-field">Address</label>
                                    <input type="text" id="userAddress" class="form-control" placeholder="Address" name="userAddress" required >
                                </div>
                            </div>
                            <div class="col-md-4 col-12" id="load-countries-general">
                              
                            </div>
                            <div class="col-md-4 col-12"  id="load-states-general">
                                
                            </div>
                         
                            
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="userCity" class="required-field">City</label>
                                    <input type="text" id="userCity" class="form-control"
                                        placeholder="City" name="userCity" required >
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="form-group">
                                    <label for="userPostalCode" class="required-field">Postal/Zip Code</label>
                                    <input type="text" id="userPostalCode" class="form-control"
                                        name="userPostalCode" placeholder="Zip/Postal" required >
                                </div>
                            </div>
                          
                
                
                        </div>
                    </div>
                    <div class="col-md-2 offset-md-10">
                        <button type="submit" class="btn  submit-btn mr-1 mb-1 waves-effect waves-light">save</button>
                    </div>
                </form>

                </div>

                <div class="tab-pane " id="contacts" role="tabpanel" aria-labelledby="contacts-tab">
         
                </div>

                <div class="tab-pane" id="addresses" role="tabpanel" aria-labelledby="addresses-tab">
                
                </div>

                <div class="tab-pane " id="history" role="tabpanel" aria-labelledby="history-tab">
               
                  
     
                </div>

                <div class="tab-pane" id="emu2" role="tabpanel" aria-labelledby="emu2-tab">
                 

                </div>

              </div>

            </div>
          </div>
        </div>
      </div>
    </div>









  </section>
</div>
@endsection

@section('after-scripts')


<script>
  $(document).ready(function () {

    // withstates
    loadCountries('general', 'withstates', 'user', 'user', 1)
 

  });

</script>

@include('scripts.load-countries')

@include('scripts.load-states')



@endsection
