@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Customer</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Update Customer Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("customer.update", [$customer->userId]) }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="firstName" class="form-control"
                                                    placeholder="First Name" value="{{ $customer->firstName }}" name="firstName" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="lastName" class="form-control"
                                                    placeholder="Last Name" value="{{ $customer->lastName }}" name="lastName" required>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="phone" class="form-control"
                                                    name="phone" value="{{ $customer->phone }}" placeholder="Phone" required>
                                            </div>
                                        </div>
                                        <div class="col-md-8 col-12">
                                            <div class="form-label-group">
                                                <input type="email" id="email" class="form-control"
                                                    name="email" value="{{ $customer->email }}" placeholder="Email" required>
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="userAddress" class="form-control"
                                                    placeholder="Address" value="{{ $customer->userAddress }}" name="userAddress" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="userCity" class="form-control"
                                                    placeholder="City" value="{{ $customer->userCity }}" name="userCity" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-label-group">
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="userState" name="userState" required>
                                                        @foreach ($states as $state)
                                                            @if ($state->stateCode == $customer->userState)
                                                            <option value="{{ $state->stateCode }}" selected>
                                                            @else
                                                            <option value="{{ $state->stateCode }}">
                                                            @endif
                                                            {{ $state->stateName }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-12">
                                            <div class="form-label-group">
                                                <input type="text" id="userPostalCode" class="form-control"
                                                    name="userPostalCode" value="{{ $customer->userPostalCode }}" placeholder="Zip/Postal" required>
                                            </div>
                                        </div>



                                    </div>
                                </div>
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                    <a href="{{ route('customer.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection
