@extends('layouts.app')
@section('leftbar-orders-active', 'active')



@section('content-body')
<div class="content-body">
  <section>
    @if (\Session::has('success'))
    <div class="alert alert-success">
      <ul>
        <li>{!! \Session::get('success') !!}</li>
      </ul>
    </div>
    @endif

    <div class="container">
      <div class="row">
        <div class="card" style="    width: 100%;">
          <div class="card-content">
            <div class="col-12 col-md-12 col-lg-12">
              <ul class="nav nav-tabs nav-justified" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" data-toggle="tab" href="#general" role="tab" aria-controls="general"
                    aria-selected="true">General</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#contacts" role="tab" aria-controls="contacts"
                    aria-selected="false">Contacts</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#addresses" role="tab" aria-controls="addresses"
                    aria-selected="false">Addresses</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#history" role="tab" aria-controls="history"
                    aria-selected="false">History</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#emu2" role="tab" aria-controls="emu2"
                    aria-selected="false">Payment & Credit Card</a>
                </li>
              </ul>

              <div class="tab-content mt-3">

                <div class="tab-pane active" id="general" role="tabpanel" aria-labelledby="general-tab">

                  @include('customers.partials.general')

                </div>

                <div class="tab-pane " id="contacts" role="tabpanel" aria-labelledby="contacts-tab">
                  @include('customers.partials.contact-form')
                </div>

                <div class="tab-pane" id="addresses" role="tabpanel" aria-labelledby="addresses-tab">
                  @include('customers.partials.address-form')
                </div>

                <div class="tab-pane " id="history" role="tabpanel" aria-labelledby="history-tab">
               
                  
        <div class="row">
          <div class="col-md-4 col-12">
              <div class="form-group">
                  <label for="userCompany">Customer Since</label>
                  <input type="text" readonly class="form-control"
                     value="@if($customer){{ date('d-m-Y', strtotime($customer->userCreatedAt)) }}@endif">
              </div>
          </div>
              <div class="col-md-8 col-12">
                  <table class="table"  id="show-history">
                  </table>
                  </div>
                  </div>
                </div>

                <div class="tab-pane" id="emu2" role="tabpanel" aria-labelledby="emu2-tab">
                  @include('customers.partials.payments-form')

                </div>

              </div>

            </div>
          </div>
        </div>
      </div>
    </div>









  </section>
</div>
@endsection


@section('after-scripts')


<script>
  $(document).ready(function () {

    // withstates
    loadCountries('general', 'withstates', 'user', 'user', 1)
    loadCreditCard()
    loadContacts()
    loadHistory()

  });


</script>

@include('scripts.load-countries')

@include('scripts.load-states')

@include('scripts.customers.addresses')
@include('scripts.customers.contacts')
@include('scripts.customers.payments')
@include('scripts.customers.history')

<script>



</script>

@endsection