@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                        <h4 class="add_new_cust_heading">Update Address Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("customer-address.update", [$address->userAddressId])
                                }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="userAddressLine1">Address Line #1</label>
                                                <input type="text" id="userAddressLine1" class="form-control"
                                                    placeholder="Address Line #1" name="userAddressLine1" required
                                                    value="{{ $address->userAddressLine1 }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="userAddressLine2">Address Line #2</label>
                                                <input type="text" id="userAddressLine2" class="form-control"
                                                    placeholder="Address Line #2" name="userAddressLine2" required
                                                    value="{{ $address->userAddressLine2 }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12" >
                                          
                                            <div class="form-group">
                                                <label>Country</label>
                                              
                                                <input type="text" id="userAddressCountry" class="form-control"
                                                    name="userAddressCountry" placeholder="Country" value="{{ $address->userAddressCountry }}" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12" >
                                          
                                            <div class="form-group">
                                                <label>State</label>
                                              
                                                <input type="text" id="userAddressState" class="form-control"
                                                    name="userAddressState" placeholder="State" value="{{ $address->userAddressState }}" required="">
                                            </div>
                                        </div>


                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userAddressCity">City</label>
                                                <input type="text" id="userAddressCity" class="form-control"
                                                    name="userAddressCity" placeholder="City" required
                                                    value="{{ $address->userAddressCity }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userAddressZip">Zip/Postal Code</label>
                                                <input type="text" id="userAddressZip" class="form-control"
                                                    name="userAddressZip" placeholder="Zip/Postal" required
                                                    value="{{ $address->userAddressZip }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userAddressTax">Sales Tax (in %age)</label>
                                                <input type="text" id="userAddressTax" class="form-control"
                                                    name="userAddressTax" placeholder="3%" required
                                                    value="{{ $address->userAddressTax }}">
                                            </div>
                                        </div>


                                        <div class="col-md-8 offset-md-4">
                                            <button type="submit"
                                                class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                            <a href="{{ route('customer.edit', $address->userAddressCustomerId ) }}"
                                                class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
      

    </section>
</div>
@endsection




@section('after-scripts')


<script>
    $(document).ready(function () {

        // withstates
        loadCountries('address', 'withstates', 'userAddress', 'userAddress', 1)



    });

</script>
@include('scripts.load-countries')
@include('scripts.load-states')
@endsection