@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                        <h4 class="add_new_cust_heading">Update Card Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("customer-address.update", [$card->userCardId])
                                }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userCardHolderName">Cardholder's Name</label>
                                                <input type="text" id="userCardHolderName" class="form-control" placeholder="Full Name"
                                                    name="userCardHolderName" value="@if($card){{ $card->userCardHolderName }}@endif" required="" >
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userCardNo">Credit Card Number</label>
                                                <input type="text" id="userCardNo" class="form-control" placeholder="Card Number"
                                                    name="userCardNo" value="@if($card){{ $card->userCardNo }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-12">
                                            <div class="form-group">
                                                <label for="userCompany">Expiry(MM)</label>
                                                <input type="text" id="userCardExpireMonth" class="form-control" placeholder="09"
                                                    name="userCardExpireMonth"  value="@if($card){{ $card->userCardExpireMonth }}@endif" required="" >
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-12">
                                            <div class="form-group">
                                                <label for="userCardExpireYear">Expiry(YY)</label>
                                                <input type="text" id="userCardExpireYear" class="form-control" placeholder="2022"
                                                    name="userCardExpireYear" value="@if($card){{ $card->userCardExpireYear }}@endif" required="" >
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="userCardAddress1">Address</label>
                                                <input type="text" id="userCardAddress1" class="form-control" placeholder="Address #1"
                                                    name="userCardAddress1"  value="@if($card){{ $card->userCardAddress1 }}@endif" required="" >
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="userCardAddress2">Address #2</label>
                                                <input type="text" id="userCardAddress2" class="form-control" placeholder="Address #2"
                                                    name="userCardAddress2" value="@if($card){{ $card->userCardAddress2 }}@endif" required="" >
                                            </div>
                                        </div>
                                        
                                        
                                       
                                        <div class="col-md-3 col-12" >
                                          
                                            <div class="form-group">
                                                <label>Country</label>
                                              
                                                <input type="text" id="userCardCountry" class="form-control"
                                                    name="userCardCountry" placeholder="Country" value="@if($card){{ $card->userCardCountry }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-12" >
                                          
                                            <div class="form-group">
                                                <label>State</label>
                                              
                                                <input type="text" id="userCardState" class="form-control"
                                                    name="userCardState" placeholder="State" value="@if($card){{ $card->userCardState }}@endif" required="">
                                            </div>
                                        </div>
                    
                                       
                    
                    
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label for="userCardCity">City</label>
                                                <input type="text" id="userCardCity" class="form-control"
                                                    name="userCardCity" placeholder="City" value="@if($card){{ $card->userCardCity }}@endif" required="">
                                            </div>
                                        </div>
                    
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label for="userCardZip">Zip/Postal Code</label>
                                                <input type="text" id="userCardZip" class="form-control"
                                                    name="userCardZip" placeholder="Zip/Postal"  value="@if($card){{ $card->userCardZip }}@endif" required=""
                                                    >
                                            </div>
                                        </div>
                    
                    
                             
                    
                                        <div class="col-md-8 offset-md-4">
                                            <button type="submit"
                                                class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                            <a href="{{ route('customer.edit', $card->userCardCustomerId ) }}"
                                                class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
      

    </section>
</div>
@endsection




@section('after-scripts')


<script>
    $(document).ready(function () {

        // withstates
        loadCountries('creditcard', 'withstates', 'userCard', 'userCard', 1)



    });

</script>
@include('scripts.load-countries')
@include('scripts.load-states')
@endsection