@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Customer</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
    
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Update Contact Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("customer-contact.update",[$contact->userContactId]) }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row" >
          
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactFirstName">First Name</label>
                                                <input type="text" id="userContactFirstName" class="form-control" placeholder="First Name"
                                                    name="userContactFirstName" required value="@if($contact){{ $contact->userContactFirstName }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactLastName">Last Name</label>
                                                <input type="text" id="userContactLastName" class="form-control" placeholder="Last Name"
                                                    name="userContactLastName" required value="@if($contact){{ $contact->userContactLastName }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userCompany">Company</label>
                                                <input type="text" id="userContactCompany" class="form-control" placeholder="Compnay Name"
                                                    name="userContactCompany" required value="@if($contact){{ $contact->userContactCompany }}@endif" required="">
                                            </div>
                                        </div>
                    
                                        
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userCompany">Job Title</label>
                                                <input type="text" id="userContactTitle" class="form-control" placeholder="Compnay Title"
                                                    name="userContactTitle" required value="@if($contact){{ $contact->userContactTitle }}@endif" required="">
                                            </div>
                                        </div>
                    
                                        
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactEmail">Email</label>
                                                <input type="email" id="userContactEmail" class="form-control" name="userContactEmail" placeholder="Email" required
                                                    value="@if($contact){{ $contact->userContactEmail }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactPhone">Phone</label>
                                                <input type="text" id="userContactPhone" class="form-control" name="userContactPhone" placeholder="Contact Phone" required
                                                    value="@if($contact){{ $contact->userContactPhone }}@endif" required="">
                                            </div>
                                        </div>
                    
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactPhone2">Phone 2</label>
                                                <input type="text" id="userContactPhone2" class="form-control" name="userContactPhone2" placeholder="Phone 2"
                                                    value="@if($contact){{ $contact->userContactPhone2 }}@endif">
                                            </div>
                                        </div>
                    
                    
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactFax">Fax</label>
                                                <input type="text" id="userContactFax" class="form-control" name="userContactFax" placeholder="Fax"  value="@if($contact){{ $contact->userContactFax }}@endif">
                                            </div>
                                        </div>
                    
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label for="userContactGender">Gender</label>
                                                <select name="userContactGender" class="form-control">
                                                    <option value="Male" @if($contact->userContactGender  == 'Male') selected @endif>Male</option>
                                                    <option value="Female"  @if($contact->userContactGender  == 'Female') selected @endif>Female</option>
                                                </select>
                                            </div>
                                        </div>
                    
                                
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                    <a href="{{ route('customer.edit', $contact->userContactCustomerId ) }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection



