@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                        <h4 class="add_new_cust_heading">Update Net Term Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("customer-payment.update", [$card->userCardId])
                                }}" enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <div class="form-group">
                                                    <label for="userCardPaymentMethod" class="required-field">Payment Method</label>
                                                    <fieldset class="form-group mb-0">
                                                        <select class="form-control" id="userCardPaymentMethod" name="userCardPaymentMethod" required="" >
                                                            @foreach($termTermsList as $key => $term)  
                                                            @php 
                                                            if($term == 'Credit Card'){
                                                                continue;
                                                            }
                                                            @endphp
                                                            <option value="{{ $key }}" >{{ $term }}</option>
                                                            @endforeach       
                                                        </select>
                                                    </fieldset>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="userCardPaymentMethod" value="Net Term" />
                                       
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label for="userCardPayable">Account Payables's Name</label>
                                                    <input type="text" id="userCardPayable" class="form-control"
                                                        name="userCardPayable"  value="@if($card){{ $card->userCardPayable }}@endif">
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label for="userCardEmail">Account Payables's Email</label>
                                                    <input type="text" id="userCardEmail" class="form-control" 
                                                        name="userCardEmail"  value="@if($card){{ $card->userCardEmail }}@endif">
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label for="userCardPhone">Account Payables's Phone</label>
                                                    <input type="text" id="userCardPhone" class="form-control" 
                                                        name="userCardPhone"  value="@if($card){{ $card->userCardPhone }}@endif">
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <div class="form-group">
                                                    <label for="userCardLimit">Assign Credit Limit</label>
                                                    <input type="text" id="userCardLimit" class="form-control" 
                                                        name="userCardLimit" value="@if($card){{ $card->userCardLimit }}@endif" >
                                                </div>
                                            </div>
                                        
                                        
                                        
                                       
                                       
                                        
                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label for="userCardAddress1">Address</label>
                                                <input type="text" id="userCardAddress1" class="form-control" placeholder="Address #1"
                                                    name="userCardAddress1"  value="@if($card){{ $card->userCardAddress1 }}@endif" required="" >
                                            </div>
                                        </div>
                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label for="userCardAddress2">Address #2</label>
                                                <input type="text" id="userCardAddress2" class="form-control" placeholder="Address #2"
                                                    name="userCardAddress2" value="@if($card){{ $card->userCardAddress2 }}@endif" required="" >
                                            </div>
                                        </div>
                                        
                                        
                                        <div class="col-md-3 col-12" >
                                          
                                            <div class="form-group">
                                                <label>Country</label>
                                              
                                                <input type="text" id="userCardCountry" class="form-control"
                                                    name="userCardCountry" placeholder="Country" value="@if($card){{ $card->userCardCountry }}@endif" required="">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-12" >
                                          
                                            <div class="form-group">
                                                <label>State</label>
                                              
                                                <input type="text" id="userCardState" class="form-control"
                                                    name="userCardState" placeholder="State" value="@if($card){{ $card->userCardState }}@endif" required="">
                                            </div>
                                        </div>
                    
                                       
                    
                    
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label for="userCardCity">City</label>
                                                <input type="text" id="userCardCity" class="form-control"
                                                    name="userCardCity" placeholder="City" value="@if($card){{ $card->userCardCity }}@endif" required="">
                                            </div>
                                        </div>
                    
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label for="userCardZip">Zip/Postal Code</label>
                                                <input type="text" id="userCardZip" class="form-control"
                                                    name="userCardZip" placeholder="Zip/Postal"  value="@if($card){{ $card->userCardZip }}@endif" required=""
                                                    >
                                            </div>
                                        </div>
                    
                    
                             
                    
                                        <div class="col-md-6 offset-md-6">
                                            <button type="submit"
                                                class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                            <a href="{{ route('customer.edit', $card->userCardCustomerId ) }}"
                                                class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Back</a>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
      

    </section>
</div>
@endsection




@section('after-scripts')


<script>
    $(document).ready(function () {

        // withstates
        loadCountries('creditcard', 'withstates', 'userCard', 'userCard', 1)



    });

</script>
@include('scripts.load-countries')
@include('scripts.load-states')
@endsection