@extends('layouts.app')
@section('leftbar-orders-active', 'active')
@section('after-style')

<style>
.row-td-font{
    font-size: 12px;

}
</style>
@endsection
@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        {{-- <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-4 row">
                            <div class="col-8">
                           
                            </div>
                        </div>
                      </div>
                </div>
            </div> 
        </div> --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ request()->get('company') }}</h4>
                        
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>NAME</th>
                                            <th>TYPE</th>
                                            <th>STATUS</th>
                                            <th>NUMBER</th>
                                            <th>SALES</th>
                                            <th>SALES WITH TAX</th>
                                            <th>BALANCE DUE</th>
                                        </tr>
                                    </thead>
                                    <tbody id="show-customer-sales">
                                     
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                           
                                            <th id="sales-amount"></th>
                                            <th id="sales-amount-tax"></th>
                                            <th id="amount-due"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')

<script type="text/javascript">
function getMonthName(month) {
  const monthNames = [
    'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
    'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
  ];


  const monthIndex = parseInt(month, 10) - 1;

  if (monthIndex >= 0 && monthIndex < monthNames.length) {
    return monthNames[monthIndex];
  }

  return ''; 
}


function invoiceType(thetype) {


  if (thetype === 'sale') {
    return '<span style="color:green">invoice</span>';
  }

  return '<span style="color:orange">refund</span>'; 
}


function checkStatus(dateString, cstatus) {
   
  const currentDate = new Date();
  const givenDate = new Date(dateString);
  
  if(cstatus === 'credit')
  return '<span style="color:green">paid</span>';

  if (givenDate < currentDate) {
   
    return '<span style="color:red">overdue</span>';

  } else {
    
        return '<span style="color:orange">pending</span>'; 

  }
}


function formatDate(dateString) {
  const parts = dateString.split(' ');
  const datePart = parts[0];
  const timePart = parts[1];

  const date = new Date(datePart);

  if (isNaN(date)) {
    return ''; // Return an empty string or handle the invalid date case as needed
  }

  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, '0');
  const day = String(date.getDate()).padStart(2, '0');

  return `${day} ${getMonthName(month)} ${year}`;
}

    var company = "{{ request()->get('company') }}"
    var companyPrefix = "{{ auth()->user()->company->companyPrefix }}"
$(document).ready(function() {
  
    function loadItems(page) {
        $.ajax({
            url: '/customers/report/invoices-ajax?page=' + page+'&company='+company,
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                
                $.each(response.data, function(index, item) {
                    var total = item.total?? 0;
                    var invoiceShippingCharges = item.invoiceShippingCharges?? 0;
                    var invoiceCreditCardCharges = item.invoiceCreditCardCharges?? 0;
                    var invoiceChargeAmount = item.invoiceChargeAmount?? 0;
                    var invoiceTaxValue = item.invoiceTaxValue?? 0;
                       var withouttax = parseFloat(total)+parseFloat(invoiceShippingCharges)+parseFloat(invoiceCreditCardCharges)+parseFloat(invoiceChargeAmount);
                        var withtax = withouttax+parseFloat(invoiceTaxValue);
                        var duepayment= 0;
                      
                    if(checkStatus(item.invoiceDueDate, item.invoiceStatusType) === '<span style="color:red">overdue</span>'){
                            duepayment =  withtax
                    }

                    var isrefund = -1;
                    if(item.invoiceType === 'return'){
                        withouttax = withouttax*isrefund;
                        withtax = withtax*isrefund;
                        duepayment = duepayment*isrefund;
                    }
                    
                    $('#show-customer-sales').append(`<tr>
                        <td>${ formatDate(item.invoiceEndDateTime) }</td>
                        <td>${invoiceType(item.invoiceType)}</td>
                        <td>${checkStatus(item.invoiceDueDate, item.invoiceStatusType)}</td>
                        <td><a target="_blank" href="https://erp.thetechit.com/admin/pdf/invoice_pdf/${item.invoiceId}">${companyPrefix}${item.invoiceSoId}-${item.invoiceSoSerial}</a></td>
                        <td>$<span class="withouttax">${withouttax.toFixed(2)}</span></td>
                        <td>$<span class="withtax">${withtax.toFixed(2)}</span></td>
                        <td>$<span class="duepayment">${duepayment.toFixed(2)}</span></td>
                        </tr>`);
                });
                
              
                if (response.current_page < response.last_page) {
                  
                    loadItems(response.current_page + 1);
                }
                 sumamounts()

            },
            error: function(response) {
                console.log('Error:', response);
            }
        });
    }
    
    // Load items for the initial page
    loadItems(1);
});


function sumamounts(){
    var total = 0;
    var totalt = 0;
    var totaldue = 0;

    $('.withouttax').each(function() {
        var value = parseFloat($(this).text());
        if (!isNaN(value)) {
            total += value;
        }
    });
    
   $('.withtax').each(function() {
        var value = parseFloat($(this).text());
        if (!isNaN(value)) {
            totalt += value;
        }
    });

    $('.duepayment').each(function() {
        var value = parseFloat($(this).text());
        if (!isNaN(value)) {
            totaldue += value;
        }
    });
    

    $('#sales-amount').text('$' + total.toFixed(2));
    $('#sales-amount-tax').text('$' + totalt.toFixed(2));
    $('#amount-due').text('$' + totaldue.toFixed(2));

}


</script>
@endsection
