@extends('layouts.app')
@section('leftbar-orders-active', 'active')
@section('after-style')

<style>
.row-td-font{
    font-size: 12px;

}
</style>
@endsection
@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        {{-- <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-4 row">
                            <div class="col-8">
                           
                            </div>
                        </div>
                      </div>
                </div>
            </div>
        </div> --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Sales by Customers</h4>
                        
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>NAME</th>
                                            <th>INVOICE COUNT</th>
                                            <th>SALES</th>
                                            <th>SALES WITH TAX</th>
                                          
                                        </tr>
                                    </thead>
                                    <tbody id="show-customer-sales">
                                     
                                    </tbody>
                                    <tfooter>
                                        <tr>
                                            <th></th>
                                            <th></th>
                                            <th id="sales-amount"></th>
                                            <th id="sales-amount-tax"></th>
                                          
                                        </tr>
                                    </tfooter>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')

<script type="text/javascript">
    
$(document).ready(function() {
    // Function to load items via Ajax
    function loadItems(page) {
        $.ajax({
            url: '/customers/report/sales-ajax?page=' + page,
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                // Append each item to the list
                $.each(response.data, function(index, item) {

                       var withouttax = item.total+item.invoiceShippingCharges+item.invoiceCreditCardCharges+item.invoiceChargeAmount;
                        var withtax = withouttax+item.invoiceTaxValue;

                    $('#show-customer-sales').append(`<tr><td>${item.invoiceBillingCompany}</td>
                        <td><a target="_blank" href="/customers/report/invoices?company=${item.invoiceBillingCompany}">${item.totalInvoices}</a></td><td>$<span class="withouttax">${withouttax.toFixed(2)}</span></td><td>$<span class="withtax">${withtax.toFixed(2)}</span></td></tr>`);
                });
                
                // Check if there are more pages to load
                if (response.current_page < response.last_page) {
                    // Load the next page of items
                    loadItems(response.current_page + 1);
                }
                 sumamounts()

            },
            error: function(response) {
                console.log('Error:', response);
            }
        });
    }
    
    // Load items for the initial page
    loadItems(1);
});


function sumamounts(){
    var total = 0;
    var totalt = 0;

    $('.withouttax').each(function() {
        var value = parseFloat($(this).text());
        if (!isNaN(value)) {
            total += value;
        }
    });
    
   $('.withtax').each(function() {
        var value = parseFloat($(this).text());
        if (!isNaN(value)) {
            totalt += value;
        }
    });
    

    $('#sales-amount').text('$' + total.toFixed(2));
    $('#sales-amount-tax').text('$' + totalt.toFixed(2));

}


</script>
@endsection
