@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Add New Gateway</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Add New Gateway</h4>
                        <div class="card-body">
                            <form class="form" action="{{ route('store.gateway') }}" method="POST">
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Gateway Type</label>
                                                <select class="form-control" name="gatewayType" >
                                                <option value="bank">Bank</option>
                                                <option value="card">Credit Card</option>
                                                <option value="paypal">Paypal</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Name</label>

                                                <input type="text" id="name" class="form-control"
                                                    placeholder="Name" name="gatewayName" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Credit (opening balance)</label>
                                                <input type="text" id="gatewayCredit" class="form-control"
                                                    placeholder="Credit" name="gatewayCredit" required value="0" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Debit (opening balance)</label>
                                                <input type="text" id="gatewayDebit" class="form-control"
                                                    name="gatewayDebit" placeholder="Debit" required value="0" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="btn submit-btn float-right mr-1 mb-1 waves-effect waves-light">Create</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection
