@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Purchase Gateway</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')

    <div class="content-body">
        <section id="sale-order-datatable">
            <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-4 row">
                                <div class="col-8">
                                    <a href="{{ route('vendor.create') }}" target="_blank">
                                        <button type="submit" class="btn btn-primary waves-effect waves-light">Add New
                                            Vendor</button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Purchase Gateway</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead>
                                            <tr>
                                                <th class="pr-name">Name</th>

                                                <th class="pr-name">Balance</th>

                                                <th class="pr-name">Limit</th>


                                                <th class="pr-name">Available For Use</th>


                                                <th class="pr-name">Purchase</th>



                                                <th class="pr-action">Details</th>


                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($gateways as $item)
                                                <tr>


                                                    <td class="pr-name"><?php echo $item->paymentGatewayName; ?></td>


                                                    <td class="pr-name">



                                                    </td>


                                                    <td class="pr-name">

                                                    </td>


                                                    <td class="pr-name">
                                                        $<?php echo $item->paymentGatewayLimit; ?>
                                                    </td>


                                                    <td class="pr-name" style="text-align: center;">

                                                        <input type="checkbox" id="op-<?= $item->paymentGatewayId ?>"
                                                            name="" <?php if($item->paymentForPurchase == 1){?> checked <?php } ?>>
                                                    </td>

                                                    <td class="pr-action">
                                                        <a href="{{ route('gateways.show', bin2hex($item->paymentGatewayId)) }}" type="button" class="btn btn-default"><i
                                                                class="ion ion-ios-eye-outline"></i> View
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th class="pr-name">Name</th>

                                                <th class="pr-name">Balance</th>

                                                <th class="pr-name">Limit</th>


                                                <th class="pr-name">Available For Use</th>


                                                <th class="pr-name">Purchase</th>



                                                <th class="pr-action">Details</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')
    <script>
        $('#sale-order-datatable').DataTable();
    </script>
@endsection
