@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Purchase Gateway</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Gateway Items</h4>
                        <button class="btn btn-outline-primary btn-sm hide" id="proceedType"
                            onclick="showPurchaseForm()"><span><i class="feather icon-plus"></i> Add New</span></button>

                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <!-- Table with outer spacing -->
                            <div class="table-responsive">


                                <table id="datatable1" class="table table-striped">



                                    <thead>
                                        <tr>
                                            <th>DATE</th>
                                            <th>DESCRIPTION</th>
                                            <th>CATEGORY</th>
                                            <th>DEBIT</th>
                                            <th>CREDIT</th>
                                            <th>ALLOCATION</th>
                                        </tr>



                                    </thead>



                                    <tbody>


                                        @foreach ($gatewayPurchases as $item)
                                            <tr>

                                                <td>{{ date('d M-Y', strtotime($item->purchaseCreatedAt)) }}</td>

                                                <td>{{ $item->item->dealItemName }}</td>
                                                <td>Expense</td>
                                                <td>$200</td>
                                                <td>$0</td>
                                                <td>None</td>


                                            </tr>
                                        @endforeach



                                    </tbody>



                                </table>



                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="typeValues">

    </div>
@endsection
