@extends('layouts.app')
@section('leftbar-category-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Category List</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">Category List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Category List</h4>
                        <a href="{{ route('all-categories') }}"><button class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Category List</button></a>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="col-md-12 col-12">

                                            <form class="form form-vertical">
                                                <div class="form-body">
                                                    <div class="row">
                                                        <div class="col-sm-6 col-md-4">
                                                            <div class="form-group">
                                                                <label for="first-name-vertical">Category Name</label>
                                                                <input type="text" id="first-name-vertical" class="form-control" name="pname" placeholder="First Name">
                                                            </div>
                                                        </div>

                                                        <div class="col-sm-6 col-md-4">
                                                            <div class="form-group">
                                                                <label for="password-vertical">Parent Category</label>
                                                                <fieldset class="form-group mb-0">
                                                                    <select class="form-control" id="basicSelect">
                                                                        <option>Select Category</option>
                                                                            <option value="">Memory </option>
                                                                            <option value="">LTO tapes </option>
                                                                    </select>
                                                                </fieldset>
                                                            </div>
                                                        </div>

                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label for="password-vertical">Category Image</label>
                                                                <fieldset class="form-group">
                                                                    <input type="file" class="form-control-file" id="basicInputFile">
                                                                    <label for="basicInputFile">Image size not more than 100kb</label>
                                                                </fieldset></div>
                                                        </div>
                                                        <div class="col-12">
                                                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Submit</button>
                                                            <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Reset</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@section('after-scripts')
<script>
        function deleteLineItem() {
        // console.log(dealItemId);
        // console.log(dealId);
        // console.log(loop_count);

        Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!',
      confirmButtonClass: 'btn btn-primary',
      cancelButtonClass: 'btn btn-danger ml-1',
      buttonsStyling: false,
    }).then(function (result) {
      if (result.value) {
        Swal.fire(
          {
            type: "success",
            title: 'Deleted!',
            text: 'Your file has been deleted.',
            confirmButtonClass: 'btn btn-success',
          }
        )
      }
    })

    }
</script>


@endsection
