@extends('layouts.app')
@section('leftbar-brand-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Brands List</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">Brands List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-3">
                            <form>
                                <fieldset class="form-group position-relative has-icon-left">
                                    <input type="text" class="form-control round" id="searchbar"
                                        placeholder="Search">
                                    <div class="form-control-position">
                                        <i class="feather icon-search px-1"></i>
                                    </div>
                                </fieldset>
                            </form>
                        </div>
                            <div class="col-7"></div>
                               <div class="col-2">
                               <a href="{{ route('add-brand') }}"> <button class="btn btn-primary waves-effect waves-light"> <i class="feather icon-plus-circle"></i> Add Brand</button></a>
                                </div>
                        </div>
                      </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Brands List</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead class="bg-lightgrey">
                                        <tr>
                                            <th width="5%">Sr#</th>
                                            <th width="10%">Brand Name</th>
                                            <th width="20%">Parent Brand</th>
                                            <th width="20%">Image</th>
                                            <th width="20%">Status</th>
                                            <th>-</th>
                                        </tr>
                                    </thead>
                                    <tbody class="">
                                            <tr>
                                                <td>1</td>
                                                <td>LTO Tapes</td>
                                                <td>LTO 1</td>
                                                <td><img src="http://127.0.0.1:8000/app-assets/images/logo/vuesax-logo.png" alt=""></td>
                                                <td>
                                                    <span class="st-pending ord-status active_status">Active</span>
                                                </td>
                                                <td style="display: inline-flex;border: none;">
                                               <a href="#"> <i class="feather icon-edit icon_size edit_clr"></i></a> |
                                               <a href="javascript:void(0)" onclick="deleteLineItem()"><i class="feather icon-trash-2 icon_size"></i></a>
                                                </td>
                                            </tr>
                                    </tbody>
                                    <tfoot class="bg-lightgrey">
                                        <tr>
                                            <th width="5%">Sr#</th>
                                            <th width="10%">Brand Name</th>
                                            <th width="20%">Parent Brand</th>
                                            <th width="20%">Image</th>
                                            <th width="20%">Status</th>
                                            <th>-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@section('after-scripts')
<script>
        function deleteLineItem() {
        // console.log(dealItemId);
        // console.log(dealId);
        // console.log(loop_count);

        Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!',
      confirmButtonClass: 'btn btn-primary',
      cancelButtonClass: 'btn btn-danger ml-1',
      buttonsStyling: false,
    }).then(function (result) {
      if (result.value) {
        Swal.fire(
          {
            type: "success",
            title: 'Deleted!',
            text: 'Your file has been deleted.',
            confirmButtonClass: 'btn btn-success',
          }
        )
      }
    })

    }
</script>


@endsection
