<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">

<head>
    @include('layouts.head')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/data-list-view.css') }}">
    @yield('after-style')
    <style>
        .hide{
        display:none !important;
        }

        .show{
        display:block !important;
        }

      .required-field:after {
  content: " *";
    color: red;
    font-weight: 100;
}

        </style>
</head>

<body class="@yield('body-class', 'vertical-layout vertical-menu-modern 2-columns  navbar-floating footer-static')" data-open="@yield('body-data-open', 'click')"
    data-menu="@yield('body-data-menu', 'vertical-menu-modern')" data-col="@yield('body-data-col', '2-columns')">

    @include('layouts.main-menu')
    <!-- BEGIN: Content-->

    <div class="app-content content">

        <!-- BEGIN: Header-->
        @include('layouts.mobile-nav')
        <!-- END: Header-->
        <div class="@yield('div-class','content-wrapper')" style="margin-top:1px !important;">
            {{-- <div class="content-header row">
                @yield('breadcrumbs')
            </div> --}}

            @yield('content-body')

        </div>


    </div>
    <!-- END: Content-->
    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    @include('layouts.footer')
    @include('layouts.scripts')
    <script>

        function changeCompany(company_id) {

            var actionUrl = "{{ route('update_user_company') }}";
            $.ajax({
                data: {
                    company_id: company_id,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    if(response != "") {
                        window.location.reload();
                    } else {
                        alert("There might be an error. Please Try Again!")
                    }

                }
            })

        }
    </script>
    @yield('after-scripts')
    <script src="{{asset('app-assets/js/scripts/ui/data-list-view.js')}}"></script>
    <script>
        
        $(document).ready(function(){
            var variableName = "{{ session('showModal') }}"

            if(variableName === 'no'){
           
            }else{
               // $("#myModal").modal('show');
            loadAdminCompanies()
            }
        });

        function loadAdminCompanies()
  {
   
    $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
       
            $.ajax({
                type: "GET",
                url: "{{ route('load-admin-companies') }}",
                beforeSend: function() {
                  
                    $('#showadmincompanies').empty();
                    $('#showadmincompanies').html('<p>loading....</p>');
                },
                success: function(data) {
                    $("#showadmincompanies").empty();
                    $("#showadmincompanies").html(data);
            
                }
            });
        
  }

  function actionCompanyForm(whatshow){
    if(whatshow === 0){
        $('#hidecompanyform').show();
        $('#showcompanyform').hide();
    }else{
        $('#showcompanyform').show();
        $('#hidecompanyform').hide();
    }
  }
    </script>
</body>

</html>
