    <div class="row">
        <div class="col">
            @php
            $orderCompany = $order->company;
            $dealTaxValue = 0;
            $dealChargeAmount = 0;
            $dealShippingCharges = 0;
            $dealCreditCardCharges = 0;
            @endphp
        @include('partials.company-info', ['info' => $orderCompany])
        </div>
        <div class="col">

            <div class="row">
                @php
                     $orderType = 'Quote';
                     $dealStatus = $order->dealStatus;
                     $proceedTo = '';

                     if($dealStatus == 'pending'){
                        $orderType = 'Quote';
                     }else{
                        $orderType = 'Sale Order';
                     }

                     if($dealStatus == 'pending'){

                        $proceedTo = 'confirmed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'confirmed'){

                        $proceedTo = 'purchase';
                        $proceedText = 'Proceed to Purchase';

                     }else if($dealStatus == 'purchase'){

                        $proceedTo = 'placed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'placed'){

                        $proceedTo = 'closed';
                        $proceedText = 'Close Order';
                     }
                     else if($dealStatus == 'closed'){

                        $proceedTo = '';
                        $proceedText = '';
                        }

                     @endphp
                     @if($dealStatus == "pending")
                <form action="{{ route('orders.proceed-order', bin2hex($order->dealName)) }}" method="POST">
                    @csrf
                    <input type="hidden" name="orderStatus" value="{{ $proceedTo }}" />

                    <button type="submit" class="btn btn-success mr-1 mb-1 waves-effect waves-light"><i
                        class="feather icon-activity"></i> {{$proceedText}} </button>

                </form>
                @endif
                {{-- <div class="dropdown">
                    <button class="btn btn-info dropdown-toggle mr-1 waves-effect waves-light" type="button"
                        id="dropdownMenuButton3" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        References
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton3" x-placement="top-start"
                        style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, -140px, 0px);">
                        <a class="dropdown-item" href="#"><i class="feather icon-paperclip"></i> Attachments</a>
                        <a class="dropdown-item" href="#">Text</a>
                    </div>
                </div> --}}
            </div>
            <div class="row">
                <h2>{{ $orderType }}</h2>
            </div>
            <div class="row">
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>
                                <th class="invoice_top_right_tdth">Order</th>
                                <td class="invoice_top_right_tdth">{{ $order->dealName }}</td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">SO#</th>
                                <td class="invoice_top_right_tdth">
                                    {{ $order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-' }}
                                </td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">Customer Ref#</th>
                                <td class="invoice_top_right_tdth">{{ $order->dealRef }}</td>
                            </tr>
                            <tr>
                                <th class="invoice_top_right_tdth">Order Date</th>
                                <td class="invoice_top_right_tdth">
                                    {{ date('M d, yy', strtotime($order->dealCreatedAt)) }}</td>
                            </tr>

                            <tr>
                                <th class="invoice_top_right_tdth">Payment Term</th>
                                <td class="invoice_top_right_tdth">{{ $order->dealPaymentMethod }}</td>
                            </tr>

                         
                        </tbody>
                    </table>
                </div>

            </div><!-- end -->
        </div>
    </div><!-- before billing shipping completed -->

    <div class="row">
        <div class="col">
            <!-- Invoice Items Details -->
            <div id="invoice-items-details" class="pt-1 invoice-items-table">
                <div class="row">
                    <div class="table-responsive col-sm-12 p20">
                        <table class="table table-borderless">
                            <thead>
                                <tr class="bgblue_heading ">
                                    <th colspan="3" class="invoice_heading">Billing Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth">{{ $order->dealCompanyName }}
                                    </td>
                                    <td width="30%" class="invoice_top_right_tdth">{{ $order->dealPrimaryContact }}
                                    </td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth">{{ $order->dealAddress }}
                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">{{ $order->dealCity }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">{{ $order->dealState }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">{{ $order->dealPostalCode }}
                                    </td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">{{ $order->dealPhone }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">{{ $order->dealEmail }}</td>

                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">

            <!-- Invoice Items Details -->
            <div id="invoice-items-details" class="pt-1 invoice-items-table">
                <div class="row">
                    <div class="table-responsive col-sm-12">
                        <table class="table table-borderless">
                            <thead>
                                <tr class="bgblue_heading">
                                    <th colspan="3" class="invoice_heading">Shipping Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingCompany }}</td>
                                    <td width="30%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingContact }}</td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingAddress }}
                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingCity }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingState }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingZip }}</td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingPhone }}</td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        {{ $order->dealShippingEmail }}</td>

                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="table-responsive col-sm-12">
            <table class="table table-borderless border4 ">
                <thead>
                    <tr class="bgblue_heading">
                        <th class="invoice_heading">Sale Rep Name</th>
                        <th class="invoice_heading">Sale Rep Phone </th>
                        <th class="invoice_heading">Ship Via </th>
                        <th class="invoice_heading">Sale Rep Email</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ $order->created_users->firstName . ' ' . $order->created_users->lastName }}</td>
                        <td>{{ $order->created_users->phone }}</td>
                        <td>UPS Ground</td>
                        <td>{{ $order->created_users->email }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="table-responsive col-sm-12">
            <table class="table table-borderless border4 ">
                <thead>
                    <tr class="bgblue_heading">
                        <th class="invoice_heading" width="20%">PART NO. </th>
                        <th class="invoice_heading" width="40%">DESCRIPTION </th>
                        <th class="invoice_heading" width="15%">UNIT PRICE </th>
                        <th class="invoice_heading" width="10%">Qty</th>
                        <th class="invoice_heading" width="15%">Total</th>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $subtotal = 0;
                    @endphp
                    @foreach ($order->dealItems as $item)
                        <tr>
                            <td>{{ $item->dealItemName }}</td>
                            <td>{{ $item->dealItemDescription }}</td>
                            <td>{{$orderCompany->companyCurrency }} {{ $item->dealItemUnitCost }}</td>
                            <td>{{ $item->dealItemQuantity }}</td>
                            <td>{{$orderCompany->companyCurrency }}  {{ $item->dealItemUnitCost * $item->dealItemQuantity }}</td>
                            @php
                            $itemCost = $item->dealItemUnitCost * $item->dealItemQuantity;
                            $subtotal =  $subtotal + $itemCost;
                            @endphp
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>


    <div class="row justify-content-end">
        <div class="col col-md-7">
            <div class="row" style="display:none">
                <div class="col-12">
                    <table class="table table-borderless">
                        <tbody>
                            <tr class="borderbottom">
                                <th width="100%" class="invoice_top_right_tdth" colspan="3">ACH/Wire
                                    instructions </th>
                            </tr>
                            <tr>
                                <th width="25%" class="invoice_top_right_tdth">Account Title</th>
                                <td width="25%" class="invoice_top_right_tdth">IT DEVICES ONLINE INC</td>
                                <th width="25%" class="invoice_top_right_tdth">Account Number</th>
                                <td width="25%" class="invoice_top_right_tdth">80010516542</td>
                            </tr>
                            <tr>
                                <th width="25%" class="invoice_top_right_tdth">ABA / Routing Number</th>
                                <td width="25%" class="invoice_top_right_tdth">321081669</td>
                                <th width="25%" class="invoice_top_right_tdth">SWIFT Code</th>
                                <td width="25%" class="invoice_top_right_tdth">FRBBUS6S</td>
                            </tr>
                            <tr>
                                <th width="10%" class="invoice_top_right_tdth">Bank Name</th>
                                <td width="20%" class="invoice_top_right_tdth">First Republic Bank</td>
                                <th width="20%" class="invoice_top_right_tdth">Bank Address</th>
                                <td width="50%" class="invoice_top_right_tdth">111 Pine Street San Francisco, CA
                                    94111</td>

                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col bordertop ">

                    <table class="table table-borderless">
                        <tbody>
                            <!-- <tr>
                                <th width="20%" class="tbhp">Payment Due</th>
                                <td width="80%" class="tbhp">07-23-22</td>
                            </tr> -->
                            <tr>
                                <th width="20%" class="tbhp">Tracking</th>
                                <td width="80%" class="tbhp">
                                    @forelse($purchases as $purchase)
                                    {{ $purchase->purchaseTracking }} <br>
                                    @empty
                                    NA
                                    @endforelse
                                </td>
                            </tr>
                            <tr>
                                <th width="20%" class="tbhp">Serials</th>
                                <td width="80%" class="tbhp">
                                    @forelse($purchases as $purchase)
                                    {{ $purchase->purchaseSerial }} <br>
                                    @empty
                                    NA
                                    @endforelse
                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
        <div class="col-5">
            <div class="table-responsive mt25">
                <table class="table table-borderless ">
                    <tbody>
                        @if($order->dealCreditCardCharges > 0)
                        <tr class="borderbottom">
                            <th>3.5% CC Charges (if any)</th>
                            <td>{{$orderCompany->companyCurrency }}  {{ $order->dealCreditCardCharges }}</td>
                            @php 
                            $dealCreditCardCharge = $order->dealCreditCardCharge;
                            @endphp
                        </tr>
                        @endif
                        <tr class="borderbottom">
                            <th>SubTotal</th>
                            <td>{{$orderCompany->companyCurrency }}  {{ number_format($subtotal, 2)}}</td>
                        </tr>
                        <tr class="borderbottom">
                            <th>Shipping</th>
                            <td>{{$orderCompany->companyCurrency }} {{ $order->dealShippingCharges }}</td>
                            @php  $dealShippingCharges =  $order->dealShippingCharges;  @endphp
                        </tr>
                        <tr class="borderbottom">
                            <th>Charges ({{$order->dealChargeType}})</th>
                            @php  $dealChargeAmount =  $order->dealChargeAmount; 
                                if($order->dealChargeType == 'Amazon Charges'){
                                    $dealChargeAmount = $dealChargeAmount *-1;
                                }
                                @endphp
                            <td>{{$orderCompany->companyCurrency }} {{ $dealChargeAmount }}</td>
                          
                        </tr>
                        @if($order->dealTaxValue > 0)
                        <tr class="borderbottom">
                            <th>Tax({{$order->dealTaxName}})</th>

                            <td>{{$orderCompany->companyCurrency }} {{ $order->dealTaxValue }}</td>
                            @php  $dealTaxValue =  $order->dealTaxValue;  @endphp
                        </tr>
                        @endif
                        <tr>
                            <th>TOTAL</th>
                            <td>{{$orderCompany->companyCurrency }} {{ number_format($subtotal+$dealCreditCardCharges+$dealShippingCharges+$dealChargeAmount+$dealTaxValue, 2)}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
