@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('after-style')
<style>
.form-margin-control{
    margin-bottom: 0.4rem !important;
}   

    </style>
@endsection

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Sales Orders</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
    <div class="content-body">
        <section>
            <form class="form form-horizontal" action="{{ route('deal.store') }}" method="POST">
                @csrf
            <div class="card">
                <div class="card-content">
                    <div class="card-body">

                        <div class="row justify-content-around">
                            <div class="col col-lg-4 mb10 mt25">
                                @include('partials.company-info', ['info' => $orderCompany])
                                <br>
                              
                            </div>
                            <div class="col col-lg-4">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Order ID</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <input type="text" id="dealName" class="form-control"
                                                            value="{{ Auth::user()->firstName[0] . Auth::user()->lastName[0] . $data['deal_reference'] }}"
                                                            name="dealName" placeholder="Deal Name" readonly required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Customer Ref #</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <input type="text" id="dealRef" class="form-control"
                                                            name="dealRef" placeholder="Customer Ref #" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Order Date</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <input type="date" id="dealCreatedAt" class="form-control"
                                                            name="dealCreatedAt" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Payment Type</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <fieldset class="form-group mb-0">
                                                            <select class="form-control" id="basicSelect" name="">
                                                                <option value=""> Payment Method </option>
                                                                <option  value="Credit Card"> Credit Card </option>
                                                                <option  value="Paypal"> Paypal </option>
                                                                <option  value="Net Term"> Net Term </option>
                                                                <option  value="Bank Transfer"> Bank Transfer </option>
                                                                <option  value="Online-Paypal"> Online-Paypal </option>
                                                                <option  value="Amazon">Amazon</option>
                                                            </select>
                                                        </fieldset>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="form-group row">
                                                    <div class="col-md-4">
                                                        <span>Sale Person</span>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <fieldset class="form-group mb-0">
                                                            <select class="form-control" id="basicSelect">
                                                                <option>Select Sales Person</option>
                                                                @foreach ($data['sales_persons'] as $person)
                                                                    <option value="{{ $person->userId }}">
                                                                        {{ $person->firstName . ' ' . $person->lastName }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </fieldset>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!--card-content-->
            </div>
            <!-- first card end -->
            <!-- shipping billing card start -->
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-header">
                                <h4 class="card-title">Billing Address</h4>
                                <div class="form-group">
                                    <button type="button" class="btn btn-outline-success waves-effect waves-light"
                                        data-toggle="modal" data-target="#inlineForm">
                                        Existing Customer
                                    </button>

                                    <!-- Modal -->
                                    <div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog"
                                        aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                            role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="myModalLabel33">Existing Customer</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">×</span>
                                                    </button>
                                                </div>
                                                    <div class="modal-body">
                                                        <label>Customer: </label>
                                                        <div class="form-group">
                                                            <input type="text" placeholder="Search with Company Name"
                                                                class="form-control" name="modalCompanyName"
                                                                id="modalCompanyName">
                                                            <ul id="companies-box" class="list-group"></ul>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button"
                                                            class="btn btn-primary waves-effect waves-light"
                                                            data-dismiss="modal">Close</button>
                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                @include('partials.fields.input', ['input_class_name' => '', 'required' => 'required', 'input_id' => 'dealCompanyName', 'name' => 'dealCompanyName', 'placeholder' => 'Company Name', 'type' => 'text'])

                                            </div>
                                            <div class="col-md-6 col-12">
                                                
                                                @include('partials.fields.input', ['input_class_name' => '', 'required' => 'required', 'input_id' => 'dealPrimaryContact', 'name' => 'dealPrimaryContact', 'placeholder' => 'First & Last Name', 'type' => 'text'])

                                            </div>
                                            <div class="col-md-6 col-12">
                                                @include('partials.fields.input', ['input_class_name' => '', 'required' => 'required', 'input_id' => 'dealAddress', 'name' => 'dealAddress', 'placeholder' => 'Address', 'type' => 'text'])
                                            </div>
                                            <div class="col-md-6 col-12">
                                              
                                                @include('partials.fields.input', ['input_class_name' => '', 'required' => 'required', 'input_id' => 'dealCity', 'name' => 'dealCity', 'placeholder' => 'City', 'type' => 'text'])

                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <fieldset class="form-group mb-0">
                                                        <select class="form-control" id="dealState" name="dealState">
                                                            <option>Select State</option>
                                                            @foreach ($data['states'] as $state)
                                                                <option value="{{ $state->stateCode }}">
                                                                    {{ $state->stateName }}</option>
                                                            @endforeach
                                                        </select>
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealPostalCode" class="form-control"
                                                        name="dealPostalCode" placeholder="Zip/Postal" required>
                                                    <label for="dealPostalCode">Zip/Postal</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="email" id="dealEmail" class="form-control"
                                                        name="dealEmail" placeholder="Email" required>
                                                    <label for="dealEmail">Email</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="number" id="dealPhone" class="form-control"
                                                        name="dealPhone" placeholder="Phone" required>
                                                    <label for="dealPhone">Phone</label>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-header">
                                <h4 class="card-title">Shipping Address</h4>
                                <ul class="list-unstyled mb-0">
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="state_type" checked="" value="local">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">Local</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                    <li class="d-inline-block mr-2">
                                        <fieldset>
                                            <div class="vs-radio-con">
                                                <input type="radio" name="state_type" value="international">
                                                <span class="vs-radio">
                                                    <span class="vs-radio--border"></span>
                                                    <span class="vs-radio--circle"></span>
                                                </span>
                                                <span class="">International</span>
                                            </div>
                                        </fieldset>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body mt10">
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealShippingCompany" class="form-control"
                                                        placeholder="First Name" name="dealShippingCompany" required>
                                                    <label for="dealShippingCompany">Company Name</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealShippingContact" class="form-control"
                                                        placeholder="Last Name" name="dealShippingContact" required>
                                                    <label for="dealShippingContact">First & Last Name</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealShippingAddress" class="form-control"
                                                        placeholder="Address" name="dealShippingAddress" required>
                                                    <label for="dealShippingAddress">Address</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealShippingCity" class="form-control"
                                                        placeholder="City" name="dealShippingCity" required>
                                                    <label for="dealShippingCity">City</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <fieldset class="form-group mb-0">
                                                        <select class="form-control" id="dealShippingState"
                                                            name="dealShippingState">
                                                            <option>Select State</option>
                                                            @foreach ($data['states'] as $state)
                                                                <option value="{{ $state->stateCode }}">
                                                                    {{ $state->stateName }}</option>
                                                            @endforeach
                                                        </select>
                                                        <input class="form-control" placeholder="Country/State Name"
                                                            style="display: none;" type="text"
                                                            name="international_state" id="international_state">
                                                    </fieldset>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="text" id="dealShippingZip" class="form-control"
                                                        name="dealShippingZip" placeholder="Zip/Postal">
                                                    <label for="dealShippingZip">Zip/Postal</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="email" id="dealShippingEmail" class="form-control"
                                                        name="dealShippingEmail" placeholder="Email" required>
                                                    <label for="dealShippingEmail">Email</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-label-group">
                                                    <input type="number" id="dealShippingPhone" class="form-control"
                                                        name="dealShippingPhone" placeholder="Phone" required>
                                                    <label for="dealShippingPhone">Phone</label>
                                                </div>
                                            </div>
                                            <div class=" col-12">
                                                <fieldset class="checkbox">
                                                    <div class="vs-checkbox-con vs-checkbox-primary">
                                                        <input type="checkbox">
                                                        <span class="vs-checkbox">
                                                            <span class="vs-checkbox--check">
                                                                <i class="vs-icon feather icon-check"></i>
                                                            </span>
                                                        </span>
                                                        Shipping Address same as Billing Address
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- shipping billing card end -->

            <!-- customer details card start -->
            <div class="card" style="display: none">
                <div class="card-content">
                    <div class="card-body">
                        <div class="col-sm-12">
                            <div class="row client_bar">
                                <div class="col-sm-2">
                                    <p class="text-bold-600" style="text-align: center;">Client Limit</p>
                                    <p style="text-align: center;">$<span id="userLimit">0</span></p>
                                </div>

                                <div class="col-sm-2">
                                    <p class="text-bold-600" id="" style="text-align: center;">Client
                                        Receivables
                                    </p>
                                    <p style="text-align: center;">$<span id="userReceivables">0</span></p>
                                </div>
                                <div class="col-sm-2">
                                    <p class="text-bold-600" id="" style="text-align: center;">Pending Orders
                                    </p>
                                    <p style="text-align: center;">$<span id="userOrders">0</span></p>
                                </div>
                                <div class="col-sm-2">
                                    <p class="text-bold-600" id="" style="text-align: center;">Proceeded to
                                        Accounts
                                    </p>
                                    <p style="text-align: center;">$<span id="userAccounts">0</span></p>
                                </div>
                                <div class="col-sm-2">
                                    <p class="text-bold-600" id="" style="text-align: center;">Proceeded to
                                        Purchase
                                    </p>
                                    <p style="text-align: center;">$<span id="userPurchase">0</span></p>
                                </div>
                                <div class="col-sm-2">
                                    <p class="text-bold-600" style="color: red;">Remaining Limit</p>
                                    <p style="text-align: center; color: red;">$<span id="limitNote">0</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- customer details card end -->

            <!-- product repeater card start -->
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <h4 class="card-title">Line Items</h4>
                        <div class="row" >
                           
                            <div class="col-sm-12 row" id="">
                                <div class="col-md-3 form-group">
                                    <label for="dealItemName">Part #:</label>
                                
                                </div>
                               
                                <div class="col-md-2 form-group">
                                    <label for="dealItemUnitCost">Price/Unit:</label>
                                    
                                </div>
                                <div class="col-md-2 form-group">
                                    <label for="dealItemQuantity">Qty:</label>
                                  
                                </div>
                                <div class="col-md-2 form-group">
                                    <label for="dealItemTotal">Total:</label>
                                 
                                </div>
                                <div class="col-md-2 form-group">
                                    <label for="total">Brand:</label>
                                  
                                </div>
                                <div class="col-md-5 form-group">
                                    <label for="dealItemDescription">Description:</label>
                                  
                                </div>
                            </div>
                        </div>
                        <div id="add_line_item">
                        <div class="row" >
                            <input  name="dealItemId[]" type="hidden">
                            <div class="col-sm-12 row" id="product_attr_0">
                                <div class="col-md-3 form-group form-margin-control">
                                    
                                    <input type="text"  class="form-control " name="dealItemName[]"
                                        placeholder="Part #">
                                </div>
                               
                                <div class="col-md-2 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control totalUnitqty"
                                        name="dealItemUnitCost[]" onkeyup="forItemTotal()" onkeydown="forItemTotal()"
                                        placeholder="Price">
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                   
                                    <input type="text"  onchange="forItemTotal()"
                                        onkeyup="forItemTotal()" onkeydown="forItemTotal()" class="form-control"
                                        name="dealItemQuantity[]" placeholder="Qty">
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control"
                                        name="dealItemTotal[]" placeholder="0.00" disabled>
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                  
                                   
                                        <select class="form-control" name="dealItemBrand[]">
                                           
                                            <option value="1">Cisco</option>
                                            <option value="2">HP</option>
                                        </select>
                                   
                                </div>
                                <div class="col-md-5 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control"
                                        name="dealItemDescription[]" placeholder="Description">
                                </div>
                            </div>
                        </div>
                        <hr>
                        </div>
                        <div class="col-sm-12 mt-3">
                            <div class="col-md-2">
                                <button type="button" onclick="add_more()"
                                    class="btn btn-primary mr-1 mb-1 waves-effect waves-light"><i
                                        class="feather icon-plus"></i> Add</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- product repeater card end -->

            <!-- other details card start -->
            <div class="row justify-content-center">
                <div class="col-5">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <h4 class="card-title">Shipping Account</h4>

                                <div class="row mt25">
                                    <div class="col-md-6 col-12">
                                        <div class="form-label-group">
                                            <fieldset class="form-group mb-0">
                                                <select class="form-control" id="shippingAccount" name="shippingAccount">
                                                    <option>Select Shipping Account</option>
                                                    @foreach ($data['shipping_accounts'] as $shipping_account)
                                                    <option value="{{ $shipping_account->id }}">{{ $shipping_account->name }}</option>
                                                    @endforeach

                                                </select>
                                            </fieldset>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <fieldset class="form-group">
                                                <input type="text" class="form-control" id="dealShippingAccount" name="dealShippingAccount" value="00">
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="row mt25">
                                    <div class="col-12">

                                        <fieldset class="form-group">
                                            <textarea class="form-control" id="dealShippingComment" name="dealShippingComment" rows="3"
                                                placeholder="Comment"></textarea>
                                        </fieldset>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-5">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row mt25">

                                    <div class="col-md-8 ">
                                        <p class="text-bold-600">
                                            SubTotal
                                        </p>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-label-group">
                                            $000
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-7 ">
                                        <p class="text-bold-600">
                                            3.5% CC Charges (if any)
                                        </p>
                                    </div>

                                    <div class="col-md-5">
                                        <fieldset class="">
                                            
                                                <input type="number" class="form-control" id="dealCreditCardCharges" min="0" name="dealCreditCardCharges" step=".01" value="0" required="" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                        </fieldset>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-12 ">
                                        <p class="card-title ">
                                            Shipping Method</p>
                                    </div>

                                    <div class="col-7 mt8">
                                        <p class="text-bold-600">
                                            <select class="form-control required"
                                                style="border-top: none;border-left: none;border-right: none;"
                                                id="shippingAccount">
                                                <option value="1">ITD FedEx </option>
                                                <option value="2">Customer's Account</option>
                                                <option value="3">Drop Ship</option>

                                            </select>
                                        </p>
                                    </div>
                                    <div class="col-5 mt8">
                                        <fieldset class="">
                                           
                                                <input type="number" class="form-control" id="dealShippingCharges" min="0" name="dealShippingCharges" step=".01" value="0" required="" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                        </fieldset>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <a href="javascript:void(0)" data-toggle="modal"
                                                data-target="#inlineFormm">Calculate Fedex Shipping</a>

                                            <!-- Modal -->
                                            <div class="modal fade text-left" id="inlineFormm" tabindex="-1"
                                                role="dialog" aria-labelledby="myModalLabel33" style="display: none;"
                                                aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                                    role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="myModalLabel33">Fedex Shipping
                                                                Calculations</h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">×</span>
                                                            </button>
                                                        </div>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <input type="text"
                                                                        placeholder="Enter Weight In Lbs"
                                                                        class="form-control">
                                                                </div>
                                                                <ul class="list-group">
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between align-items-center">
                                                                        <span> FedEx First Overnight</span>
                                                                        <span
                                                                            class="badge badge-primary badge-pill">4</span>
                                                                    </li>
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between align-items-center">
                                                                        <span> FedEx Standard Overnight</span>
                                                                        <span
                                                                            class="badge badge-primary badge-pill">2</span>
                                                                    </li>
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between align-items-center">
                                                                        <span> FedEx 2Days </span>
                                                                        <span
                                                                            class="badge badge-primary badge-pill">1</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                    class="btn btn-primary waves-effect waves-light"
                                                                    data-dismiss="modal">Close</button>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 ">
                                        <p class="card-title ">Charges</p>
                                    </div>

                                    <div class="col-7 mt8">
                                        <p class="text-bold-600">
                                            <select class="form-control required"
                                                style="border-top: none;border-left: none;border-right: none;"
                                                id="shippingAccount">
                                                <option value="1">None </option>
                                                <option value="2">Charges</option>
                                                <option value="3">Amazon</option>

                                            </select>
                                        </p>
                                    </div>

                                    <div class="col-5 mt8">
                                        <fieldset class="">
                                            
                                       <input type="number" class="form-control" id="dealChargeAmount" min="0" name="dealChargeAmount" step=".01" value="0" required="" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                        </fieldset>
                                    </div>

                                    <div class="col-12 ">
                                        <p class="card-title ">Applied Tax</p>
                                    </div>
                                    <div class="col-7 mt8">
                                        <p class="text-bold-600">
                                            <select class="form-control required"
                                                style="border-top: none;border-left: none;border-right: none;"
                                                id="shippingAccount">
                                                <option value="1">Tax </option>
                                                <option value="3">Amazon Tax</option>
                                            </select>
                                        </p>
                                    </div>

                                    <div class="col-5 mt8">
                                        <fieldset class="">
                                           
                                     <input type="number" class="form-control" id="dealTaxValue" min="0" name="dealTaxValue" step=".01" value="0" required="" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">

                                        </fieldset>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group">
                                            <a href="javascript:void(0)" data-toggle="modal"
                                                data-target="#inlineFormmm">Calculate Tax %</a>

                                            <!-- Modal -->
                                            <div class="modal fade text-left" id="inlineFormmm" tabindex="-1"
                                                role="dialog" aria-labelledby="myModalLabel33" style="display: none;"
                                                aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                                    role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="myModalLabel33">Fedex Shipping
                                                                Calculations</h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">×</span>
                                                            </button>
                                                        </div>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <div class="row margin20">
                                                                        <p class="text-bold-600 plr10">
                                                                            what is
                                                                        </p>
                                                                        <input type="text" placeholder="percentage"
                                                                            class="form-control width20">
                                                                        <p class="text-bold-600 plr10">
                                                                            of
                                                                        </p>
                                                                        <input type="text" placeholder="amount"
                                                                            class="form-control width20">
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button"
                                                                    class="btn btn-primary waves-effect waves-light"
                                                                    data-dismiss="modal">Close</button>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="row ">
                                    <div class="col-md-8 ">
                                        <p class="text-bold-600">
                                            Total
                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-label-group">
                                            $000
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn mb-1 btn-primary btn-lg btn-block waves-effect waves-light">Create Order</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            </form>

            <!-- other details card end -->
        </section>
    </div>
@endsection

@section('after-scripts')
    <script>
        var loop_count = 0;

        function add_more() {


            var addNew = ` <div class="row" >
                            <input  name="dealItemId[]" type="hidden">
                            <div class="col-sm-12 row" id="product_attr_0">
                                <div class="col-md-3 form-group form-margin-control">
                                    
                                    <input type="text"  class="form-control" name="dealItemName[]"
                                        placeholder="Part #">
                                </div>
                               
                                <div class="col-md-2 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control totalUnitqty"
                                        name="dealItemUnitCost[]" onkeyup="forItemTotal()" onkeydown="forItemTotal()"
                                        placeholder="Price">
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                  
                                    <input type="text"  onchange="forItemTotal()"
                                        onkeyup="forItemTotal()" onkeydown="forItemTotal()" class="form-control"
                                        name="dealItemQuantity[]" placeholder="Qty">
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control"
                                        name="dealItemTotal[]" placeholder="0.00" disabled>
                                </div>
                                <div class="col-md-2 form-group form-margin-control">
                                  
                                    <fieldset class="form-group form-margin-control">
                                        <select class="form-control" name="dealItemBrand[]">
                                           
                                            <option value="1">Cisco</option>
                                            <option value="2">HP</option>
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-md-5 form-group form-margin-control">
                                   
                                    <input type="text"  class="form-control"
                                        name="dealItemDescription[]" placeholder="Description">
                                </div>
                            </div>
                        </div><hr>`;

                        $('#add_line_item').append(addNew);
        }

        function remove_more(loop_count) {
           
            jQuery('#product_attr_' + loop_count).remove();
        }

        $('#modalCompanyName').keyup(function() {
            var existing_customer_query = this.value;
            console.log(existing_customer_query);
            var actionUrl = "{{ route('existing_customer_search') }}";


            $.ajax({
                data: {
                    existing_customer_query: existing_customer_query,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    var j = 0;
                    // console.log(response);
                    $("#companies-box").show();
                    var customer_data = JSON.parse(response);
                    if (customer_data.length > 0) {
                        var str = '';
                        for (var i = 0; i < customer_data.length; i++) {

                            userId = customer_data[i]["userId"];
                            // console.log(userId);
                            userCompany = customer_data[i]["userCompany"];
                            email = customer_data[i]["email"];
                            str += '<li class="list-group-item" onClick=selectCompany(' + userId +
                                ')><a href="javascript:void(0)" style="color: #888888;font-size: 14px;"><span style="color:#1b1b1b; font-weight:600;font-size: 16px">' +
                                customer_data[i]["userCompany"] + '</span> (' + email + ' )</a></li>';
                        }


                        $("#companies-box").empty();

                        $("#companies-box").append(str);
                        j++;

                    }
                }
            })


        });

        function selectCompany(customer_id) {
            $("#companies-box").empty();
            $("#companies-box").hide();
            var actionUrl = "{{ route('get_customer_details') }}";

            $.ajax({
                data: {
                    customer_id: customer_id,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    // console.log(response);
                    var customer_details = JSON.parse(response);

                    $("input[name='userId']").val(customer_details.userId);
                    $('#modalCompanyName').val(customer_details.userCompany);
                    $("input[name='dealCompanyName']").val(customer_details.userCompany);
                    $("input[name='dealShippingCompany']").val(customer_details.userCompany);
                    $("input[name='dealPrimaryContact']").val(customer_details.firstName + ' ' +
                        customer_details.lastName);
                    $("input[name='dealShippingContact']").val(customer_details.firstName + ' ' +
                        customer_details.lastName);
                    $("input[name='dealAddress']").val(customer_details.userAddress);
                    $("input[name='dealShippingAddress']").val(customer_details.userAddress);
                    $("input[name='dealCity']").val(customer_details.userCity);
                    $("input[name='dealShippingCity']").val(customer_details.userCity);
                    $("#dealState").val(customer_details.userState);
                    $("#dealShippingState").val(customer_details.userState);
                    $("input[name='dealPostalCode']").val(customer_details.userPostalCode);
                    $("input[name='dealShippingZip']").val(customer_details.userPostalCode);
                    $("input[name='dealPhone']").val(customer_details.phone);
                    $("input[name='dealShippingPhone']").val(customer_details.phone);
                    $("input[name='dealEmail']").val(customer_details.email);
                    $("input[name='dealShippingEmail']").val(customer_details.email);
                    $('#userLimit').text(customer_details.assign_limit);

                    // remaining_limit(customer_details.userId);
                    // $('#existingModal').modal('toggle');

                }
            })

        }

        function remaining_limit(customer_id) {

            var actionUrl = "{{ route('customer_remaining_limit') }}";

            $.ajax({
                data: {
                    customer_id: customer_id,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    var result = JSON.parse(response);
                    var userReceivables = 0;

                    // console.log(customer_receivable_total);
                    if (result.receivableTotal == null) {
                        userReceivables = 0;

                    } else {
                        userReceivables = result.receivableTotal;
                    }
                    $('#userReceivables').text(userReceivables);
                    orders_limit(customer_id);
                }
            })

        }

        function orders_limit(customer_id) {
           
            var actionUrl = "{{ route('customer_orders_limit') }}";

            $.ajax({
                data: {
                    customer_id: customer_id,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {

                }
            })

        }

        $('input[type=radio][name=state_type]').change(function() {
            if (this.value == 'local') {
                $('#dealShippingState').show();
                $('#international_state').hide();

              
            } else if (this.value == 'international') {
                $('#dealShippingState').hide();
                $('#international_state').show();
              
            }
        });

        function forItemTotal() {

            var subTotal = 0;

            var totalLength = $('.totalUnitqty').length;
            // alert(totalLength);
            for (var i = 0; i < totalLength; i++) {

                var unitPrice = 'dealItemUnitCost[' + i + ']';
                var total_price_unit = 'dealItemTotal[' + i + ']';
                var qty = 'dealItemQuantity[' + i + ']';
                // alert(qty);
                var it = 'dealItemTotal[' + i + ']';
                // var dealItemQuotePrice = 'dealItemQuotePrice[' + i + ']';
                var up = $("input[name='" + unitPrice + "']").val();
                var tpu = $("input[name='" + total_price_unit + "']").val();
                var qt = $("input[name='" + qty + "']").val();

                var newval = parseFloat(up) * parseFloat(qt);
                // var quotePrice = bidingper + parseFloat(tpu);
                // console.log(bidingper)
                $("input[name='" + it + "']").val('');
                $("input[name='" + it + "']").val(newval.toFixed(2));
                // $("input[name='" + dealItemQuotePrice + "']").val(quotePrice.toFixed(2));
                subTotal = subTotal + newval
            }

            var up = $("input[name='" + unitPrice + "']").val();

            $('#subTotal').text('')
            $('#subTotal').text(subTotal.toFixed(2));


            var dealCreditCardCharges = $("input[name='dealCreditCardCharges']").val();
            var dealShippingCharges = $("input[name='dealShippingCharges']").val();
            var dealTaxValue = $("input[name='dealTaxValue']").val();
            var dealChargeType = $('#dealChargeType :selected').val();
            var dealChargeAmount = $("input[name='dealChargeAmount']").val();
            if (dealChargeType === 'Amazon Charges') {
                dealChargeAmount = -dealChargeAmount;

            }
            //var dealChargeAmount = 0;
            $('#totalPrice').text('');
            var newtotalprice = subTotal + parseFloat(dealCreditCardCharges) + parseFloat(dealShippingCharges) +
                parseFloat(
                    dealTaxValue) + parseFloat(dealChargeAmount);
            $('#totalPrice').text(newtotalprice.toFixed(2));
            $('#txtAmt').val(subTotal.toFixed(2));


        }

        $('#shippingAccount').change(function(){

            var shipping_account_id = $("#shippingAccount").val();

            var actionUrl = "{{ route('get_shipping_account_details') }}";

            $.ajax({
                data: {
                    shipping_account_id: shipping_account_id,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    var result = JSON.parse(response);
                    $('#dealShippingAccount').val(result.value);
                }
            })

        });
    </script>
@endsection
