@extends('layouts.app')
@section('leftbar-orders-active', 'active')




@section('content-body')

    <div class="content-body">

      

        <section id="sale-order-datatable">
            <div class="card m0 ">
                <div class="card-content">
                    <div class="card-body">
                        <form method="GET" action=""  >
                      
                            <div class="row ">
                                <div class="col-1">
                                </div>
                                <div class="col-8">

                                    <fieldset class="form-group position-relative has-icon-left">
                                        <input type="text" class="form-control round" name="keyword"
                                            placeholder="Search" required value="{{ \Request::get('keyword') }}">
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>

                                </div>
                                <div class="col-2">
                                    <button type="submit"  class="btn btn-primary waves-effect waves-light">Go</button>
                                </div>
                            </div>
                         </form> 
                    </div>
                </div>
            </div>
         
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Orders</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead class="bg-skyblue">
                                            <tr>
                                                <th width="5%">SO</th>
                                                <th width="10%">Date</th>
                                                <th width="20%">Customer</th>
                                                <th width="20%">Customer PO#</th>
                                                
                                                <th width="15%">Payment Type</th>
                                                <th width="20%">Status</th>
                                                <th>-</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-lightgrey">
                                            @foreach ($deals as $order)
                                                <tr>
                                                    <td class="row-td-font">{{ $order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-' }}
                                                    </td>
                                                    <td class="row-td-font">{{ date('d-M-y', strtotime($order->dealEndDateTime)) }}</td>
                                                    <td class="row-td-font">{{ $order->dealCompanyName }} </td>
                                                    <td class="row-td-font">{{ $order->dealRef }} </td>
                                                    
                                                    <td class="row-td-font">{{ $order->dealPaymentMethod }}</td>
                                                    <?php if ($order->dealStatus == 'confirmed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #c82796 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Accounts</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'purchase') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #27c8c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Purchase</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'placed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color:  #2759c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Placed</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'closed')  { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #4fc827 !important;  font-size: 10px; font-weight: bold;
                                                            ">Closed</span>

                                                    </td>
                                                    <?php } else { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #ff922c !important;  font-size: 10px; font-weight: bold;
                                                            ">Pending</span>

                                                    </td>
                                                    <?php } ?>
                                                    <!-- <td></td> -->
                                                   
                                                    <td>
                                                        <div class="btn-dropdown mr-1 mb-1">
                                                            <div class="btn-group dropdown actions-dropodown">
                                                                <button type="button"
                                                                    class="btn  px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                    data-toggle="dropdown" aria-haspopup="true"
                                                                    aria-expanded="false">
                                                                    
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <a class="dropdown-item"
                                                                        href="{{ route('orders.show', bin2hex($order->dealName)) }}"
                                                                        target="_blank"> <i
                                                                            class="feather icon-eye"></i>View</a>
                                                                    <!-- <a class="dropdown-item" href="#"><i
                                                                            class="feather icon-file"></i>Archive</a> -->
                                                                    <a class="dropdown-item" href="{{ route('pdf.order', $order->dealName) }}"><i
                                                                            class="feather icon-paperclip"></i>PDF</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                      
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

