@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('after-style')
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/datatables.min.css')}}">
<style>
.row-td-font{
    font-size: 12px;

}
</style>
@endsection
@php

$dealStatusArray = ["all" => "All Orders", "pending" => "Pending", "confirmed" => "Proceed To Accounts", "purchase" => "Proceed To Purchase", "placed" => "Order Placed", "closed" => "Order Closed"];


@endphp
@section('content-body')

    <div class="content-body">

      

        <section id="sale-order-datatable">
            <div class="card m0 d-none">
                <div class="card-content">
                    <div class="card-body">
                        <form method="POST" action="{{ route('search-po') }}"  style="display:none;">
                            @csrf 
                            <div class="row ">
                                <div class="col-3">

                                    <fieldset class="form-group position-relative has-icon-left">
                                        <input type="text" class="form-control round" name="so_number"
                                            placeholder="Search SO #" required>
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>

                                </div>
                                <div class="col-2">
                                    <button type="submit"  class="btn btn-primary waves-effect waves-light">Go</button>
                                </div>
                            </div>
                         </form> 
                    </div>
                </div>
            </div>
            <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-4">
                                {{-- <form> --}}
                                    <fieldset class="form-group position-relative has-icon-left hide">
                                        <input type="text" class="form-control round" id="searchbar"
                                            placeholder="Search">
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>
                                {{-- </form> --}}
                            </div>
                        
                             
                            <div class="col-md-8">
                            <form method="GET" action=""> 
                            <div class="row ">
                             
                             <div class="col-3 ">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealStatus" >
                                        @foreach($dealStatusArray as $key => $ds)
                                        <option value="{{ $key  }}" @if($dealStatus == $key) selected="" @endif >{{ $ds }}</option>
                                        <!-- <option value="pending">Pending</option>
                                        <option value="confirmed">Proceed To Accounts</option>
                                        <option value="purchase">Proceed To Purchase</option>
                                        <option value="placed">Order Placed</option> -->
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-3 hide">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealTermBy" id="dealTermBy">
                                      
                                        @foreach($dealTermByArray as $key => $pt)
                                        <option value="{{ $key  }}" @if(request()->get("dealTermBy") == $key) selected="" @endif >{{ $pt }}</option>
                                      
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                          
                          
                                <div class="col-3">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealMonth" id="dealMonth">
                                            <!-- <option value="all" selected="">All</option> -->
                                            @foreach($dealMonthArray as $key => $dm)
                                        <option value="{{ $key  }}" @if(request()->get("dealMonth") == $key) selected="" @elseif($key == date("m")) selected="" @endif >{{ $dm }}</option>
                                        @endforeach
                                        </select>
                                    </fieldset>
                                    </div>
                                    <div class="col-3">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealYear" id="dealYear">
                                        @foreach($dealYearArray as $key => $dy)
                                        <option value="{{ $key  }}" @if(request()->get("dealYear") == $key) selected="" @elseif($key == date("y")) selected="" @endif >{{ $dy }}</option>
                                        @endforeach
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-2">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Orders</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead class="bg-skyblue">
                                            <tr>
                                                <th width="5%">SO</th>
                                                <th width="10%">Date</th>
                                                <th width="20%">Customer</th>
                                                <th width="20%">Customer PO#</th>
                                                
                                                <th width="15%">Payment Type</th>
                                                <th width="20%">Status</th>
                                                <th width="20%">Amount</th>
                                                <th>-</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-lightgrey">
                                            @foreach ($salesOrders as $order)
                                                <tr>
                                                    <td class="row-td-font">{{ $order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-' }}
                                                    </td>
                                                    <td class="row-td-font">{{ date('d-M-y', strtotime($order->dealEndDateTime)) }}</td>
                                                    <td class="row-td-font">{{ $order->dealCompanyName }} </td>
                                                    <td class="row-td-font">{{ $order->dealRef }} </td>
                                                    
                                                    <td class="row-td-font">{{ $order->dealPaymentMethod }}</td>
                                                    <?php if ($order->dealStatus == 'confirmed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #c82796 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Accounts</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'purchase') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #27c8c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Purchase</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'placed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color:  #2759c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Placed</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'closed')  { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #4fc827 !important;  font-size: 10px; font-weight: bold;
                                                            ">Closed</span>

                                                    </td>
                                                    <?php } else { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #ff922c !important;  font-size: 10px; font-weight: bold;
                                                            ">Pending</span>

                                                    </td>
                                                    <?php } ?>
                                                    <!-- <td></td> -->
                                                    @php
                                                    $subtotal = 0;
                                                    foreach($order->dealItems as $item):
                                                    $subtotal += $item->dealItemQuantity*$item->dealItemUnitCost;
                                                   
                                                    endforeach;

                                                    $dealTaxValue = $order->dealTaxValue ? $order->dealTaxValue:0;
                                                    $dealCreditCardCharges = $order->dealCreditCardCharges ? $order->dealCreditCardCharges:0;
                                                    $dealShippingCharges = $order->dealShippingCharges ? $order->dealShippingCharges:0;
                                                    $dealChargeAmount = $order->dealChargeAmount ? $order->dealChargeAmount:0;
                                                    @endphp
                                                    <td><b>{{auth()->user()->company->companyCurrency }}{{ (double)$subtotal+(double)$dealTaxValue+(double)$dealCreditCardCharges+(double)$dealShippingCharges+(double)$dealChargeAmount }}</b></td>
                                                    <td>
                                                        <div class="btn-dropdown mr-1 mb-1">
                                                            <div class="btn-group dropdown actions-dropodown">
                                                                <button type="button"
                                                                    class="btn  px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                    data-toggle="dropdown" aria-haspopup="true"
                                                                    aria-expanded="false">
                                                                    
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <a class="dropdown-item"
                                                                        href="{{ route('orders.show', bin2hex($order->dealName)) }}"
                                                                        target="_blank"> <i
                                                                            class="feather icon-eye"></i>View</a>
                                                                    <!-- <a class="dropdown-item" href="#"><i
                                                                            class="feather icon-file"></i>Archive</a> -->
                                                                    <a class="dropdown-item" href="{{ route('pdf.order', $order->dealName) }}"><i
                                                                            class="feather icon-paperclip"></i>PDF</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                      
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')




    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')}}"></script>

    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js')}}"></script>

    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')}}"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js')}}"></script>

    <script>
     

        function searchPONumber() {

            var so_number = $("#so_number").val();
            // alert(po_number);

            var actionUrl = "{{ route('search-po') }}";

            $.ajax({
                data: {
                    so_number: so_number,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    console.log(response);
                    if(response === "false")
                    {
                        Swal.fire({
                            title: "Sorry!",
                            text: "This Order is Not Available!",
                            type: "error",
                            confirmButtonClass: 'btn btn-primary',
                            buttonsStyling: false,
                        });
                    }
                    else {
                        var number = JSON.parse(response);
                        number = number.toString();
                        // console.log(number);
                        var url = '{{ route("orders.show", ":number") }}';
                        url = url.replace(':number', number);
                        window.open(url, "_blank");
                    }


                    // $('#dealShippingAccount').val(result.value);
                }
            })
        }

        $('#search-po').submit(function(event){
            event.preventDefault();

                var form = $(this);
                var actionUrl = form.attr('action');

                $.ajax({
                    type: "POST",
                    url: actionUrl,
                    data: form.serialize(), // serializes the form's elements.
                    success: function(data) {
                        alert(data); // show response from the php script.
                    }
                });
        });

    </script>
@endsection
