@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('content-body')
<div class="content-body">
    <section>

        <form class="" action="{{ route('invoices.store', bin2hex($order->dealSO)) }}" method="POST">
            @csrf
         
        <div class="card">
            <div class="card-content">
                <div class="card-body">

                    <div class="row justify-content-around">
                        <div class="col col-lg-4 mb10 mt25">
                            @php 
                            $orderCompany = $order->company;
                            @endphp
                        @include('partials.company-info', ['info' => $orderCompany])
                        </div>
                        <div class="col col-lg-4">
                          
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>{{ $inv_type }} ID</span>
                                                </div>
                                                <div class="col-md-8">
                                                    <span>{{ $orderCompany->companyPrefix; }}{{  $order->dealSO }}-{{ $invoiceSoSerial }}</span>
                                                </div>
                                                
                                                    <input type="hidden" value="{{ $invoiceSoSerial }}" class="form-control" name="invoiceSoSerial"  >
                                            
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Customer PO #</span>
                                                </div>
                                                <div class="col-md-8">
                                                    <input type="text" id="dealRef" class="form-control"
                                                        name="invoiceReference" placeholder="Customer Ref #" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Order Date</span>
                                                </div>
                                                <div class="col-md-8">
                                                    <input type="date" id="invoiceEndDateTime" class="form-control"
                                                        name="invoiceEndDateTime" placeholder="Mobile">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Payment Type</span>
                                                </div>
                                                <div class="col-md-8">
                                                    <fieldset class="form-group mb-0">
                                                        <select class="form-control" id="invoicePaymentMethod" name="invoicePaymentMethod">
                                                            <option>Credit Card</option>
                                                            <option>Net terms</option>
                                                        </select>
                                                    </fieldset>
                                                </div>
                                            </div>
                                        </div>
                                        

                                    </div>
                                </div>
                          
                        </div>
                    </div>

                </div>
            </div>
            <!--card-content-->
        </div>
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col">
                @include('orders.invoices.partials.billing')
            </div>
            <div class="col">
                @include('orders.invoices.partials.shipping')
            </div>
        </div>
        <!-- shipping billing card end -->




        <!-- product repeater card start -->
       @include('orders.invoices.partials.line-items')
        <!-- product repeater card end -->

        <!-- other details card start -->
        <div class="row justify-content-center">
            <div class="col-5">
                @include('orders.invoices.partials.other-info')
            </div>
            <div class="col-5">
                @include('orders.invoices.partials.calculation')
            </div>
        </div>

    </form>
        <!-- other details card end -->
    </section>
</div>

@endsection

@section('after-scripts')
    <script>
        function deleteItemRow(id){
            $('#row-item-'+id).remove()
        }
    </script>
@endsection
