@extends('layouts.app')
@section('after-style')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/app-todo.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/plugins/file-uploaders/dropzone.css') }}">
    <script src="https://cdn.ckeditor.com/4.16.1/standard/ckeditor.js"></script>



@endsection
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Invoice</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">Invoice
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')

    <div class="card">
        <div class="card-content">
            <div class="card-body">

                <div class="row justify-content-around">
                    <div class="col col-lg-4 mb10 mt25">
                        <img src="https://cdn.varstreet.com/VarstreetXCStoreDesign/6925//Store_1142//Logo//Logo1541201589541717137.png"
                            style="height: 65px;">
                        <h2 class="company_name">IT Devices Online Inc</h2>
                        <h5 class="company_address">
                            2121 North California Blvd Suite 290,
                            Walnut Creek, CA-94596, USA</h5>
                        <h5>866-585-5130</h5>
                        <h5>www.itdevicesonline.com</h5>
                    </div>
                    <div class="col col-lg-4">
                        <form class="form form-horizontal">
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-6">
                                                <span>Invoice ID</span>
                                            </div>
                                            <div class="col-md-6">
                                                {{ $invoice->deal->company->companyPrefix . $invoice->invoiceSoId . ' - ' . $invoice->invoiceSoSerial }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-6">
                                                <span>Customer PO #</span>
                                            </div>
                                            <div class="col-md-6">
                                                <input type="hidden" id="invoiceId" name="invoiceId"
                                                    value="{{ $invoice->invoiceId }}">
                                                <div id="invoiceReference-edit" class="hide">
                                                    <input type="text" id="invoiceReference" class="form-control"
                                                        name="invoiceReference" placeholder="Customer Ref #"
                                                        value="{{ $invoice->invoiceReference }}" required>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceReferenceAction('invoiceReference', 'save', {{ $invoice->invoiceId }})"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceReferenceAction('invoiceReference', 'cancel')"> <i
                                                            class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="invoiceReference-non-edit">
                                                    <span
                                                        id="invoiceReference-value">{{ $invoice->invoiceReference }}</span>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceReferenceAction('invoiceReference', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>

                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span>Invoice Date</span>
                                            </div>
                                            <div class="col-md-8">
                                                <div id="invoiceEndDateTime-edit" class="hide">
                                                    <input type="date" id="invoiceEndDateTime" class="form-control"
                                                        name="invoiceEndDateTime" placeholder="Customer Ref #"
                                                        value="{{ date('Y-m-d', strtotime($invoice->invoiceEndDateTime)) }}"
                                                        required>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceEndDateTimeAction('invoiceEndDateTime', 'save', {{ $invoice->invoiceId }})"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceEndDateTimeAction('invoiceEndDateTime', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="invoiceEndDateTime-non-edit">
                                                    <span
                                                        id="invoiceEndDateTime-value">{{ date('M d, Y', strtotime($invoice->invoiceEndDateTime)) }}</span>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoiceEndDateTimeAction('invoiceEndDateTime', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span>Payment Type</span>
                                            </div>
                                            <div class="col-md-8">
                                                <div id="invoicePaymentMethod-edit" class="hide">
                                                    <div class="col-md-8">
                                                        <fieldset class="form-group mb-0">
                                                            <select class="form-control" id="invoicePaymentMethod"
                                                                name="invoicePaymentMethod" required>
                                                                <option value=""> Payment Method </option>
                                                                <option value="Credit Card"> Credit Card </option>
                                                                <option value="Paypal"> Paypal </option>
                                                                <option value="Net Term"> Net Term </option>
                                                                <option value="Bank Transfer"> Bank Transfer </option>
                                                                <option value="Online-Paypal"> Online-Paypal </option>
                                                                <option value="Amazon">Amazon</option>
                                                            </select>
                                                        </fieldset>
                                                    </div>

                                                    <a href="javascript:void(0)"
                                                        onclick="invoicePaymentMethodAction('invoicePaymentMethod', 'save', {{ $invoice->invoiceId }})"><i
                                                            class="feather icon-check" style="color: #6495ed;"></i></a>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoicePaymentMethodAction('invoicePaymentMethod', 'cancel')">
                                                        <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                                </div>
                                                <div id="invoicePaymentMethod-non-edit">
                                                    <span
                                                        id="invoicePaymentMethod-value">{{ $invoice->invoicePaymentMethod }}</span>
                                                    <a href="javascript:void(0)"
                                                        onclick="invoicePaymentMethodAction('invoicePaymentMethod', 'edit')"><i
                                                            class="feather icon-edit-2"></i></a>
                                                </div>

                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
        <!--card-content-->
    </div>
    <!-- first card end -->
    <!-- shipping billing card start -->
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-content">
                    <div class="card-header">
                        <h4 class="card-title">Billing Address</h4>
                        <div class="form-group">

                            <!-- Modal -->
                            <div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog"
                                aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title" id="myModalLabel33">Existing Customer</h4>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                        </div>
                                        <form action="#">
                                            <div class="modal-body">
                                                <label>Customer: </label>
                                                <div class="form-group">
                                                    <input type="text" placeholder="Search with Company Name"
                                                        class="form-control" name="existing-customer-input"
                                                        id="existing-customer-input">
                                                    <ul id="companies-box" class="list-group"></ul>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-primary waves-effect waves-light"
                                                    data-dismiss="modal">Close</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="form">
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-6 col-12">
                                        <h5>Company Name</h5>
                                        <div id="invoiceBillingCompany-edit" class="hide">
                                            <input type="text" id="invoiceBillingCompany" class="form-control"
                                                name="invoiceBillingCompany" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingCompany }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCompanyAction('invoiceBillingCompany', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCompanyAction('invoiceBillingCompany', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingCompany-non-edit">
                                            <span
                                                id="invoiceBillingCompany-value">{{ $invoice->invoiceBillingCompany }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCompanyAction('invoiceBillingCompany', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <h5>Primary Contact</h5>
                                        <div id="invoiceBillingContact-edit" class="hide">
                                            <input type="text" id="invoiceBillingContact" class="form-control"
                                                name="invoiceBillingContact" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingContact }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingContactAction('invoiceBillingContact', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingContactAction('invoiceBillingContact', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingContact-non-edit">
                                            <span
                                                id="invoiceBillingContact-value">{{ $invoice->invoiceBillingContact }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingContactAction('invoiceBillingContact', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Address</h5>
                                        <div id="invoiceBillingAddress-edit" class="hide">
                                            <input type="text" id="invoiceBillingAddress" class="form-control"
                                                name="invoiceBillingAddress" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingAddress }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingAddressAction('invoiceBillingAddress', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingAddressAction('invoiceBillingAddress', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingAddress-non-edit">
                                            <span
                                                id="invoiceBillingAddress-value">{{ $invoice->invoiceBillingAddress }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingAddressAction('invoiceBillingAddress', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>City</h5>
                                        <div id="invoiceBillingCity-edit" class="hide">
                                            <input type="text" id="invoiceBillingCity" class="form-control"
                                                name="invoiceBillingCity" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingCity }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCityAction('invoiceBillingCity', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCityAction('invoiceBillingCity', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingCity-non-edit">
                                            <span id="invoiceBillingCity-value">{{ $invoice->invoiceBillingCity }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingCityAction('invoiceBillingCity', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>State</h5>
                                        <div id="invoiceBillingState-edit" class="hide">
                                            <div class="col-md-8">
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="invoiceBillingState"
                                                        name="invoiceBillingState">
                                                        <option>Select State</option>
                                                        @foreach ($data['states'] as $state)
                                                            <option value="{{ $state->stateCode }}">
                                                                {{ $state->stateName }}</option>
                                                        @endforeach
                                                    </select>
                                                </fieldset>
                                            </div>

                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingStateAction('invoiceBillingState', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingStateAction('invoiceBillingState', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingState-non-edit">
                                            <span
                                                id="invoiceBillingState-value">{{ $invoice->billingState->stateName }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingStateAction('invoiceBillingState', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Zip/Postal Code</h5>
                                        <div id="invoiceBillingZip-edit" class="hide">
                                            <input type="text" id="invoiceBillingZip" class="form-control"
                                                name="invoiceBillingZip" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingZip }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingZipAction('invoiceBillingZip', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingZipAction('invoiceBillingZip', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingZip-non-edit">
                                            <span id="invoiceBillingZip-value">{{ $invoice->invoiceBillingZip }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingZipAction('invoiceBillingZip', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Email</h5>
                                        <div id="invoiceBillingEmail-edit" class="hide">
                                            <input type="text" id="invoiceBillingEmail" class="form-control"
                                                name="invoiceBillingEmail" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingEmail }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingEmailAction('invoiceBillingEmail', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingEmailAction('invoiceBillingEmail', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingEmail-non-edit">
                                            <span
                                                id="invoiceBillingEmail-value">{{ $invoice->invoiceBillingEmail }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingEmailAction('invoiceBillingEmail', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>


                                    <div class="col-md-6 col-12">
                                        <h5>Phone</h5>
                                        <div id="invoiceBillingPhone-edit" class="hide">
                                            <input type="text" id="invoiceBillingPhone" class="form-control"
                                                name="invoiceBillingPhone" placeholder="Customer Ref #"
                                                value="{{ $invoice->invoiceBillingPhone }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingPhoneAction('invoiceBillingPhone', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingPhoneAction('invoiceBillingPhone', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceBillingPhone-non-edit">
                                            <span
                                                id="invoiceBillingPhone-value">{{ $invoice->invoiceBillingPhone }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceBillingPhoneAction('invoiceBillingPhone', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <div class="card-content">
                    <div class="card-header">
                        <h4 class="card-title">Shipping Address</h4>
                        <ul class="list-unstyled mb-0">
                            <li class="d-inline-block mr-2">
                                <fieldset>
                                    <div class="vs-radio-con">
                                        <input type="radio" name="vueradio" checked="" value="false">
                                        <span class="vs-radio">
                                            <span class="vs-radio--border"></span>
                                            <span class="vs-radio--circle"></span>
                                        </span>
                                        <span class="">Local</span>
                                    </div>
                                </fieldset>
                            </li>
                            <li class="d-inline-block mr-2">
                                <fieldset>
                                    <div class="vs-radio-con">
                                        <input type="radio" name="vueradio" value="false">
                                        <span class="vs-radio">
                                            <span class="vs-radio--border"></span>
                                            <span class="vs-radio--circle"></span>
                                        </span>
                                        <span class="">International</span>
                                    </div>
                                </fieldset>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body mt10">
                        <form class="form">
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-6 col-12">
                                        <h5>Company Name</h5>
                                        <div id="invoiceShippingCompany-edit" class="hide">
                                            <input type="text" id="invoiceShippingCompany" class="form-control"
                                                name="invoiceShippingCompany" placeholder="Company Name"
                                                value="{{ $invoice->invoiceShippingCompany }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCompanyAction('invoiceShippingCompany', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCompanyAction('invoiceShippingCompany', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingCompany-non-edit">
                                            <span
                                                id="invoiceShippingCompany-value">{{ $invoice->invoiceShippingCompany }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCompanyAction('invoiceShippingCompany', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Primary Contact</h5>
                                        <div id="invoiceShippingContact-edit" class="hide">
                                            <input type="text" id="invoiceShippingContact" class="form-control"
                                                name="invoiceShippingContact" placeholder="Primary Contact"
                                                value="{{ $invoice->invoiceShippingContact }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingContactAction('invoiceShippingContact', 'save', {{ $invoice->invoiceId }}, {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingContactAction('invoiceShippingContact', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingContact-non-edit">
                                            <span
                                                id="invoiceShippingContact-value">{{ $invoice->invoiceShippingContact }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingContactAction('invoiceShippingContact', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Address</h5>
                                        <div id="invoiceShippingAddress-edit" class="hide">
                                            <input type="text" id="invoiceShippingAddress" class="form-control"
                                                name="invoiceShippingAddress" placeholder="Address"
                                                value="{{ $invoice->invoiceShippingAddress }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingAddressAction('invoiceShippingAddress', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingAddressAction('invoiceShippingAddress', 'cancel')">
                                                <i class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingAddress-non-edit">
                                            <span
                                                id="invoiceShippingAddress-value">{{ $invoice->invoiceShippingAddress }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingAddressAction('invoiceShippingAddress', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>City</h5>
                                        <div id="invoiceShippingCity-edit" class="hide">
                                            <input type="text" id="invoiceShippingCity" class="form-control"
                                                name="invoiceShippingCity" placeholder="City"
                                                value="{{ $invoice->invoiceShippingCity }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCityAction('invoiceShippingCity', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCityAction('invoiceShippingCity', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingCity-non-edit">
                                            <span
                                                id="invoiceShippingCity-value">{{ $invoice->invoiceShippingCity }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingCityAction('invoiceShippingCity', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>State</h5>
                                        <div id="invoiceShippingState-edit" class="hide">
                                            <div class="col-md-8">
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="invoiceShippingState"
                                                        name="invoiceShippingState">
                                                        <option>Select State</option>
                                                        @foreach ($data['states'] as $state)
                                                            <option value="{{ $state->stateCode }}">
                                                                {{ $state->stateName }}</option>
                                                        @endforeach
                                                    </select>
                                                </fieldset>
                                            </div>

                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingStateAction('invoiceShippingState', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingStateAction('invoiceShippingState', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingState-non-edit">
                                            <span
                                                id="invoiceShippingState-value">{{ $invoice->shippingState->stateName }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingStateAction('invoiceShippingState', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Zip/Postal</h5>
                                        <div id="invoiceShippingZip-edit" class="hide">
                                            <input type="text" id="invoiceShippingZip" class="form-control"
                                                name="invoiceShippingZip" placeholder="Zip/Postal"
                                                value="{{ $invoice->invoiceShippingZip }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingZipAction('invoiceShippingZip', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingZipAction('invoiceShippingZip', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingZip-non-edit">
                                            <span id="invoiceShippingZip-value">{{ $invoice->invoiceShippingZip }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingZipAction('invoiceShippingZip', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>


                                    <div class="col-md-6 col-12">
                                        <h5>Email</h5>
                                        <div id="invoiceShippingEmail-edit" class="hide">
                                            <input type="text" id="invoiceShippingEmail" class="form-control"
                                                name="invoiceShippingEmail" placeholder="Email"
                                                value="{{ $invoice->invoiceShippingEmail }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingEmailAction('invoiceShippingEmail', 'save', {{ $invoice->invoiceId }}, {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingEmailAction('invoiceShippingEmail', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingEmail-non-edit">
                                            <span
                                                id="invoiceShippingEmail-value">{{ $invoice->invoiceShippingEmail }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingEmailAction('invoiceShippingEmail', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5>Phone</h5>
                                        <div id="invoiceShippingPhone-edit" class="hide">
                                            <input type="text" id="invoiceShippingPhone" class="form-control"
                                                name="invoiceShippingPhone" placeholder="Phone"
                                                value="{{ $invoice->invoiceShippingPhone }}" required>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingPhoneAction('invoiceShippingPhone', 'save', {{ $invoice->invoiceId }})"><i
                                                    class="feather icon-check" style="color: #6495ed;"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingPhoneAction('invoiceShippingPhone', 'cancel')"> <i
                                                    class="feather icon-x" style="color: #d71a1c;"></i></a>
                                        </div>
                                        <div id="invoiceShippingPhone-non-edit">
                                            <span
                                                id="invoiceShippingPhone-value">{{ $invoice->invoiceShippingPhone }}</span>
                                            <a href="javascript:void(0)"
                                                onclick="invoiceShippingPhoneAction('invoiceShippingPhone', 'edit')"><i
                                                    class="feather icon-edit-2"></i></a>
                                        </div>
                                    </div>
                                    <div class=" col-12">
                                        <fieldset class="checkbox">
                                            <div class="vs-checkbox-con vs-checkbox-primary">
                                                <input type="checkbox">
                                                <span class="vs-checkbox">
                                                    <span class="vs-checkbox--check">
                                                        <i class="vs-icon feather icon-check"></i>
                                                    </span>
                                                </span>
                                                Shipping Address same as Billing Address
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shipping billing card end -->

    <!-- product repeater card start -->
    <div class="card">
        <div class="card-content">
            <div class="card-body">
                <h4 class="card-title">Line Items</h4>
                @php
                    $loop_count_numm = 0;
                    // $item_count = 1;
                @endphp
                <input type="hidden" name="items_count" id="items_count" value="{{ $invoiceItems->count() }}">
                @foreach ($invoiceItems as $item)
                    @php
                        $loop_count_prev = $loop_count_numm;
                    @endphp
                    <div class="row" id="product_attribute_box">
                        <input id="paid" name="paid[]" value="{{ $item->invoiceItemId }}" type="hidden">
                        <div class="col-sm-12 row" id="product_attr_{{ $loop_count_numm }}">
                            <div class="col-md-2 form-group">
                                <label for="invoiceItemName">Part #:</label>
                                <input type="text" id="invoiceItemName_{{ $loop_count_numm }}" class="form-control"
                                    name="invoiceItemName[]" value="{{ $item->invoiceItemName }}" placeholder="Part #">
                            </div>
                            <div class="col-md-3 form-group">
                                <label for="invoiceItemDescription">Description:</label>
                                <input type="text" id="invoiceItemDescription_{{ $loop_count_numm }}"
                                    class="form-control" name="invoiceItemDescription[]"
                                    value="{{ $item->invoiceItemDescription }}" placeholder="Description">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="invoiceItemUnitCost">Price/Unit:</label>
                                <input type="text" id="invoiceItemUnitCost_{{ $loop_count_numm }}"
                                    class="form-control totalUnitqty" name="invoiceItemUnitCost[{{ $loop_count_numm }}]"
                                    value="{{ $item->invoiceItemUnitCost }}" onkeyup="forItemTotal()"
                                    onkeydown="forItemTotal()" placeholder="Price">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="invoiceItemQuantity">Qty:</label>
                                <input type="text" id="invoiceItemQuantity_{{ $loop_count_numm }}"
                                    class="form-control" name="invoiceItemQuantity[{{ $loop_count_numm }}]"
                                    value="{{ $item->invoiceItemQuantity }}" onchange="forItemTotal()"
                                    onkeyup="forItemTotal()" onkeydown="forItemTotal()" placeholder="Qty">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="total">Total:</label>
                                <input type="text" id="invoiceItemTotal_{{ $loop_count_numm }}" class="form-control"
                                    name="invoiceItemTotal[{{ $loop_count_numm }}]"
                                    value="{{ $item->invoiceItemQuantity * $item->invoiceItemUnitCost }}"
                                    placeholder="0.00" disabled>
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="total">Brand:</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="brand[]" id="brand_{{ $loop_count_numm }}">
                                        <option>Select Brand</option>
                                        <option>Cisco</option>
                                        <option>HP</option>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-md-4 " style="    align-self: center;">
                                <div class=" float_left">
                                    <button type="button"
                                        onclick="updateLineItem({{ $loop_count_numm }}, {{ $item->invoiceItemId }})"
                                        class="btn btn-primary mr-1 mb-1 waves-effect waves-light float_left">
                                        <i class="feather icon-save"></i></button>
                                </div>
                                {{-- <div class=" float_left">
                                <a onclick='return confirm("Are you sure you want to delete this?")' href="{{ route('orders.item-delete', ['itemId'=>$item->invoiceItemId,'dealId'=>"$invoice->invoiceId"]) }}">
                                    <button type="button" class="btn btn-danger mr-1 mb-1 waves-effect waves-light">
                                    <i class="feather icon-minus" aria-hidden="true"></i>&nbsp;Delete</button>
                                </a>
                            </div> --}}
                                <div class=" float_left">
                                    <button
                                        onclick="deleteLineItem({{ $item->invoiceItemId }}, {{ $invoice->invoiceId }}, {{ $loop_count_numm }})"
                                        type="button" class="btn btn-danger mr-1 mb-1 waves-effect waves-light">
                                        <i class="feather icon-trash" aria-hidden="true"></i>&nbsp;Delete</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" id="loop_count_numm" value="{{ $loop_count_numm++ }}">
                @endforeach
            </div>
            <div class="col-sm-12">
                <div class="col-md-2">
                    {{-- @if ($loop_count_numm == 2) --}}
                    <button type="button" onclick="add_more()"
                        class="btn btn-primary mr-1 mb-1 waves-effect waves-light"><i class="feather icon-plus"></i>
                        Add</button>
                    {{-- @endif --}}
                </div>
            </div>
        </div>
    </div>
    <!-- product repeater card end -->

    <!-- other details card start -->
    <div class="row justify-content-center">
        <div class="col-5">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <h4 class="card-title">Shipping Account</h4>

                        <div class="row mt25">
                            <div class="col-md-6 col-12">
                                <div class="form-label-group">
                                    <fieldset class="form-group mb-0">
                                        <select class="form-control" id="basicSelect">
                                            <option>ITD Fedex</option>
                                            <option>ITD Fedex</option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <fieldset class="form-group">
                                    <input type="text" class="form-control" value="1234667">
                                </fieldset>
                            </div>
                        </div>
                        <div class="row mt25">
                            <div class="col-12">

                                <fieldset class="form-group">
                                    <textarea class="form-control" id="basicTextarea" rows="3" placeholder="Textarea"></textarea>
                                </fieldset>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
        <div class="col-5">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row mt25">

                            <div class="col-md-8 ">
                                <p class="text-bold-600">
                                    SubTotal
                                </p>
                            </div>

                            <div class="col-md-4">
                                <div class="form-label-group">
                                    $000
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-7 ">
                                <p class="text-bold-600">
                                    3.5% CC Charges (if any)
                                </p>
                            </div>

                            <div class="col-md-5">
                                <fieldset class="">
                                    <input type="text" class="form-control" id="basicInput"
                                        placeholder="Enter email">
                                </fieldset>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-12 ">
                                <p class="card-title ">
                                    Shipping Method</p>
                            </div>

                            <div class="col-7 mt8">
                                <p class="text-bold-600">
                                    <select class="form-control required"
                                        style="border-top: none;border-left: none;border-right: none;"
                                        id="shippingAccount">
                                        <option value="1">ITD FedEx </option>
                                        <option value="2">Customer's Account</option>
                                        <option value="3">Drop Ship</option>

                                    </select>
                                </p>
                            </div>
                            <div class="col-5 mt8">
                                <fieldset class="">
                                    <input type="text" class="form-control" id="basicInput" placeholder="Enter email"
                                        value="0">
                                </fieldset>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#inlineFormm">Calculate
                                        Fedex Shipping</a>

                                    <!-- Modal -->
                                    <div class="modal fade text-left" id="inlineFormm" tabindex="-1" role="dialog"
                                        aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                            role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="myModalLabel33">Fedex Shipping
                                                        Calculations</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">×</span>
                                                    </button>
                                                </div>
                                                <form action="#">
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <input type="text" placeholder="Enter Weight In Lbs"
                                                                class="form-control">
                                                        </div>
                                                        <ul class="list-group">
                                                            <li
                                                                class="list-group-item d-flex justify-content-between align-items-center">
                                                                <span> FedEx First Overnight</span>
                                                                <span class="badge badge-primary badge-pill">4</span>
                                                            </li>
                                                            <li
                                                                class="list-group-item d-flex justify-content-between align-items-center">
                                                                <span> FedEx Standard Overnight</span>
                                                                <span class="badge badge-primary badge-pill">2</span>
                                                            </li>
                                                            <li
                                                                class="list-group-item d-flex justify-content-between align-items-center">
                                                                <span> FedEx 2Days </span>
                                                                <span class="badge badge-primary badge-pill">1</span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button"
                                                            class="btn btn-primary waves-effect waves-light"
                                                            data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 ">
                                <p class="card-title ">Charges</p>
                            </div>

                            <div class="col-7 mt8">
                                <p class="text-bold-600">
                                    <select class="form-control required"
                                        style="border-top: none;border-left: none;border-right: none;"
                                        id="shippingAccount">
                                        <option value="1">None </option>
                                        <option value="2">Charges</option>
                                        <option value="3">Amazon</option>

                                    </select>
                                </p>
                            </div>

                            <div class="col-5 mt8">
                                <fieldset class="">
                                    <input type="text" class="form-control" id="basicInput" placeholder="Enter email"
                                        value="0">
                                </fieldset>
                            </div>

                            <div class="col-12 ">
                                <p class="card-title ">Applied Tax</p>
                            </div>
                            <div class="col-7 mt8">
                                <p class="text-bold-600">
                                    <select class="form-control required"
                                        style="border-top: none;border-left: none;border-right: none;"
                                        id="shippingAccount">
                                        <option value="1">Tax </option>
                                        <option value="3">Amazon Tax</option>
                                    </select>
                                </p>
                            </div>

                            <div class="col-5 mt8">
                                <fieldset class="">
                                    <input type="text" class="form-control" id="basicInput" placeholder="Enter email"
                                        value="0">
                                </fieldset>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <a href="javascript:void(0)" data-toggle="modal"
                                        data-target="#inlineFormmm">Calculate Tax %</a>

                                    <!-- Modal -->
                                    <div class="modal fade text-left" id="inlineFormmm" tabindex="-1" role="dialog"
                                        aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
                                            role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="myModalLabel33">Fedex Shipping
                                                        Calculations</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">×</span>
                                                    </button>
                                                </div>
                                                <form action="#">
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <div class="row margin20">
                                                                <p class="text-bold-600 plr10">
                                                                    what is
                                                                </p>
                                                                <input type="text" placeholder="percentage"
                                                                    class="form-control width20">
                                                                <p class="text-bold-600 plr10">
                                                                    of
                                                                </p>
                                                                <input type="text" placeholder="amount"
                                                                    class="form-control width20">
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button"
                                                            class="btn btn-primary waves-effect waves-light"
                                                            data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row ">
                            <div class="col-md-8 ">
                                <p class="text-bold-600">
                                    Total
                                </p>
                            </div>
                            <div class="col-md-4">
                                <div class="form-label-group">
                                    $000
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    @include('orders.scripts.modify-invoice')
@endsection
