@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('after-style')
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/datatables.min.css')}}">
<style>
.row-td-font{
    font-size: 12px;

}
</style>
@endsection
@php

$dealStatusArray = ["all" => "All Orders", "pending" => "Pending", "confirmed" => "Proceed To Accounts", "purchase" => "Proceed To Purchase", "placed" => "Order Placed", "closed" => "Order Closed"];


@endphp
@section('content-body')

    <div class="content-body">

      

        <section id="sale-order-datatable">
            <div class="card m0 ">
                @if(count($notInOrders) > 0)
            <h2 style="
    text-align: center;
    color: red;
    padding-top: 56px;
">{{ count($notInOrders) }} records not found in database</h2>
           @endif
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Orders</h4>
                            <a href="https://reporting.thetechit.com/orders/list-check" class="btn btn-primary waves-effect waves-light btn-sm">BACK</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead class="bg-skyblue">
                                            <tr>
                                                <th width="50%">SO</th>
                                                <th width="50%">Ref</th>
                                            
                                            </tr>
                                        </thead>
                                        <tbody class="bg-lightgrey">
                                            @foreach ($notInOrders as $order)
                                                <tr>
                                                    <td class="row-td-font"><?php print_r($order['dealSO']) ?></td>
                                                    <td class="row-td-font"><?php print_r($order['dealRef']) ?></td>
                                                   
                                                  
                                                  
                                                 
                                            
                                               
                                                </tr>
                                            @endforeach
                                        </tbody>
                                      
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')




    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')}}"></script>

    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js')}}"></script>

    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')}}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')}}"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js')}}"></script>

   
@endsection
