@php 

$dealDepartments = ['1' => 'Commercial', '2' => 'GSA', '3' => 'Bidding', '4' => 'Amazon'];
@endphp
<section id="basic-information">
    <div class="row match-height">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Basic Information</h4>
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <form class="form" action="{{ route('orders.store-basic', $slug) }}" method="POST" style="padding: 20px;">
                            @csrf
                            <div class="form-body">
                          
                                </div>  <div class="row">
                                    <div class="col-12 col-md-8">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Customer </span>
                                            </div>
                                            <div class="col-md-12">
                                                <select class="form-control" id="search" style="width:500px;" name="user_id"></select>

                                              <input type="text" name="dealUserId" id="dealUserId" value="0" style="display: none" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Department #</span>
                                            </div>
                                            <div class="col-md-12">
                                                <select class="form-control" id="dealDepartmentId"
                                                name="dealDepartmentId">
                                                @foreach($dealDepartments as $key => $department)
                                                <option value="{{ $key }}"> {{ $department }}</option>
                                                @endforeach
                                 
                                            </select>
                                            </div>
                                        </div>
                                    </div>
                                 
                                    <div class="col-12 col-md-4 hide">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Order ID</span>
                                            </div>
                                            <div class="col-md-12">
                                                <input type="text" id="dealName" class="form-control"
                                                    value="{{ $deal_reference }}"
                                                    name="dealName" placeholder="Deal Name" readonly required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Ref #</span>
                                            </div>
                                            <div class="col-md-12">
                                                <input type="text" id="dealRef" class="form-control" name="dealRef"
                                                    placeholder="Customer Ref #"  value="@if($deal) {{ $deal->dealRef }} @endif" required autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Order Date</span>
                                            </div>
                                            <div class="col-md-12">
                                                <input type="date" id="dealEndDateTime" class="form-control"
                                                    name="dealEndDateTime" value="@if($deal) {{ $deal->dealEndDateTime }} @endif" required>
                                            </div>
                                        </div>
                                    </div>
                                
                                    <div class="col-12 col-md-4">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Payment Type</span>
                                            </div>
                                            <div class="col-md-12">
                                                <fieldset class="form-group mb-0" id="dealPaymentMethodList">
                                                   
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="form-group ">
                                            <div class="col-md-12 header-info">
                                                <span class="order-title-mini">Sale Person</span>
                                            </div>
                                            <div class="col-md-12">
                                                <fieldset class="form-group mb-0">
                                                    <select class="form-control" id="dealsalePerson"
                                                        name="dealsalePerson">
                                                        @foreach ($salereps as $person)
                                                        <option value="{{ $person->userId }}">
                                                            {{ $person->firstName . ' ' . $person->lastName }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light btn-sm float-right">Save & Countinue</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>