@extends('layouts.app')
@section('after-style')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/pages/app-todo.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/file-uploaders/dropzone.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/plugins/file-uploaders/dropzone.css')}}">
    <script src="https://cdn.ckeditor.com/4.16.1/standard/ckeditor.js"></script>


    <style>
        .inv-bill-ship-head{
            font-size: 11px;
    padding-top: 10px;
    padding-bottom: 10px;
    font-weight: 500;
    color: black;
        }
        </style>

    @endsection
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Invoice</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">Invoice
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')
@include('orders.partials.attachments-dropzone')

    <section id="invoice_body">


    </section>
    @include('partials.form-sidebar')
@endsection

@section('after-scripts')
<script src="{{asset('app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
<script src="{{asset('app-assets/js/scripts/extensions/dropzone.js')}}"></script>
 
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>


    <script>
        $(document).ready(function() {
            loadOrder();
            $('#order-pdf').attr("href", "{{ route('pdf.order', $slug) }}");
            $('#order-modify').attr("href", "{{ route('orders.edit', $slug) }}");

            
        });

        $('.edit-input-onclick').click(function() {
            alert("HWEW");
            console.log(this.id);
        });

        function loadOrder() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: "GET",
                url: "{{ route('orders.details', $slug) }}",
                beforeSend: function() {

                    //loader here
                    $("#invoice_body").empty();
                    //
                    $("#invoice_body").html("<h2>Loading...</h2>");
                },
                success: function(data) {
                    $("#invoice_body").empty();
                    $("#invoice_body").html(data);

                }
            });

        }

        function loadEditForm() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: "GET",
                url: "{{ route('orders.modify', $slug) }}",
                beforeSend: function() {

                    //loader here
                    $("#invoice_body").empty();
                    //
                    $("#invoice_body").html("<h2>Loading...</h2>");
                },
                success: function(data) {
                    console.log(data);
                    $("#invoice_body").empty();
                    $("#invoice_body").html(data);

                }
            });

        }



        function refreshSection(){
            
        $('#dropzone-form').removeClass('show')
        $('#dropzone-form').addClass('hide')

        }


    </script>
    @include('orders.scripts.purchases')
    @include('orders.scripts.attachments')
    @include('orders.scripts.receivables')


    @include('orders.scripts.invoices')
    @include('orders.scripts.activity')
<script>
    CKEDITOR.replace( 'dealRefrenceText' );
</script>
@endsection
