@extends('layouts.app')
@section('after-style')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js" defer></script>
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/file-uploaders/dropzone.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/plugins/file-uploaders/dropzone.css')}}">
    <script src="https://cdn.ckeditor.com/4.16.1/standard/ckeditor.js"></script>
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/plugins/forms/wizard.css')}}">

    <script src="{{asset('app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
    <script src="{{asset('app-assets/js/scripts/extensions/dropzone.js')}}"></script>
 
</head>
    @endsection

@section('breadcrumbs')

@endsection

@section('content-body')
@if ($errors->any())
    <div class="alert alert-danger">
        <strong>Whoops!</strong> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
@php
 $orderRoute = Route::currentRouteName();
@endphp
<section id="colored-avatar">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Create Order  </h4>
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-basic', $slug) }}" class="chip-body">
                                <div class="avatar bg-primary">
                                    <span>BS</span>
                                </div>
                                <span class="chip-text">Basic Information</span>
                            </a>
                        </div>
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-address', $slug) }}" class="chip-body">
                                <div class="avatar bg-success">
                                    <span>BS</span>
                                </div>
                                <span class="chip-text">Billing & Shipping</span>
                            </a>
                        </div>
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-line-items', $slug) }}" class="chip-body">
                                <div class="avatar bg-info">
                                    <span>LI</span>
                                </div>
                                <span class="chip-text">Line Items</span>
                            </a>
                        </div>
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-other-charges', $slug) }}" class="chip-body">
                                <div class="avatar bg-danger">
                                    <span>OC</span>
                                </div>
                                <span class="chip-text">Other Charges</span>
                            </a>
                        </div>
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-references', $slug) }}" class="chip-body">
                                <div class="avatar bg-secondary">
                                    <span>RE</span>
                                </div>
                                <span class="chip-text">References</span>
                            </a>
                        </div>
                        <div class="chip mr-1">
                            <a href="{{ route('orders.create-line-items', $slug) }}" class="chip-body">
                                <div class="avatar bg-warning">
                                 
                                    <i class="feather icon-eye text-white"></i>
                                  
                                </div>
                                <span class="chip-text">Preview</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@if($orderRoute == 'orders.create-basic')
@include('orders.partials.wizard.basic-information')
@endif
@if($orderRoute == 'orders.create-address')
@include('orders.partials.wizard.address-information')
@endif
@if($orderRoute == 'orders.create-line-items')
@include('orders.partials.wizard.line-items')
@endif
@if($orderRoute == 'orders.create-other-charges')

@include('orders.partials.wizard.other-charges')
@endif
@if($orderRoute == 'orders.create-references')

@include('orders.partials.wizard.references')
@endif




@endsection

@section('after-scripts')
<script src="{{asset('app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
<script src="{{asset('app-assets/js/scripts/extensions/dropzone.js')}}"></script>

@if($orderRoute == 'orders.create-basic')
@include('orders.scripts.new-order.basic-information')
@endif
@if($orderRoute == 'orders.create-address')
@include('orders.scripts.new-order.address-information')
@endif
@if($orderRoute == 'orders.create-line-items')
@include('orders.scripts.new-order.line-items')
@endif
@if($orderRoute == 'orders.create-other-charges')

@include('orders.scripts.new-order.other-charges')
@endif
@if($orderRoute == 'orders.create-references')
@include('orders.scripts.new-order.references')
@endif
@endsection
