@extends('layouts.app')
@section('leftbar-orders-active', 'active')



@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Update  Details</h4>
                        <div class="card-body">
                            <form method="POST" action="{{ route("payables.update", $payable->payableId) }}" enctype="multipart/form-data"> 
                                @method('PUT')
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Tracking Number</label>
                                                <input type="text" id="payableTrackingNumber" class="form-control"
                                                    placeholder="Tracking Number" value="{{ $payable->payableTrackingNumber }}" name="payableTrackingNumber" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Invoice Number</label>
                                                <input type="text" id="payableInvoiceNumber" class="form-control"
                                                    placeholder="Invoice Number" value="{{ $payable->payableInvoiceNumber }}" name="payableInvoiceNumber" required>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-12">
                                            <div class="form-group">
                                                <label>Invoice Date</label>
                                              
                                                            @php $date=date_create($payable->payableInvoiceDate); @endphp 
                                             

                                              
                                                
                                                <input type="date" id="payableInvoiceDate" class="form-control"
                                                    name="payableInvoiceDate" value="{{ date_format($date,"Y-m-d") }}" placeholder="Invoice Date" required>
                                            </div>
                                        </div>
                                        <div class="col-md-8 col-12">
                                            <div class="form-group">
                                                    @php
                                                    $payablere = [0 => 'Default', 1 => 'Return'];
                                                    @endphp
                                                     <label>Payable Type</label>
                                                    <select name="payableReturn" class="form-control">
                                                        @foreach($payablere as $ke => $paye)
                                                        <option value="{{ $ke }}" @if($payable->payableReturn == $ke) selected="" @endif>{{ $paye }}</option>
                                                        @endforeach
                                                    </select>
                                                    
                                            </div>
                                        </div>
                                    

                                     



                                    </div>
                                </div>
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="btn submit-btn mr-1 mb-1 waves-effect waves-light">Update</button>
                                    <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Reset</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection
