<!DOCTYPE html>
<html>

<head>
	<title></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

</head>

<body>

    <h1 class="text-center mt-3 mb-3">{{ $bank->bankAccountTitle }}</h1>
    <table class="table zero-configuration">
        <thead>
            <tr>
                <th>Date</th>
                <th>Category</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Allocation</th>
                <th>Refrence</th>
             
            </tr>
        </thead>
        <tbody>
            @foreach ($transactions as $transaction)
                <tr>
                    @php 
                    $date = date_create($transaction->reportBankDate);
                    @endphp
                    <td>{{ date_format($date,"d/M/Y") }}</td>
                    <td>{{ $transaction->reportBankCategory}}</td>
                    <td>@if($transaction->reportBankDebit){{ auth()->user()->company->companyCurrency.''.$transaction->reportBankDebit }}@else - @endif</td>
                    <td>@if($transaction->reportBankCredit){{ auth()->user()->company->companyCurrency.''.$transaction->reportBankCredit }}@else - @endif</td>
                    <td>{{ $transaction->reportBankAllocation }}</td>
                    <td>{{ $transaction->reportBankRefrence }}</td>
                  
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th>Date</th>
                <th>Category</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Allocation</th>
                <th>Refrence</th>
        
            </tr>
        </tfoot>
    </table>
                
</body>

</html>
