@extends('layouts.app')
@section('after-style')
 <style>
    .hfont{
        font-size: 0.84rem;
        color: #318a8a;

    }
 </style>


<script src="https://cdn.ckeditor.com/4.16.1/standard/ckeditor.js"></script>

@endsection
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Invoice</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">Invoice
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content-body')

    <div class="card">
        <div class="card-content">
            <div class="card-body">

                <div class="row justify-content-around">
                    <div class="col col-lg-7 mb10 pl25" style="    padding-left: 68px;
                    ">
                    @php
                    $orderCompany = $deal->company;
                    @endphp
                                @include('partials.company-info', ['info' => $orderCompany])

                    </div>
                    <div class="col col-lg-5">
              
                            <div class="form-body mt25">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span class="hfont">Invoice ID</span>
                                            </div>
                                            @php 
                                                $range = range("A", "Z");
        
                                               $dealSoSerial = $range[$groupid-1];
                                            @endphp
                                            <div class="col-md-8">
                                                {{ $deal->company->companyPrefix . $soid.$dealSoSerial }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span class="hfont">Customer PO #</span>
                                            </div>
                                            <div class="col-md-8">{{ $deal->dealRef }}

                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span class="hfont">Invoice Date</span>
                                            </div>
                                            <div class="col-md-8">
                                        
                                                {{ date('M d, Y', strtotime($deal->dealEndDateTime)) }}
                                                    
                                            
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span class="hfont">Payment Type</span>
                                            </div>
                                            <div class="col-md-8">
                                              
                                                @include('purchase.partial.payment')
                                          
                                                    

                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span class="hfont">Vendor</span>
                                            </div>
                                            <div class="col-md-8">
                                              
                                                @include('purchase.partial.vendor')
                                          
                                                    

                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                       
                    </div>
                </div>

            </div>
        </div>
        <!--card-content-->
    </div>
    <!-- first card end -->
    <!-- shipping billing card start -->
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-content">
                    <div class="card-header">
                        <h4 class="card-title">Billing Address</h4>
                        
                    </div>
                    <div class="card-body">
                        
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Company Name</h5>
                                       
                                        <div id="invoiceBillingCompany-non-edit">
                                            <span
                                                id="invoiceBillingCompany-value">{{ $deal->dealCompanyName }}</span>
                                            
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Primary Contact</h5>
                                        
                                        <div >
                                            {{ $deal->dealPrimaryContact }}
                                          
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Address</h5>
                                       
                                        <div id="invoiceBillingAddress-non-edit">
                                            <span
                                                id="invoiceBillingAddress-value">{{ $deal->dealAddress }}</span>
                                           
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">City</h5>
                                        
                                        <div id="invoiceBillingCity-non-edit">
                                            <span id="invoiceBillingCity-value">{{ $deal->dealCity }}</span>
                                           
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">State</h5>
                                       
                                        <div id="invoiceBillingState-non-edit">
                                            <span
                                                id="invoiceBillingState-value">{{ $deal->dealState }}</span>
                                        
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Zip/Postal Code</h5>
                                       
                                        <div id="invoiceBillingZip-non-edit">
                                            <span id="invoiceBillingZip-value">{{ $deal->dealPostalCode }}</span>
                                           
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Email</h5>
                                        
                                        <div id="invoiceBillingEmail-non-edit">
                                            <span
                                                id="invoiceBillingEmail-value">{{ $deal->dealEmail }}</span>
                                           
                                        </div>
                                    </div>


                                    <div class="col-md-6 col-12">
                                        <h5 class="hfont">Phone</h5>
                                       
                                        <div id="invoiceBillingPhone-non-edit">
                                            <span
                                                id="invoiceBillingPhone-value">{{ $deal->dealPhone }}</span>
                                            
                                        </div>
                                    </div>


                                </div>
                            </div>
                      
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card">
                <div class="card-content">
                    <div class="card-header">
                        <h4 class="card-title">Shipping Address</h4>
                     
                    </div>
                    <div class="card-body mt10">
                   
                        @include('purchase.partial.billing-shipping')
                       

                    </div>
                </div>
            </div>
        </div>
    </div>
   

    <!-- product repeater card start -->
    <div class="card">
        <div class="card-content">
            <div class="card-body">
                <h4 class="card-title">Line Items</h4>
             
               
                    
                @php
                $subtotal = 0;
             @endphp
                @foreach ($purchases as $item)
                    
                    <div class="row" id="product_attribute_box">
                        <input id="paid" name="paid[]" value="{{ $item->item->dealItemId }}" type="hidden">
                        <div class="col-sm-12 row" id="product_attr_{{ $item->item->dealItemId }}">
                            <div class="col-md-2 form-group">
                                <label for="invoiceItemName">Part #:</label>
                                <input type="text"  class="form-control" readonly value="{{ $item->item->dealItemName }}" placeholder="Part #">
                            </div>
                            <div class="col-md-3 form-group">
                                <label for="invoiceItemDescription">Description:</label>
                                <input type="text" readonly
                                    class="form-control" 
                                    value="{{ $item->item->dealItemDescription }}" placeholder="Description">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="purchasePrice">Price/Unit:</label>
                                <input type="text" id="purchasePrice_{{ $item->item->dealItemId }}"
                                    class="form-control totalUnitqty" readonly
                                    value="{{ $item->purchasePrice }}"  placeholder="Price">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="purchaseActualItems">Qty:</label>
                                <input type="text" id="purchaseActualItems_{{ $item->item->dealItemId }}"
                                    class="form-control"
                                    value="{{ $item->purchaseActualItems }}" readonly min="1" placeholder="Qty">
                            </div>
                            <div class="col-md-2 form-group">
                                <label for="total">Total:</label>
                                <input type="text" id="invoiceItemTotal_{{ $item->item->dealItemId }}" class="form-control"
                                    value="{{ $item->purchaseActualItems * $item->purchasePrice }}"
                                    placeholder="0.00" disabled>
                            </div>
                            @php  $subtotal =  $subtotal+($item->purchaseActualItems * $item->purchasePrice) @endphp
                            <div class="col-md-1 " style="    align-self: center;">
                                
                                <div class=" float_left">
                                    <a href="javascript:void(0)" onclick="getPurchaseItem({{ $item->purchaseId }})" data-toggle="modal"
                                        data-target="#animation2"  class="btn btn-warning mr-1 mb-1 btn-sm waves-effect waves-light">
                                        <i class="feather icon-edit" aria-hidden="true"></i>&nbsp;</a>
                                    
                                </div>
                              
                            </div>
                        </div>
                    </div>
                    
                @endforeach
            </div>
          
        </div>
    </div>
    <!-- product repeater card end -->
    <div class="modal text-left" id="animation2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel6"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel6">Purchase Item</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="show-item">
               
               

            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
    <!-- other details card start -->
    <div class="row justify-content-center">
        <div class="col-7">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <h4 class="card-title">Comment</h4>

                     
                        <div class="row mt25">
                            <div class="col-12">

                                <fieldset class="form-group">
                                    @include('purchase.partial.comment')
                                </fieldset>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
        <div class="col-5">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row mt25">

                            <div class="col-md-8 ">
                                <p class="text-bold-600">
                                    SubTotal
                                </p>
                            </div>

                            <div class="col-md-4">
                                <div class="form-label-group">
                                    $<span id="subtotal">{{  $subtotal }}</span>
                                </div>
                            </div>

                        </div>
                       

                        <div class="row">
                            

                           
                          
                          

                           

                            <div class="col-7 mt8">
                                <p class="text-bold-600">
                                    Tax
                                </p>
                            </div>

                            <div class="col-5 mt8">
                                <fieldset class="">
                               

                                        @include('purchase.partial.tax')

                                </fieldset>
                            </div>

                           
                            <div class="col-7 mt8">
                                <p class="text-bold-600">
                                    Shipping
                                </p>
                            </div>

                            <div class="col-5 mt8">
                                <fieldset class="">
                                    @include('purchase.partial.shipping')
                                </fieldset>
                            </div>

                            

                        </div>
                        <div class="row ">
                            <div class="col-md-8 ">
                                <p class="text-bold-600">
                                    Total
                                </p>
                            </div>
                            <div class="col-md-4">
                                <div class="form-label-group">
                                    $<span id="overall">{{  $subtotal+$purchases[0]->purchaseShipping+$purchases[0]->purchaseTax }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="row ">
                            <div class="col-md-7 ">
                                <p class="text-bold-600">
                                   
                                </p>
                            </div>
                            <div class="col-md-5">
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection


@section('after-scripts')

<script>
    CKEDITOR.replace('purcharseComments');


function getPurchaseItem(pid){


$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

    $.ajax({
        type: "POST",
        url: "{{ route('orders.purchase-item-show') }}",
        data: {pid:pid},
        beforeSend: function () {
            //  $(".dealItemName").css("background","#FFF");
        },
        success: function (data) {

            $('#show-item').empty()
            $('#show-item').html(data)

     


           

        }
    });


}
</script>

@endsection