<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/bootstrap.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <title>Quick Access</title>
</head>
<body>
    <div class="container">
      <nav class="navbar navbar-expand-lg navbar-light bg-light">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Quick Access</a>
    <button
      class="navbar-toggler"
      type="button"
      data-mdb-toggle="collapse"
      data-mdb-target="#navbarNav"
      aria-controls="navbarNav"
      aria-expanded="false"
      aria-label="Toggle navigation"
    >
      <i class="fas fa-bars"></i>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link active" aria-current="page" href="https://erp.thetechit.com/admin/dashboard">Dashboard</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="#sales">Sales</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="#accounts">Accounts</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="#purchase">Purchase</a>
        </li>
        
      </ul>
    </div>
  </div>
</nav>
        <br>
 <input type="text" name="searchli" id="searchli" autocomplete="off" class="form-control" placeholder="Search....">
      
        <br>
        <section id="sales">
      
          <h2>Sales</h2>
          <p>NA</p>
          <div class="row ">
            <div class="col-md-3">
              <ul>
                <li><a href="https://reporting.thetechit.com/reports/sales/register?dealMonth=01" target="_blank">Sale Register</a></li>
                <!-- <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li> -->
              </ul>
            </div>
            <div class="col-md-3 ">
             <!--  <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
            <div class="col-md-3">
           <!--    <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
            <div class="col-md-3">
           <!--    <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
          </div>
        </section>
        <section id="accounts">
      
          <h2>Accounts</h2>
          <div class="row ">
            <div class="col-md-3">
              <ul>
                <li><a href="{{ route('uninvoiced-orders') }}" target="_blank">Uninvoiced Sales Orders</a></li>
                <li><a href="{{ route('unallocated-invoices') }}" target="_blank" >Unallocated Invoices</a></li>
                 <li><a href="{{ route('customers-sales') }}" target="_blank">Sales by Customers</a></li>
                {{--<li><a href="#">Contact Us</a></li> --}}
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
                <li><a href="{{ route('payables.index') }}" target="_blank">Purchase Receiving</a></li>
                <li><a href="/orders/list-check">Orders List</a></li>
                 {{--<li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li> --}}
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
               <li><a href="{{ route('journal-entry.create') }}" target="_blank">New Journal Entry</a></li>
                <li><a href="{{ route('journals.index') }}" target="_blank"> Journal Entries</a></li>
                {{-- <li><a href="#">Contact Us</a></li> --}}
              </ul>

            </div>
            <div class="col-md-3">
              <ul>
      
              </ul>
            </div>
          </div>
        </section>
        <section id="purchase">
      
          <h2>Purchase</h2>
          
          <div class="row ">
            <div class="col-md-3">
              <ul>
                <li><a href="https://reporting.thetechit.com/reports/purchase/register?purchaseMonth=01" target="_blank">Purchase Register</a></li>
                <!-- <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li> -->
               <!--  <li><a href="#">Contact Us</a></li> -->
              </ul>
            </div>
            <div class="col-md-3">
              <!-- <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
            <div class="col-md-3">
              <!-- <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
            <div class="col-md-3">
              <ul>
      
              </ul>
            </div>
          </div>
        </section>
   
        <section id="payment-gateways">
      
          <h2>Payment Gateways</h2>
          @php

          $banks = \App\Models\Bank::select('bankId', 'bankAccountTitle')->where('bankCompanyId', auth()->user()->userCompanyId)->get();
          $cards = \App\Models\PaymentGateway::select('paymentGatewayId', 'paymentGatewayName','paymentGatewayType')->where('paymentGatewayCompanyId', auth()->user()->userCompanyId)->get();


@endphp
          <div class="row ">
            <div class="col-md-3">
              <ul>
                <li style="list-style: none"> <b>Cards</b></li>
                @foreach($cards as $card)

                @if($card->paymentGatewayType == 'Paypal')
                @else
               <li> <a href="{{ route('card.transactions') }}?selected_card={{ bin2hex($card->paymentGatewayId) }}" target="_blank"><span class="menu-item" >{{ $card->paymentGatewayName }} <span class="text-mute text-warning" style="font-size: 10px;">({{ $card->paymentGatewayType }})</span></span></a></li>

                @endif
                @endforeach
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
                <li style="list-style: none"><b>Banks</b></li>
        
                @foreach($banks as $bank)
                <li><a href="{{ route('bank.transactions') }}?selected_bank={{ bin2hex($bank->bankId) }}"><span class="menu-item" >{{ $bank->bankAccountTitle }}</span> <span class="text-mute text-warning"  style="font-size: 10px;">(Bank)</span></a></li>
                @endforeach
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
                <li style="list-style: none"><b>Others</b></li>
                @foreach($cards as $card)
                @if($card->paymentGatewayType == 'Paypal')
                <li><a href="{{ route('card.transactions') }}?selected_paypal={{ bin2hex($card->paymentGatewayId) }}" target="_blank"><span class="menu-item" >{{ $card->paymentGatewayName }} <span class="text-mute text-warning" style="font-size: 10px;">({{ $card->paymentGatewayType }})</span></span></a></li>
              
                @endif
                @endforeach
              </ul>
            </div>
            <div class="col-md-3">
              <!-- <ul>
                <li><a href="#">Home</a></li>
                <li><a href="#">About</a></li>
                <li><a href="#">Clients</a></li>
                <li><a href="#">Contact Us</a></li>
              </ul> -->
            </div>
          </div>
        </section>
        <section id="loans">
      
          <h2>Loans</h2>
          <div class="row ">
           
          
            <div class="col-md-3">
              <ul>
                <li><a href="{{ route('user-loan-create') }}" target="_blank">New Loan</a></li>

                <li><a href="{{ route('other-receivables-loans') }}" target="_blank">Other Receivables Loans</a></li>
      
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
      
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
      
              </ul>
            </div>
            <div class="col-md-3">
              <ul>
      
              </ul>
            </div>
          </div>
        </section>
      </div>
      <!-- /container -->
      <script type="text/javascript">
        var input = document.getElementById("searchli");
var lists = document.querySelectorAll("ul");

// Add event listener to the input element to listen for changes
input.addEventListener("keyup", function() {
  // Get the user's input and convert it to lowercase
  var filter = input.value.toLowerCase();
  
  // Loop through each list and each item within the list and hide those that do not match the filter
  for (var i = 0; i < lists.length; i++) {
    var list = lists[i];
    for (var j = 0; j < list.children.length; j++) {
      var item = list.children[j];
      var text = item.textContent.toLowerCase();
      if (text.indexOf(filter) !== -1) {
        item.style.display = "block";
      } else {
        item.style.display = "none";
      }
    }
  }
});
      </script>
</body>
</html>
