@extends('layouts.app')
@section('leftbar-orders-active', 'active')



@section('breadcrumbs')

@endsection

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">


        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $payment_gateway->bankAccountTitle }}</h4>
                        <form action="" method="GET">
                            <div class="row">
                                <div class="col-md-6 ">

                                    <fieldset class="form-group">
                                        <select class="form-control" name="category_name">
                                            <option value="all">SELECT CATEGORY </option>
                                            @foreach($categories as $category)
                                            <option value="{{ $category->reportBankCategory }}" 
                                            @if(request()->get('category_name') == $category->reportBankCategory) selected @endif
                                            >{{ $category->reportBankCategory }}</option>
                                            @endforeach
                                        </select>

                                    </fieldset>

                                </div>
                                <div class="col-md-6 ">
                                    <button class="btn btn-success">Search</button>
                                </div>


                            </div>
                        </form>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead class="bg-skyblue">
                                        <tr>
                                            <th class="or-date">Date
                                            </th>
                                            <th class="or-date">Description
                                            </th>
                                            <th class="or-p-s">Category
                                            </th>
                                            <th class="pr-name">Debit
                                            </th>
                                            <th class="pr-name">Credit
                                            </th>
                                            <th class="pr-name">Allocation
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-lightgrey">


                                        @forelse($bank_details as $item)
                                        <tr>

                                            <td>{{ date('d-m-Y', strtotime($item->reportBankCreatedAt)) }}</td>
                                            <td>{{ $item->reportBankDescription }}</td>
                                            <td> {{ $item->reportBankCategory }}</td>
                                            <td>@if($item->reportBankDebit) ${{ $item->reportBankDebit }} @else - @endif </td>
                                            <td>@if($item->reportBankCredit) ${{ $item->reportBankCredit }} @else - @endif</td>
                                            <td>{{ $item->reportBankAllocation }} </td>
                                        </tr>

                                        @empty
                                        <p>Not found</p>
                                        @endforelse
                                    </tbody>
                                    <tfoot class="bg-skyblue">
                                        <tr>
                                            <th class="or-date">Date
                                            </th>
                                            <th class="or-date">Description
                                            </th>
                                            <th class="or-p-s">Category
                                            </th>
                                            <th class="pr-name">Debit
                                            </th>
                                            <th class="pr-name">Credit
                                            </th>
                                            <th class="pr-name">Allocation
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            {{ $bank_details->appends(request()->input())->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
</div>
@endsection

@section('after-scripts')

@endsection