@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Income</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-style')
@endsection
@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-12 ">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Edit Income Info</h4>
                        <div class="card-body">
                            <form class="form repeater-default" action="{{ route('incomes.update-info', $income->incomeId) }}" method="POST" 
                            enctype="multipart/form-data">
                                @csrf
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Head of Accounts</label>

                                                <select class="form-control" name="incomeHoaId">
                                                  @foreach($hoas as $hoa)
                                                  <option value="{{ $hoa->hoavId }}" @if($income->incomeHoaId == $hoa->hoavId) selected @endif>{{ $hoa->hoavName }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Vendors</label>

                                                <select class="form-control" name="incomeVendorId">
                                                  @foreach($vendors as $vendor)
                                                    <option value="{{ $vendor->hoavId }}" @if($income->incomeVendorId == $vendor->hoavId) selected @endif>{{ $vendor->hoavName }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Invoice No</label>

                                                <input type="text" id="incomeInvoiceNo" class="form-control"
                                                    name="incomeInvoiceNo" placeholder="Invoice No" value="{{ $income->incomeInvoiceNo }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Payment Method</label>

                                                <select class="form-control" name="incomePaymentMethod" onchange="addDays()">
                                                  @for($i=0; $i<61; $i++)
                                                    @if($i == 0)
                                                    <option value="Net Term 1" data-days="1" @if($income->incomePaymentMethod == 'Net Term 1') selected @endif>Net Term 1</option>

                                                    @else
                                                    <option value="Net Term {{ $i }}" data-days="{{ $i }}"  @if($income->incomePaymentMethod == 'Net Term '.$i) selected @endif>Net Term {{ $i }}</option>
                                                    @endif
                                                    @php $i = $i+4; @endphp
                                                    @endfor
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Invoice Date</label>
                                                @php $date=date_create($income->incomeEndDateTime); @endphp 
                                                <input type="date" id="incomeEndDateTime" class="form-control"
                                                    name="incomeEndDateTime" placeholder="Date"  value="{{ date_format($date,"Y-m-d") }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Invoice Due Date</label>
                                                @php $date=date_create($income->incomeDueDate); @endphp 
                                                <input type="date" id="incomeDueDate" class="form-control"
                                                    placeholder="" name="incomeDueDate"  value="{{ date_format($date,"Y-m-d") }}"  required>
                                            </div>
                                        </div>
                                        <div class="col-md-9 col-9">
                                            <div class="form-group">
                                                <label>Description</label>

                                                <textarea type="text" id="incomeReference" class="form-control"
                                                    placeholder="Address" name="incomeReference"   required>{{ $income->incomeReference }}</textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-3 col-3">
                                          <div class="form-group">
                                              <label>Attachment</label>
                                              <input type="file" id="attachment" class="form-control"
                                                  placeholder="" name="incomeAttachment"  >
                                          </div>
                                      </div>


                                    </div>




                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="float-right btn submit-btn mr-1 mb-1 waves-effect waves-light btn-sm">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Edit income Items</h4>
                        <div class="card-body">

                      
                                    <div class="form-body">
                                      
    
                                     
                                              <div class="row  ">
                                                <div class="col-md-4 col-sm-12 ">
                                                  <b for="">Description </b>
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
                                                  <b for="">Quantity</b>
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
                                                  <b for="">Unit Cost</b>
    
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
                                                    <b for="">Total</b>
    
      
                                                  </div>
                                                <div class="col-md-2 col-sm-12  d-flex align-items-center pt-2">
                                                  
                                                </div>
                                              </div>
                                              <hr>
                                    
    
                                              @php $subtotal = 0; @endphp
                                              @foreach($income->incomeItems as $item)
                                              <div class="row ">
                                                <div class="col-md-4 col-sm-12 ">
                                                  <input type="text" class="form-control" name="incomeItemDescription" value="{{ $item->incomeItemDescription }}" readonly required>
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
                                                  <input type="number"   class="form-control totalUnitqty" name="incomeItemQuantity" value="{{ $item->incomeItemQuantity }}" readonly  required>
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
                                                  <input type="text"  class="form-control" name="incomeItemUnitCost" value="{{ $item->incomeItemUnitCost }}" readonly oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required >
    
                                                </div>
                                                <div class="col-md-2 col-sm-12 ">
    
                                                    <input type="text" class="form-control" name="incomeItemTotal" readonly value="{{ $item->incomeItemUnitCost*$item->incomeItemQuantity }}" readonly>
      
                                                  </div>
                                                <div class="col-md-1 col-sm-12  d-flex align-items-center">
                                                  <button class="btn btn-info btn-sm" data-toggle="modal" data-backdrop="false" data-target="#editincomee{{ $item->incomeItemId}}"  type="button"> <i class="fa fa-pencil"></i>
                                                    
                                                  </button>
                                                </div>
                                                <div class="col-md-1 col-sm-12  d-flex align-items-center">
                                              


                                                    <form method="POST" action="{{ route('incomes.delete-item',$item->incomeItemId)}}">
                                                        {{ csrf_field() }}
                                                        {{ method_field('DELETE') }}
                                                
                                                        <button class="btn btn-danger btn-sm delete-user"  type="sybmit" > <i class="fa fa-trash"></i>
                                                      
                                                        </button>
                                                    </form>
                                                  </div>
                                              </div>
                                              <div class="modal fade mt-3" id="editincomee{{ $item->incomeItemId}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                    <div class="modal-content">
                                                        <form action="{{ route('incomes.update-item', $item->incomeItemId) }}" method="POST">
                                                            @csrf
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Description</label>
                                                                    <input type="text" name="incomeItemDescription" class="form-control" required value="{{ $item->incomeItemDescription }}">
                                                                </div>
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Quantity</label>
                                                                    <input type="number" name="incomeItemQuantity" required class="form-control" value="{{ $item->incomeItemQuantity }}" />
                                                                </div>
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Unit Cost</label>
                                                                    <input type="text" name="incomeItemUnitCost" required class="form-control" value="{{ $item->incomeItemUnitCost }}" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" />
                                                                </div>
                                                                <div class="col-md-12">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-primary btn-sm" >update</button>
                                                        </div>
                                                     </form>
                                                    </div>
                                                </div>
                                            </div>
                                              @endforeach
                                              <hr>
                                           
                                          <div class="form-group">
                                            <div class="col p-0">
                                              <button class="btn btn-primary btn-sm" data-toggle="modal" data-backdrop="false" data-target="#addincome" ><i class="bx bx-plus"></i>
                                                Add new
                                              </button>
                                            </div>

                                            <div class="modal fade mt-3" id="addincome" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                    <div class="modal-content">
                                                        <form action="{{ route('incomes.create-item', $income->incomeId) }}" method="POST">
                                                            @csrf
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="myModalLabel1">New</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Description</label>
                                                                    <input type="text" name="incomeItemDescription" class="form-control" required >
                                                                </div>
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Quantity</label>
                                                                    <input type="number" name="incomeItemQuantity" required class="form-control" value="0" />
                                                                </div>
                                                                <div class="col-md-12 mb-1">
                                                                    <label>Item Unit Cost</label>
                                                                    <input type="text" name="incomeItemUnitCost" required class="form-control" value="0" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" />
                                                                </div>
                                                                <div class="col-md-12">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-primary btn-sm" >Create</button>
                                                        </div>
                                                     </form>
                                                    </div>
                                                </div>
                                            </div>
                                          </div>
    
    
                                    </div>
                                  
                               
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection

@section('after-scripts')



<script src="{{ asset('app-assets/js/jquery.repeater.min.js') }}"></script>

<script>
    // form repeater Initialization
$('.repeater-default').repeater({
  show: function () {
    $(this).slideDown();
  },
  hide: function (deleteElement) {
    if (confirm('Are you sure you want to delete this element?')) {
      $(this).slideUp(deleteElement);
    }
  }
});

$('.delete-user').click(function(e){
        e.preventDefault() // Don't post the form, unless confirmed
        if (confirm('Are you sure?')) {
            // Post the form
            $(e.target).closest('form').submit() // Post the surrounding form
        }
    });
function forItemTotal()
   {

    var subTotal = 0;

    var totalLength = $('.totalUnitqty').length;
      for(var i=0; i<totalLength; i++) {
    
      var unitPrice= 'incomeItem['+i+'][incomeItemUnitCost]';
     
      var qty = 'incomeItem['+i+'][incomeItemQuantity]';

      var it = 'incomeItem['+i+'][incomeItemTotal]';

      var up = $( "input[name='"+unitPrice+"']" ).val();
       var qt = $( "input[name='"+qty+"']" ).val();
       var newval = parseFloat(up)*parseFloat(qt)
       $( "input[name='"+it+"']" ).val('');
       $( "input[name='"+it+"']" ).val(newval.toFixed(2));
      subTotal = subTotal+newval
      }

      var up = $( "input[name='"+unitPrice+"']" ).val();

      //$('#subTotal').text('')
      //$('#subTotal').text(subTotal.toFixed(2));


      var dealTaxValue = $( "input[name='dealTaxValue']" ).val();
      

//var dealChargeAmount = 0;
    //  $('#totalPrice').text('');
    //  var newtotalprice = subTotal+parseFloat(dealCreditCardCharges)+parseFloat(dealShippingCharges)+parseFloat(dealTaxValue)+parseFloat(dealChargeAmount);
    //  $('#totalPrice').text(newtotalprice.toFixed(2));
    //  $('#txtAmt').val(subTotal.toFixed(2));
  
   }



   function addDays() {
    var date = $('#incomeEndDateTime').val()
    var days  = $("#unprecented_bank").children('option:selected').data('days');
     
      date.setDate(date.getDate() + days);
      console.log(result)
      $('#incomeDueDate').val(result)



      

}




    </script>

    @endsection