@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Expenses</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
  
@endsection

@section('content-body')


<div class="content-body">
    <section id="sale-order-datatable">
        <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-12">    
                                    @php
                                        if( $filterType == 'Head of Accounts'){
                                            $ttype = 'hoa';
                                        }else{
                                            $ttype = 'vendor';
                                        }
                                    @endphp
                                <a href="{{ route('hoav.create', $ttype) }}" target="_blank" class="btn btn-primary btn-sm float-right">
                                   New {{$filterType}}
                                </a>
                         
                        </div>
                      </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Income by {{ $filterType }}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th style="    font-size: 22px;
                                            text-align: justify;
                                            color: brown;">{{ auth()->user()->company->companyCurrency }}{{ number_format($overalltotal->total+$overalltotal->incomeTax,2) }}</th>
                                          
                                        </tr>
                                        <tr>
                                            <th>Name</th>
                                            <th>Amount</th>
                                          
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($hoavs as $expense)
                                            <tr>
                                                <td>{{ $expense->hoavName }}</td>
                                                <td>{{ auth()->user()->company->companyCurrency }}{{ $expense->total+$expense->incomeTax }} </td>
                                               
                                                  
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Name</th>
                                            <th>Amount</th>
                                     
                                        </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
        $('#sale-order-datatable').DataTable();

function getExpensiveDetails(id){



$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET",
url: "/reporting/expense/"+id,

beforeSend: function() {
  
  $("#detail-invoice-"+id).empty();
  $("#detail-invoice-"+id).text('loading...');

},
success: function(data) {
 
$("#detail-invoice-"+id).empty();
$("#detail-invoice-"+id).html(data);


}
});
}

    </script>
@endsection
