@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Expense</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-style')
@endsection
@section('content-body')
<div class="content-body">
    <section>

        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
        @endif
        <!-- first card end -->
        <!-- shipping billing card start -->
        <div class="row">
            <div class="col-md-12 ">
                <div class="card">
                    <div class="card-content">
                            <h4 class="add_new_cust_heading">Add new @if($type === 'hoa' ) Head of Account @else Vendor @endif</h4>
                        <div class="card-body">
                            <form class="form repeater-default" action="{{ route('hoav.store') }}" method="POST">
                                @csrf
                                <input type="hidden" name="hoavType" value="{{ $type }}">
                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Name</label>
                                                <input type="text" id="hoavName" class="form-control"
                                                    name="hoavName" placeholder="Name" required>
                                            </div>
                                        </div>

                                        @if($type === 'hoa' )
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Nature of Account</label>
                                                <select class="form-control" name="hoavNature" id="hoavNature">
                                                  <option value="Revenue">Revenue</option>
                                                  <option value="Capital">Capital</option>
                                                </select>
                                            </div>
                                        </div>
                                        @elseif($type === 'vendor' )
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label>Account No.</label>
                                                <input type="text" id="hoavAccount" class="form-control"
                                                    name="hoavAccount" placeholder="Account No" required>
                                            </div>
                                        </div>


                                        <div class="col-md-6 col-12">
                                          <div class="form-group">
                                              <label>Address</label>
                                              <input type="text" id="hoavAddress" class="form-control"
                                                  name="hoavAddress" placeholder="Address" required>
                                          </div>
                                      </div>

                                      <div class="col-md-6 col-12">
                                        <div class="form-group">
                                            <label>Phone</label>
                                            <input type="text" id="hoavPhone" class="form-control"
                                                name="hoavPhone" placeholder="Phone" required>
                                        </div>
                                    </div>

                                    @endif
                                  
                                 

                                        


                                    </div>


                      
                                


                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="float-right btn submit-btn mr-1 mb-1 waves-effect waves-light">Create</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- shipping billing card end -->

    </section>
</div>
@endsection

@section('after-scripts')


    @endsection