@extends('layouts.app')
@section('after-style')
<style>   
.td-font{
    font-size: 12px;
   }

   </style>

    @endsection
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Incomes</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
  
@endsection

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-12">
                      
                                <a href="{{ route('incomes.create') }}" target="_blank" class="btn btn-primary btn-sm float-right">
                                   New income
                                </a>
                         
                        </div>
                      </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card m0">
                    <div class="card-header">
                        <h4 class="card-title">Due In</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
        
        
            <div class="col-lg-4 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header d-flex flex-column align-items-start pb-0">
                        
                        <h2 class="text-bold-700 mt-1">{{ auth()->user()->company->companyCurrency }}{{ number_format($daily->total+$daily->incomeTax,2) }}</h2>
                        <p class="mb-0">Today ({{ date('D') }})</p>
                </div>
            </div>
        </div>
            <div class="col-lg-4 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header d-flex flex-column align-items-start pb-0">
                        
                    
                        <h2 class="text-bold-700 mt-1">{{ auth()->user()->company->companyCurrency }}{{ number_format($monthly->total+$monthly->incomeTax,2) }}</h2>
                        <p class="mb-0">Monthly ({{ date('M') }})</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 col-12">
                <div class="card">
                    <div class="card-header d-flex flex-column align-items-start pb-0">
                        
                 
                        <h2 class="text-bold-700 mt-1">{{ auth()->user()->company->companyCurrency }}{{ number_format($yearly->total+$yearly->incomeTax,2) }}</h2>
                        <p class="mb-0">Yearly ({{ date('Y') }})</p>
                    </div>
                </div>
            </div>
        </div>                </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Income Transactions</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                            <th style="font-weight:bold;
                                            color: brown;">{{ auth()->user()->company->companyCurrency }}{{ number_format($overalltotal->total+$overalltotal->incomeTax,2) }}</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                          <tr>
                                            <th>Invoice #</th>
                                            <th>Invoice Date</th>
                                            <th>Invoice Due</th>
                                            <th>Gateway</th>
                                            <th>Reference</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>-</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($incomes as $income)
                                            <tr>
                                                <td class="td-font">{{ $income->incomeInvoiceNo  }}</td>
                                                <td class="td-font">@php $date=date_create($income->incomeEndDateTime); @endphp {{ date_format($date,"M d, Y") }}</td>
                                                <td class="td-font"> @php $date=date_create($income->incomeDueDate); @endphp {{ date_format($date,"M d, Y") }}</td>
                                                
                                                <td class="td-font">{{ $income->incomeGateway }}</td>
                                                <td class="td-font">{{ Str::limit($income->incomeReference, 15) }}</td>
                                                <td class="td-font"><span class=" primary font-small-1">{{ auth()->user()->company->companyCurrency }}</span>{{ number_format($income->incomeTax+$income->total,2) }}</td>
                                                <td style="padding: inherit;">@include('reporting.incomes.partials.status')</td>
                                                <td >  <div class="btn-dropdown mr-1 mb-1">
                                                    <div class="btn-group dropdown actions-dropodown">
                                                        <button type="button"
                                                            class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                            data-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false" >
                                                            
                                                        </button>
                                                        <div class="dropdown-menu">
                                                       
                                                                @if($income->incomeStatusType == 'default')
                                                            
                                                                <a class="dropdown-item" href="{{ route('incomes.edit', $income->incomeId) }}"  ><i
                                                                    class="feather icon-edit"></i>Edit</a>
                                                                    <a class="dropdown-item" href="{{ route('incomes.delete-income', $income->incomeId) }}"  onclick="if (!confirm('Are you sure?')) { return false }"><i
                                                                        class="feather icon-trash"></i>Delete</a>
                                                                    @endif
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#detailincome{{$income->incomeId}}" onclick="getExpensiveDetails({{ $income->incomeId }}, '{{ $income->incomeGateway }}')"><i
                                                                    class="feather icon-file"></i>Details</a>
                                                        </div>
                                                    </div>
                                                    <div class="modal fade mt-3" id="detailincome{{ $income->incomeId}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                                                            <div class="modal-content">
                                                              
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div id="detail-invoice-{{$income->incomeId}}">
                                                                    </div>
                                                                    <hr>
                                                                    <div id="single-transaction-{{$income->incomeId}}"></div>
                                                                    <br>
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                      
                                    </tfoot>
                                </table>
                                {{ $incomes->appends(request()->input())->links('pagination::bootstrap-4') }}

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
        $('#sale-order-datatable').DataTable();


function getExpensiveTransaction(id, egateway)
{
   
$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "POST",
url: "{{ route('incomes.single-transaction') }}",
data:{
    id:id,egateway:egateway
},
beforeSend: function() {
  
  $("#single-transaction-"+id).empty();
  $("#single-transaction-"+id).text('loading...');

},
success: function(data) {
 
$("#single-transaction-"+id).empty();
$("#single-transaction-"+id).html(data);


}
});


}

function getExpensiveDetails(id, egateway){




$.ajaxSetup({
headers: {
  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}

});

$.ajax({
type: "GET",
url: "/reporting/income/"+id,

beforeSend: function() {
  
  $("#detail-invoice-"+id).empty();
  $("#detail-invoice-"+id).text('loading...');

},
success: function(data) {
 
$("#detail-invoice-"+id).empty();
$("#detail-invoice-"+id).html(data);
getExpensiveTransaction(id, egateway);

}
});
}

    </script>
@endsection
