@extends('layouts.app')
@section('after-style')
<style>   
.td-font{
    font-size: 12px;
   }

   </style>

    @endsection
@section('leftbar-orders-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Incomes</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
  
@endsection

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-12">
                      
                                <a href="{{ route('journal-entry.create') }}" target="_blank" class="btn btn-primary btn-sm float-right">
                                   New Journal Entry
                                </a>
                         
                        </div>
                      </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                
             
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Journal Entries</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                      
                                          <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Narration</th>
                                       
                                            <th>-</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($journals as $key => $journal)
                                            <tr>
                                                <td class="td-font">{{ ++$key  }}</td>
                                                <td class="td-font">@php $date=date_create($journal->journalDate); @endphp {{ date_format($date,"M d, Y") }}</td>
                                                
                                                <td class="td-font">{{ $journal->journalReference }}</td>
                                                <td >  <div class="btn-dropdown mr-1 mb-1">
                                                    <div class="btn-group dropdown actions-dropodown">
                                                        <button type="button"
                                                            class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                            data-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false" >
                                                            
                                                        </button>
                                                        <div class="dropdown-menu">
                                                       
                                                                @if($journal->incomeStatusType == 'default')
                                                            
                                                                <a class="dropdown-item" href="{{ route('incomes.edit', $journal->journalId) }}"  ><i
                                                                    class="feather icon-edit"></i>Edit</a>
                                                                    <a class="dropdown-item" href="{{ route('incomes.delete-income', $journal->journalId) }}"  onclick="if (!confirm('Are you sure?')) { return false }"><i
                                                                        class="feather icon-trash"></i>Delete</a>
                                                                    @endif
                                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal" data-target="#detailincome{{$journal->journalId}}" onclick="getExpensiveDetails({{ $journal->journalId }}, '{{ $journal->incomeGateway }}')"><i
                                                                    class="feather icon-file"></i>Details</a>
                                                        </div>
                                                    </div>
                                                    <div class="modal fade mt-3" id="detailincome{{ $journal->journalId}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                                                            <div class="modal-content">
                                                              
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title" id="myModalLabel1">Detail</h4>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div id="detail-invoice-{{$journal->journalId}}">
                                                                        <div class="row">
                                                                            <div class="col-md-4 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Date</label>
                                                                                    @php 
                                                                                    $date=date_create($journal->journalDate); @endphp 
                                                                                  
                                                                                    <input type="text"  class="form-control border-0"
                                                                                         required value="{{ date_format($date,"M d, Y") }}" readonly>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-8 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Narration</label>
                                                                                    <input type="text"  class="form-control border-0"
                                                                                        required value="{{ $journal->journalReference  }}" readonly>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <hr>
                                                                    <div id="single-transaction-{{$journal->journalId}}">
                                                                        @foreach($journal->journalEntries as $jentry)
                                                                        <div class="row">
                                                                            <div class="col-md-3 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Gateway</label>
                                                                                    <input type="text"  class="form-control border-0" readonly required value="{{ $jentry->journalEntryGatewayId }}" >
                                                                                </div>
                                                                            </div>
                                                                        
                                                                        
                                                                            <div class="col-md-5 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Narration</label>
                                                                        
                                                                                    <input type="text"  class="form-control border-0"
                                                                                        name="journalEntryNarration"  required readonly value="{{ $jentry->journalEntryNarration }}">
                                                                                </div>
                                                                            </div>
                                                                           
                                                                           
                                                                            <div class="col-md-2 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Debit</label>
                                                                                    <input type="text" class="form-control border-0" readonly  value="{{ $jentry->journalEntryDebit }}" required  >
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-2 col-12">
                                                                                <div class="form-group">
                                                                                    <label>Credit</label>
                                                                                    <input type="text"  class="form-control border-0" readonly  value="{{ $jentry->journalEntryCredit }}" required >
                                                                                </div>
                                                                            </div>
                                                                           
                                                                          
                                                                        
                                                                        
                                                                        </div>
                                                                        
                                                                        @endforeach
                                                                        
                                                                    </div>
                                                                    <br>
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                      
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')

@endsection
