@extends('layouts.app')
@section('leftbar-orders-active', 'active')



@section('content-body')

<div class="content-body">

    <section id="sale-order-datatable">
        @include('partials.alerts.basic')

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Aged Payables  <a href="{{ route('aged-payables-pdf') }}" target="_blank"  style="padding: 2px 4px 2px 4px;"  class="btn btn-outline-success  waves-effect waves-light btn-sm">PDF</a>   </h4>

                 
                        @include('reporting.payables.partials.add')

                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>
                                                <form action="" method="GET">
                                                    <select name="payables_status" id="payables_status">
                                                    <option value="default" @if(request()->get('payables_status') && request()->get('payables_status') == 'default') selected @endif>Default</option> 
                                                    <option value="unpresented" @if(request()->get('payables_status') && request()->get('payables_status') == 'unpresented') selected @endif>Unpresented</option>
                                                    </select>
                                                   </form>
                                                   
                                            </th>
                                            <th>  <form action="" method="GET">
                                                <select name="payables_selection" id="payables_selection">
                                                <option value="Aged Payables" >Aged Payables</option> 
                                                <option value="Aged Expense Payables" >Aged Expense Payables</option>
                                                </select>
                                               </form></th>
                                            <th></th>   
                                            <th id="z-030"></th>
                                            <th id="z-3160"></th>
                                            <th id="z-6190"></th>
                                            <th id="z-91120"></th>
                                            <th id="z-over120"></th>
                                            <th id="amntdue"></th>
                                        </tr>
                                    </thead>
                                    <thead>
                                        <tr>
                                            <th>Vendor</th>
                                            <th>INV#</th>
                                            <th>Date</th>
                                            <th>0-30</th>
                                            <th>31-60</th>
                                            <th>61-90</th>
                                            <th>91-120</th>
                                            <th>Over 120 days</th>
                                            <th>Amount Due</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($vendors as $vendor)

                                        <tr id="render-{{ $vendor['payableVendorId'] }}">
                                            <th>{{ $vendor['vendorCompany'] }} <a href="{{ route('aged-payable-pdf', $vendor['payableVendorId']) }}@if(request()->get('payables_status'))?payables_status={{ request()->get('payables_status') }} @endif" target="_blank"  style="padding: 2px 4px 2px 4px; "  class="btn btn-outline-info  waves-effect waves-light btn-sm ml-1">PDF</a></th>
                                            <th></th>
                                            <th></th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($vendor['net_30'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($vendor['net_60'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($vendor['net_90'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($vendor['net_120'], 2) }}</th>
                                                <th>{{ auth()->user()->company->companyCurrency }}{{
                                                    number_format($vendor['over_120'], 2) }}</th>
                                            <th >{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($vendor['net_30'] + $vendor['net_60'] +
                                                $vendor['net_90'] + $vendor['net_120']+ $vendor['over_120'], 2) }} <span id="load-span-{{ $vendor['payableVendorId'] }}"><a
                                                    href="javascript:void(0)"
                                                    onclick="getInvoices({{ $vendor['payableVendorId'] }})"
                                                    id="load-link-{{ $vendor['payableVendorId'] }}" class="float-right"><i
                                                        class="fa fa-plus"></i></a></span></th>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Vendor</th>
                                            <th>INV#</th>
                                            <th>Date</th>
                                            <th>0-30</th>
                                            <th>31-60</th>
                                            <th>61-90</th>
                                            <th>91-120</th>
                                            <th>Over 120 days</th>
                                            <th>Amount Due</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
<script>
    $('#sale-order-datatable').DataTable();
  
</script>

@include('reporting.scripts.payables.aged')
@endsection