@extends('layouts.app')
@section('leftbar-orders-active', 'active')


@section('content-body')

<div class="content-body">
@php

$receivableYear = request()->get('receivableYear') ? request()->get('receivableYear') : date("Y");
$receivableMonth = request()->get('receivableMonth') ? request()->get('receivableMonth') : date("m");
$receivables_status = request()->get('receivables_status') ? request()->get('receivables_status') : 'default';


@endphp
    <section id="sale-order-datatable">
        @include('partials.alerts.basic')

        <div class="row">
            <div class="col-12">
                <div>

                    <form method="GET" action=""> 
                        <div class="row ">
                         
                         <div class="col-6 ">
                          
                        </div>
                       
                      <input type="hidden" name="receivables_status" value="{{ $receivables_status }}" >
                      
                            <div class="col-2">
                                <fieldset class="form-group">
                                    <select class="form-control" name="receivableMonth" id="receivableMonth">
                                        <!-- <option value="all" selected="">All</option> -->
                                <option value="all" @if($receivableMonth == 'all') selected=""  @endif >All</option>

                                        @foreach($receivableMonthArray as $key => $dm)
                                      

                                    <option value="{{ $key  }}" @if($receivableMonth == $key) selected=""  @endif >{{ $dm }}</option>
                                    @endforeach
                                    </select>
                                </fieldset>
                                </div>
                                <div class="col-2">
                                <fieldset class="form-group">
                                    <select class="form-control" name="receivableYear" id="receivableYear">
                                    @foreach($receivableYearArray as $key => $dy)
                                    <option value="{{ $key  }}" @if(request()->get("receivableYear") == $key) selected="" @elseif($key == date("y")) selected="" @endif >{{ $dy }}</option>
                                    @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-2">
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                            </div>
                        </div>
                        </form>

                </div>
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Aged Receivables  <a href="{{ route('aged-receivables-pdf') }}" target="_blank"  style="    padding: 2px 4px 2px 4px;                            "  class="btn btn-outline-success  waves-effect waves-light btn-sm">PDF</a></h4>

                 
                    

                    
                        @include('reporting.receivables.partials.add')
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration" >
                                    <thead>
                                        <tr>
                                     
                                            <th>
                                                <form action="" method="">
                                                <select name="receivables_status" id="receivables_status">
                                                <option value="default" @if(request()->get('receivables_status') && request()->get('receivables_status') == 'default') selected @endif>Default</option> 
                                                <option value="unpresented" @if(request()->get('receivables_status') && request()->get('receivables_status') == 'unpresented') selected @endif>Unpresented</option>
                                                </select>
                                               </form>
                                        </th>
                                        <th></th>
                                            <th id="z-030"></th>
                                            <th id="z-3160"></th>
                                            <th id="z-6190"></th>
                                            <th id="z-over90"></th>
                                            <th id="amntdue"></th>
                                        </tr>
                                    </thead>
                                    <thead>
                                        <tr>
                                            <th><input type="text" style="width: 70%;" class="form-control" id="searchCustomer" placeholder="Search Customer.." title="Type in a name"></th>
                                            <th>INV#</th>
                                            <th>0-30</th>
                                            <th>31-60</th>
                                            <th>61-90</th>
                                            <th>Over 90 days</th>
                                            <th>Amount Due</th>
                                        </tr>
                                    </thead>
                                    <tbody id="rage">
                                        @foreach ($customers as $customer)

                                        <tr id="render-{{ $customer['dealUserId'] }}">
                                            <th><a href="{{ route('customer-invoices', bin2hex($customer['dealUserId'])) }}" target="_blank">{{ $customer['userCompany'] }} </a> <a href="{{ route('aged-receivable-pdf', $customer['dealUserId']) }}" target="_blank"  style="padding: 2px 4px 2px 4px; "  class="btn btn-outline-info  waves-effect waves-light btn-sm ml-1">PDF</a></th>
                                            <th></th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($customer['net_30'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($customer['net_60'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($customer['net_90'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($customer['over_90'], 2) }}</th>
                                            <th>{{ auth()->user()->company->companyCurrency }}{{
                                                number_format($customer['net_30'] + $customer['net_60'] +
                                                $customer['net_90'] + $customer['over_90'], 2) }} 
                                                    
                                                        <span id="load-span-{{ $customer['dealUserId'] }}"><a
                                                            href="javascript:void(0)"
                                                            onclick="getInvoices({{ $customer['dealUserId'] }})"
                                                            id="load-link-{{ $customer['dealUserId'] }}" class="float-right"><i
                                                                class="fa fa-plus"></i></a></span>
                                                    
                                                    </th>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Customer</th>
                                            <th>INV#</th>
                                            <th>0-30</th>
                                            <th>31-60</th>
                                            <th>61-90</th>
                                            <th>Over 90 days</th>
                                            <th>Amount Due</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
<script>
    $('#sale-order-datatable').DataTable();
</script>

@include('reporting.scripts.receivable.aged')
@endsection