@extends('layouts.app')
@section('leftbar-orders-active', 'active')

@section('content-body')

<div class="content-body">
    <section id="sale-order-datatable">
        {{-- <div class="card m0">
            <div class="card-content">
                <div class="card-body">
                    <div class="row ">
                        <div class="col-4 row">
                            <div class="col-8">
                           
                            </div>
                        </div>
                      </div>
                </div>
            </div>
        </div> --}}

        @php 
$tempUrl = 'https://erp.thetechit.com/admin/pdf/invoice_pdf/'

@endphp

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Invoices ~ {{ $customer->userCompany }}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                         <th>#</th>
                                         <th>Due Date</th>   
                                         <th>subtotal</th>
                                         <th>Shipping</th>
                                         <th>Tax</th>
                                         <th>Charges</th>
                                         <th>CC Charges</th>
                                         <th>Total</th>
                                         <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($invoices as $invoice)
                                        
                                        @php $invoiceIsReturn = $invoice->invoiceType; @endphp
                                        <tr style=" @if($invoiceIsReturn == 'return') background:#ff000026; @endif">
                                        <td><a href="{{$tempUrl}}{{ $invoice->invoiceId }}" target="_blank">{{ auth()->user()->company->companyPrefix }}{{ $invoice->invoiceSoId }} - {{ $invoice->invoiceSoSerial }}</a></td>
                                        <td>@php $date=date_create($invoice->invoiceDueDate); @endphp {{ date_format($date,"m/d/Y") }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format($invoice->total, 2) }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format($invoice->invoiceShippingCharges, 2) }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format($invoice->invoiceTaxValue, 2) }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format($invoice->invoiceChargeAmount, 2) }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format($invoice->invoiceCreditCardCharges, 2) }}</td>
                                        <td>{{ auth()->user()->company->companyCurrency }}{{ number_format( +$invoice->total + $invoice->invoiceShippingCharges + $invoice->invoiceTaxValue + $invoice->invoiceChargeAmount +$invoice->invoiceCreditCardCharges, 2)  }} </td>
                                        <td>@include('reporting.receivables.partials.status')</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>   
                                            <th>subtotal</th>
                                            <th>Shipping</th>
                                            <th>Tax</th>
                                            <th>Charges</th>
                                            <th>CC Charges</th>
                                            <th>Total</th>
                                            <th>Status</th>

                                           </tr>
                                    </tfoot>
                                </table>
                                {{ $invoices->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('after-scripts')
    <script>
        $('#sale-order-datatable').DataTable();
    </script>
@endsection
