<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- CSRF Token -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Invoice Register</title>

   
    <style type="text/css">
      th,td{
            font-size: 9px;
            text-align: center;
  
      }
      .th1{
        background: #2543c1db;
      color: #fff;
          border: 1px solid;
  
      }
      .th2{
            background:#086504;
      color: #fff;
          border: 1px solid;
  
      }
       .th3{
            background: #b5651d;
      color: #fff;
          border: 1px solid;
  
      }
      .tdlightblue {
      background: lightblue;
          border: 1px solid;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
      .tdblue {
      background: #1c992ad6;
      color: #fff;
          border: 1px solid #333;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
     .tdstate {
  
     
          font-weight: bold;
          border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  
  }
  
  .tdlightgreen{
        background: lightgreen;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  .tdlightbrown{
        background: #e8720878;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  
  .tabfedex{
          background: #ffc1075e;
      border: 1px solid;
      border-top: 1px dotted #c3b3b3 !important;
      border-bottom: 1px dotted #af9292 !important;
  }
  input {margin-bottom: 5px; padding: 2px 3px; width: 209px !important; 
  }
  
    </style>
</head>
<body>
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <a class="navbar-brand" href="{{ route('reporting-dashboard') }}" style="text-decoration: revert;"><b>Dashboard</b></a>
      <form method="GET" action=""> 
        <div class="row ">

       
      
          
          <div class="col-1">
            <span style="margin-top: 7px;
            position: absolute;
            margin-left: -6px;
            font-weight: bold;">{{ auth()->user()->company->companyPrefix }} </span>
          </div>
            <div class="col-5">
              <input type="text" name="sonumber" class="form-control" value="{{ request()->get('sonumber') }}">
                </div>
                
            <div class="col-4">
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                   @if(request()->get('sonumber'))

                <a href="{{ route('invoice-register-sheet') }}" class="waves-effect waves-light">Reset</a>
                @endif
            </div>
            <div class="col-2">
               

            </div>
        </div>
        </form>

      <form method="GET" action=""> 
        <div class="row ">

       
      
      
            <div class="col-5">
                @if(!request()->get('sonumber'))
                <fieldset class="form-group">
                    <select class="form-control" name="dealMonth" id="dealMonth">
                        <!-- <option value="all" selected="">All</option> -->
                <option value="all" @if($dealMonth == 'all') selected=""  @endif >All</option>

                        @foreach($dealMonthArray as $key => $dm)
                      

                    <option value="{{ $key  }}" @if($dealMonth == $key) selected=""  @endif >{{ $dm }}</option>
                    @endforeach
                    </select>
                </fieldset>
                @endif
                </div>
                <div class="col-4">
                    @if(!request()->get('sonumber'))
                <fieldset class="form-group">
                    <select class="form-control" name="dealYear" id="dealYear">
                    @foreach($dealYearArray as $key => $dy)
                    <option value="{{ $key  }}" @if($dealYear == $key) selected="" @elseif($key == date("y")) selected="" @endif >{{ $dy }}</option>
                    @endforeach
                    </select>
                </fieldset>
  @endif
            </div>
            <div class="col-3">
                @if(!request()->get('sonumber'))
                <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                  @endif
            </div>
        </div>
        </form>
    </div>
  </nav>
    <div id="app" >

      <h1 style="    text-align: center;
      padding-top: 18px;
      padding-bottom: 10px;">Invoice Register</h1>
@php

$grosssale = [];
$salefrieght = [];
$saletax = [];
$cccharges = [];
$netamount = [];
$pototalamount = [];
$grossprofit = [];
$companyPrefix = auth()->user()->company->companyPrefix; 
@endphp
   
<table class="table table-responsive-xl">
    <thead>
      <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th id="gross-sale">$0</th>
        
        <th id="sale-frieght">$0</th>
        <th id="sale-tax">$0</th>
        <th id="order-total">$0</th>
        
      
       
      </tr>
      <tr>
        <th class="th1">MONTH</th>
        <th class="th1">ORDER SOURCE</th>
       
     
        <th class="th1">INVOICE NO.</th>
        <th class="th1">INVOICE DATE</th>
        <th class="th1">P.O. NO. / REF. NO.</th>
        <th class="th1">CUSTOMER</th>
        <th class="th1">STATE</th>
        <th class="th1">GROSS SALE AMOUNT</th>
        
        <th class="th1">FREIGHT</th>
        <th class="th1">TAX</th>
        <th class="th1"> ORDER TOTAL</th>
        
    
    
   
    
      </tr>
    </thead>
    <tbody id="myTable">
           
      
@foreach($orders as $order)
@foreach($order->invoices as $invoice)

      <tr>
        @php
        $idate=date_create($invoice->invoiceEndDateTime);
        @endphp
        <td>{{ date_format($idate,"M") }}</td>
        <td>-</td>
      
        <td>{{$companyPrefix}}{{ $invoice->invoiceSoId }}-{{ $invoice->invoiceSoSerial }}</td>
        <td>{{ date_format($idate,"M,d Y") }}</td>
        <td>{{ $invoice->invoiceReference }} </td>
        <td>{{ $invoice->invoiceBillingCompany }} </td>
        <td class="tdstate">{{ $invoice->invoiceBillingState }} </td>
        @php
        //$itemsum = $invoice->itemsSum ? $invoice->itemsSum;
        $grosssale[] =  $invoice->itemsSum[0]->total;
        $salefrieght[] =  $invoice->invoiceShippingCharges;
        $saletax[] =  $invoice->invoiceTaxValue;
        $netamount[] = $invoice->itemsSum[0]->total+$invoice->invoiceShippingCharges+$invoice->invoiceTaxValue;
        @endphp
        <td class="tdlightblue grosssalesmount">{{ $invoice->itemsSum[0]->total }} </td>
        
        <td class="tdlightblue frieghtamount">{{ $invoice->invoiceShippingCharges }}</td>
        <td class="tdlightblue salestaxth">{{ $invoice->invoiceTaxValue }}</td>
        <td class="tdlightgreen grosssale"> {{ $invoice->itemsSum[0]->total+$invoice->invoiceShippingCharges+$invoice->invoiceTaxValue}}</td>
        
    
 
     
               
      </tr>
            
      

   @endforeach
      
   @endforeach

      

      

    
            
      

               </tbody>
  </table>
        
        
    </div>
    @php 
      $totalgrosssale = array_sum($grosssale);
      $totalsalefrieght = array_sum($salefrieght);
      $totalsaletax = array_sum($saletax);
      $totalcccharges = array_sum($cccharges);
      $totalpototalamount = array_sum($pototalamount);
      $grossprofit = array_sum($grossprofit);

      
    @endphp


    <script>

    

      $(document).ready(function(){
        $('#gross-sale').text('${{ number_format($totalgrosssale, 2) }}')
        $('#sale-frieght').text('${{ number_format($totalsalefrieght, 2) }}')
        $('#sale-tax').text('${{ number_format($totalsaletax, 2) }}')
        $('#order-total').text('${{ number_format($totalgrosssale+$totalsalefrieght+$totalsaletax, 2) }}')
        $('#cc-charges').text('${{ number_format($totalcccharges, 2) }}')
        $('#net-amount').text('${{ number_format($totalgrosssale+$totalsalefrieght+$totalsaletax-$totalcccharges, 2) }}')
      
        $('#po-total-amount').text('${{ number_format($totalpototalamount, 2) }}')
        $('#gross-profit').text('${{ number_format($grossprofit, 2) }}')

});
    </script>
</body>
</html>
