<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Profit Loss Sheet</title>

   

</head>
<body>
    <div id="app" >
        
        
        <div class="container">
          <h2>Profit Loss</h2>
        
          <table class="table table-striped">
            <thead>
              <tr>
                <th>RECORD TYPE</th>
                <th>MONTH</th>
                <th>S.O. / INVOICE NO.</th>
                <th>INVOICE DATE</th>
                <th>P.O. NO. / REF. NO.</th>
                <th>CUSTOMER</th>
                <th>STATE</th>
                <th>GROSS SALE AMOUNT</th>
                <th>FREIGHT</th>
                <th>TAX</th>
                <th>INVOICE TOTAL</th>
                <th>CC / Amazon CHARGES</th>
                <th>NET SALE AMOUNT </th>
             

              </tr>
            </thead>
            <tbody>

                @foreach($invoices as $invoice)
              <tr>
                <td>RECORD TYPE</td>
                <td>MONTH</td>
                <td>{{ auth()->user()->company->companyPrefix }}{{ $invoice->invoiceSoId }}-{{ $invoice->invoiceSoSerial }}</td>
                <td>{{ $invoice->invoiceEndDateTime }}</td>
                <td>{{ $invoice->invoiceReference }}</td>
                <td>{{ $invoice->invoiceBillingCompany }}</td>
                <td>{{ $invoice->invoiceBillingState }}</td>
                <td>{{ auth()->user()->company->companyCurrency }}{{ $invoice->total }}</td>
                <td>{{ auth()->user()->company->companyCurrency }}{{ $invoice->invoiceShippingCharges }}</td>
                <td>{{ auth()->user()->company->companyCurrency }}{{ $invoice->invoiceTaxValue }}</td>
                <td>INVOICE TOTAL</td>
                <td>CC / Amazon CHARGES</td>
                <td>NET SALE AMOUNT </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
        
       
        
        
    </div>
</body>
</html>
