@extends('layouts.app')

@section('after-style')
<style>   
.td-font{
    font-size: 12px;
   }
.card .card-title-c {
    font-weight: 600;
    font-size: 16pt;
    border-left: 2px solid;
    
    padding-left: 10px;
    color: burlywood;
}

.card .card-header-c{
    padding-top: inherit;

}
   </style>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/datatables.min.css')}}">

    @endsection

@section('leftbar-orders-active', 'active')



@section('content-body')

    <div class="content-body">
        <section id="sale-order-datatable">
           
       
       
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Sales Register</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th class="pr-name">PO#</th>
                                                <th class="pr-name">Vendor</th>
                                                <th class="pr-name">Date</th>
                                                <th class="pr-name">Amount</th>
                                                
                                     


                                            </tr>
                                        </thead>
                                        <tbody>
                                        	@php
                                        	$companyPrefix = auth()->user()->company->companyPrefix;
                                        	$companyCurrency = auth()->user()->company->companyCurrency;
                                            $alphabet = array('','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

                                        	@endphp
                                            @foreach ($orders as $order)

                            
                      
                        
                        

                                                <tr >
                                                    <td>{{ $order->purchaseRecieved ? 'closed' : 'pending' }}</td>
                                                <td><a href="https://erp.thetechit.com/admin/pdf/purchase_pdf/{{ $order->purchaseSoId }}/{{ $order->purchaseGroupBy }}" target="_blank">{{ $companyPrefix }}{{ $order->purchaseSoId }}{{ $alphabet[$order->purchaseGroupBy] }}</a></td>
                                                
                                                <td>{{ $order->vendor->vendorCompany }} </td>

                                                <td >{{ Carbon\Carbon::parse($order->purchaseCreatedAt)->format('d M y') }}</td>
                                                
                                                <td >{{ $companyCurrency  }}{{ number_format((double)$order->total+(double)$order->purchaseTax+(double)$order->purchaseShipping, 2)}}</td>
                                                
                                                

                                            </tr>
                                            @endforeach
                                        </tbody>
                                  
                                    </table>
                                    {{ $orders->links('pagination::bootstrap-4') }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')



@endsection
