@extends('layouts.app')

@section('after-style')
<style>   
.td-font{
    font-size: 12px;
   }
.card .card-title-c {
    font-weight: 600;
    font-size: 16pt;
    border-left: 2px solid;
    
    padding-left: 10px;
    color: burlywood;
}

.card .card-header-c{
    padding-top: inherit;

}
   </style>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/datatables.min.css')}}">

    @endsection

@section('leftbar-orders-active', 'active')



@section('content-body')

    <div class="content-body">
        <section id="sale-order-datatable">
           <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-4">
                                {{-- <form> --}}
                                    <fieldset class="form-group position-relative has-icon-left hide">
                                        <input type="text" class="form-control round" id="searchbar"
                                            placeholder="Search">
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>
                                {{-- </form> --}}
                            </div>
                        
                             
                            <div class="col-md-8">
                            <form method="GET" action=""> 
                            <div class="row ">
                             
                             <div class="col-3 ">
                                <fieldset class="form-group">
                                 
                                </fieldset>
                            </div>
                      
                          
                                <div class="col-3">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealMonth" id="dealMonth">
                                            <option value="all" @if($dealMonth == 'all') selected="" @endif>All</option> 
                                            @foreach($dealMonthArray as $key => $dm)
                                        <option value="{{ $key  }}" @if($dealMonth == $key) selected="" @endif >{{ $dm }}</option>
                                        @endforeach
                                        </select>
                                    </fieldset>
                                    </div>
                                    <div class="col-3">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealYear" id="dealYear">
                                        @foreach($dealYearArray as $key => $dy)
                                        <option value="{{ $key  }}" @if($dealYear == $key) selected=""  @endif >{{ $dy }}</option>
                                        @endforeach
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-2">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
       
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Receivables / Payables</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead>
                                            <tr>
                                                <th class="pr-name">SO#</th>

                                                <th class="pr-name">Receivables (Sale Invoices)</th>

                                                <th class="pr-name">Bank Credit</th>
                                                <th class="pr-name">Payables (Purchase Receivings)</th>
                                                
                                                <th class="pr-name">Bank Debit</th>


                                           


                                                <th class="pr-action"></th>


                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($orders as $order)
                                                <tr >
                                                <td>{{ auth()->user()->company->companyPrefix }}{{ $order->dealSO }}</td>
                                                <td >{{ $order->defaultInvoices->count() }}/{{ $order->invoices->count() }}</td>
                                                <td >{{ $order->creditInvoices->count() }}/{{ $order->invoices->count() }}</td>
                                                <td >{{ $order->defaultPayables->count() }}/{{ $order->payables->count() }}</td>
                                                <td >{{ $order->debitPayables->count() }}/{{ $order->payables->count() }}</td>

                                                <td>



                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false" >
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                    <a class="dropdown-item" href="https://erp.thetechit.com/admin/salesorder/create_invoice/{{ $order->dealSO }}" target="_blank" ><i
                                                                        class="feather icon-edit"></i>Create Invoice</a>
                                                                        <a class="dropdown-item" href="https://erp.thetechit.com/admin/purchase/purchase_list/{{ $order->dealSO }}"  ><i
                                                                            class="feather icon-edit"></i>Create Receiving</a>
                                                            </div>
                                                        </div>
                                                        


                                                </td>
                                                

                                            </tr>
                                            @endforeach
                                        </tbody>
                                  
                                    </table>
                                    {{ $orders->links('pagination::bootstrap-4') }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')



@endsection
