@extends('layouts.app')

@section('after-style')
<style>   
.td-font{
    font-size: 12px;
   }
.card .card-title-c {
    font-weight: 600;
    font-size: 16pt;
    border-left: 2px solid;
    
    padding-left: 10px;
    color: burlywood;
}

.card .card-header-c{
    padding-top: inherit;

}
   </style>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/datatables.min.css')}}">

    @endsection

@section('leftbar-orders-active', 'active')



@section('content-body')

    <div class="content-body">
        <section id="sale-order-datatable">
           
       
       
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Sales Register</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th class="pr-name">SO#</th>
                                                <th class="pr-name">Ref</th>
                                                <th class="pr-name">Date</th>

                                                <th class="pr-name">Customer</th>
                                                <th class="pr-name">Amount</th>
                                                
                                     


                                            </tr>
                                        </thead>
                                        <tbody>
                                        	@php
                                        	$companyPrefix = auth()->user()->company->companyPrefix;
                                        	$companyCurrency = auth()->user()->company->companyCurrency;
                                        	@endphp
                                            @foreach ($orders as $order)

                            
                            @php  

                              $subtotal  = $order->dealItems()->sum(DB::raw('dealItemQuantity * dealItemUnitCost'));
                            $dealShippingCharges =  $order->dealShippingCharges; 

                            $dealCreditCardCharges =  $order->dealCreditCardCharges; 
                             @endphp
                       
                            @php  $dealChargeAmount =  $order->dealChargeAmount; 
                                if($order->dealChargeType == 'Amazon Charges'){
                                    $dealChargeAmount = $dealChargeAmount *-1;
                                }
                                @endphp
                         
                            @php  $dealTaxValue =  $order->dealTaxValue;  @endphp
                        
                        
                        

                                                <tr >
                                                    <td>{{ $order->dealStatus }}</td>
                                                <td><a href="https://erp.thetechit.com/admin/salesorder/view_salesorder/{{ $order->dealSO }}" target="_blank">{{ $companyPrefix }}{{ $order->dealSO }}</a></td>
                                                <td>{{ $order->dealRef }}</td>
                                                <td >{{ Carbon\Carbon::parse($order->dealEndDateTime)->format('d M y') }}</td>
                                                <td >{{ $order->dealCompanyName }}</td>
                                                <td >{{ $companyCurrency  }}{{ number_format((double)$subtotal+(double)$dealCreditCardCharges+(double)$dealShippingCharges+(double)$dealChargeAmount+(double)$dealTaxValue, 2)}}</td>
                                                
                                                

                                            </tr>
                                            @endforeach
                                        </tbody>
                                  
                                    </table>
                                    {{ $orders->links('pagination::bootstrap-4') }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('after-scripts')



@endsection
