<script>

    function loadContacts() {

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "GET",
            url: "{{ route('customer-contacts', $customer->userId) }}",
            beforeSend: function () {


            },
            success: function (data) {
                $("#show-contacts").empty();
                $("#show-contacts").html(data);
                loadAddresses()

            }
        });

    }


    $('#add-contact').submit(function (e) {
        e.preventDefault();

        var form = $(this);
        var url = form.attr('action');

        $.ajax({
            type: "POST",
            url: url,
            data: form.serialize(),
            beforeSend: function () {


            },
            success: function (response) {

                if (response.type === "success") {

                    Swal.fire({
                        type: "success",
                        title: 'Created!',
                        text: response.msg,
                        confirmButtonClass: 'btn btn-success',
                    })

                    form.trigger("reset");
                    loadContacts()

                } else {
                    Swal.fire({
                        title: "Error!",
                        text: response.msg,
                        type: "error",
                        confirmButtonClass: 'btn btn-primary',
                        buttonsStyling: false,
                    });
                }


            }
        });

    });


</script>