@extends('layouts.app')
@section('after-style')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css/pages/app-todo.css')}}">
@endsection
@section('leftbar-todo-active', 'active')

@section('breadcrumbs')
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Sales Orders</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('body-class', 'vertical-layout vertical-menu-modern content-left-sidebar todo-application navbar-floating footer-static')
@section('body-data-open', 'click')
@section('body-data-menu', 'vertical-menu-modern')
@section('body-data-col', 'content-left-sidebar')

@section('div-class', 'content-area-wrapper')
@section('content-body')
<div class="sidebar-left">
    <div class="sidebar">
        <div class="sidebar-content todo-sidebar d-flex">
            <span class="sidebar-close-icon">
                <i class="feather icon-x"></i>
            </span>
            <div class="todo-app-menu">
                <div class="form-group text-center add-task">
                    <button type="button" class="btn btn-primary btn-block my-1" data-toggle="modal" data-target="#addTaskModal">Add Task</button>
                </div>
                <div class="sidebar-menu-list">

                    <hr>
                    <h5 class="mt-2 mb-1 pt-25">Task Status</h5>
                    <div class="list-group list-group-filters font-medium-1">
                        <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-star mr-50"></i> Pending</a>
                        <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-info mr-50"></i> Important</a>
                        <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-check mr-50"></i> Completed</a>
                        <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-trash mr-50"></i> Trashed</a>
                    </div>
                    <hr>
                    <h5 class="mt-2 mb-1 pt-25">Groups</h5>
                    <div class="list-group list-group-labels font-medium-1">
                        <a href="#" class="list-group-item list-group-item-action border-0 d-flex align-items-center"><span class="bullet bullet-primary mr-1"></span> ITD-US Purchase</a>
                        <a href="#" class="list-group-item list-group-item-action border-0 d-flex align-items-center"><span class="bullet bullet-warning mr-1"></span> ITD-US Sales</a>
                        <a href="#" class="list-group-item list-group-item-action border-0 d-flex align-items-center"><span class="bullet bullet-success mr-1"></span> ITD-CA Sales</a>
                        <a href="#" class="list-group-item list-group-item-action border-0 d-flex align-items-center"><span class="bullet bullet-danger mr-1"></span> HNS-US Sales</a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="addTaskModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                    <section class="todo-form">
                        <form id="form-add-todo" class="todo-input">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add Task</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="todo-item-action ml-auto">
                                    <a class='todo-item-info'><i class="feather icon-info"></i></a>
                                    <a class='todo-item-favorite'><i class="feather icon-star"></i></a>
                                    <div class="dropdown todo-item-label">
                                        <i class="dropdown-toggle mr-0 mb-1 feather icon-user-plus" id="todoLabel" data-toggle="dropdown">
                                        </i>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="todoLabel">
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="primary" data-value="Frontend">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>Sales</span>
                                                </div>
                                            </div>
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="warning" data-value="Backend">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>Accounts</span>
                                                </div>
                                            </div>
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="success" data-value="Doc">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>Purchase</span>
                                                </div>
                                            </div>
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="danger" data-value="Bug">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>Development</span>
                                                </div>
                                            </div>
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="danger" data-value="Bug">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>IT Support</span>
                                                </div>
                                            </div>
                                            <div class="dropdown-item">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" data-color="danger" data-value="Bug">
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check mr-0"></i>
                                                        </span>
                                                    </span>
                                                    <span>HR</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                <div class="col-md-12">
                                <fieldset class="form-group">
                                    <input type="text" class="new-todo-item-title form-control" placeholder="Title">
                                </fieldset>
                                </div>
                                <div class="col-md-6">
                                <fieldset class="form-group">
                                    <select class="form-control" id="basicSelect">
                                        <option>Companies</option>
                                        <option>ITD - USA Commerical</option>
                                        <option>ITD - USA Bidding</option>
                                        <option>ITD - CA</option>
                                        <option>Googoz</option>
                                        <option>T4D</option>
                                        <option>HNS</option>
                                    </select>
                                </fieldset>
                                </div>
                                <div class="col-md-6">
                                    <fieldset class="form-group">
                                        <input type="text" class="new-todo-item-title form-control" placeholder="Sales Head - Damon" disabled>
                                    </fieldset>
                            </div>
                            <div class="col-md-12">
                                <fieldset class="form-group">
                                    <textarea class="new-todo-item-desc form-control" rows="3" placeholder="Add description"></textarea>
                                </fieldset>
                            </div>
                        </div>
                            <div class="modal-footer">
                                <fieldset class="form-group position-relative has-icon-left mb-0">
                                    <button type="button" class="btn btn-primary add-todo-item" data-dismiss="modal"><i class="feather icon-check d-block d-lg-none"></i>
                                        <span class="d-none d-lg-block">Add Task</span></button>
                                </fieldset>
                                <fieldset class="form-group position-relative has-icon-left mb-0">
                                    <button type="button" class="btn btn-outline-light" data-dismiss="modal"><i class="feather icon-x d-block d-lg-none"></i>
                                        <span class="d-none d-lg-block">Cancel</span></button>
                                </fieldset>
                            </div>
                        </form>
                    </section>
                </div>
            </div>
        </div>

    </div>
</div>
<div class="content-right">
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <div class="app-content-overlay"></div>
            <div class="todo-app-area">
                <div class="todo-app-list-wrapper">
                    <div class="todo-app-list">
                        <div class="app-fixed-search">
                            <div class="sidebar-toggle d-block d-lg-none"><i class="feather icon-menu"></i></div>
                            <fieldset class="form-group position-relative has-icon-left m-0">
                                <input type="text" class="form-control" id="todo-search" placeholder="Search..">
                                <div class="form-control-position">
                                    <i class="feather icon-search"></i>
                                </div>
                            </fieldset>
                        </div>
                        <div class="todo-task-list list-group">
                            <ul class="todo-task-list-wrapper media-list">
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Create tax Field Editable 💻</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Frontend"><span class="bullet bullet-success bullet-xs"></span> Sales - Asad</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info success'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Zunair Please make tax field editable on view page. Thank You!</p>
                                </li>
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Meet Jane ❤️</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Frontend"><span class="bullet bullet-primary bullet-xs"></span> Frontend</span>
                                                    </div>
                                                </div>
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Backend"><span class="bullet bullet-warning bullet-xs"></span> Backend</span>
                                                    </div>
                                                </div>
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Doc"><span class="bullet bullet-success bullet-xs"></span> Doc</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info success'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite warning'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Hello purchase please buy one more part in mentioned So, Accounts Please coordinate.</p>
                                </li>
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Pick up Natasha 😁</h6>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info success'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite warning'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Sweet roll toffee dragée cotton candy jelly beans halvah gingerbread jelly-o. Ice cream bear claw sugar plum powder.</p>
                                </li>
                                <li class="todo-item completed" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox" checked>
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Skype Tommy</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Bug"><span class="bullet bullet-danger bullet-xs"></span> Bug</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Tart oat cake sesame snaps lollipop croissant cake biscuit.</p>
                                </li>
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Send PPT 🎁</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Backend"><span class="bullet bullet-warning bullet-xs"></span> Backend</span>
                                                    </div>
                                                </div>
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Doc"><span class="bullet bullet-success bullet-xs"></span> Doc</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info success'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite warning'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Dragée gummi bears tiramisu brownie cookie. Jelly beans pudding marzipan fruitcake muffin. Wafer gummi bears lollipop pudding lollipop biscuit.</p>
                                </li>
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Submit Report</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Frontend"><span class="bullet bullet-primary bullet-xs"></span> Frontend</span>
                                                    </div>
                                                </div>
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Doc"><span class="bullet bullet-success bullet-xs"></span> Doc</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite warning'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Donut tart toffee cake cookie gingerbread. Sesame snaps brownie sugar plum candy canes muffin cotton candy.</p>
                                </li>
                                <li class="todo-item" data-toggle="modal" data-target="#editTaskModal">
                                    <div class="todo-title-wrapper d-flex justify-content-between mb-50">
                                        <div class="todo-title-area d-flex align-items-center">
                                            <div class="title-wrapper d-flex">
                                                <div class="vs-checkbox-con">
                                                    <input type="checkbox">
                                                    <span class="vs-checkbox vs-checkbox-sm">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                </div>
                                                <h6 class="todo-title mt-50 mx-50">Refactor Code</h6>
                                            </div>
                                            <div class="chip-wrapper">
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Doc"><span class="bullet bullet-success bullet-xs"></span> Doc</span>
                                                    </div>
                                                </div>
                                                <div class="chip mb-0">
                                                    <div class="chip-body">
                                                        <span class="chip-text" data-value="Backend"><span class="bullet bullet-warning bullet-xs"></span> Backend</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="float-right todo-item-action d-flex">
                                            <a class='todo-item-info success'><i class="feather icon-info"></i></a>
                                            <a class='todo-item-favorite warning'><i class="feather icon-star"></i></a>
                                            <a class='todo-item-delete'><i class="feather icon-trash"></i></a>
                                        </div>
                                    </div>
                                    <p class="todo-desc truncate mb-0">Pie liquorice wafer cotton candy danish. Icing topping jelly-o halvah pastry lollipop.</p>
                                </li>
                            </ul>
                            <div class="no-results">
                                <h5>No Items Found</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal -->
            <div class="modal fade" id="editTaskModal" tabindex="-1" role="dialog" aria-labelledby="editTodoTask" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
                    <div class="modal-content">
                        <section class="todo-form">
                            <form id="form-edit-todo" class="todo-input">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editTodoTask">Edit Task</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="todo-item-action ml-auto">
                                        <a class='todo-item-info'><i class="feather icon-info"></i></a>
                                        <a class='todo-item-favorite'><i class="feather icon-star"></i></a>
                                        <div class="dropdown todo-item-label">
                                            <i class="dropdown-toggle mr-0 mb-1 feather icon-tag" id="todoEditLabel" data-toggle="dropdown">
                                            </i>
                                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="todoEditLabel">
                                                <div class="dropdown-item">
                                                    <div class="vs-checkbox-con">
                                                        <input type="checkbox" data-color="primary" data-value="Frontend">
                                                        <span class="vs-checkbox">
                                                            <span class="vs-checkbox--check">
                                                                <i class="vs-icon feather icon-check mr-0"></i>
                                                            </span>
                                                        </span>
                                                        <span>Frontend</span>
                                                    </div>
                                                </div>
                                                <div class="dropdown-item">
                                                    <div class="vs-checkbox-con">
                                                        <input type="checkbox" data-color="warning" data-value="Backend">
                                                        <span class="vs-checkbox">
                                                            <span class="vs-checkbox--check">
                                                                <i class="vs-icon feather icon-check mr-0"></i>
                                                            </span>
                                                        </span>
                                                        <span>Backend</span>
                                                    </div>
                                                </div>
                                                <div class="dropdown-item">
                                                    <div class="vs-checkbox-con">
                                                        <input type="checkbox" data-color="success" data-value="Doc">
                                                        <span class="vs-checkbox">
                                                            <span class="vs-checkbox--check">
                                                                <i class="vs-icon feather icon-check mr-0"></i>
                                                            </span>
                                                        </span>
                                                        <span>Doc</span>
                                                    </div>
                                                </div>
                                                <div class="dropdown-item">
                                                    <div class="vs-checkbox-con">
                                                        <input type="checkbox" data-color="danger" data-value="Bug">
                                                        <span class="vs-checkbox">
                                                            <span class="vs-checkbox--check">
                                                                <i class="vs-icon feather icon-check mr-0"></i>
                                                            </span>
                                                        </span>
                                                        <span>Bug</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <fieldset class="form-group">
                                        <input type="text" class="new-todo-item-title form-control" placeholder="Title">
                                    </fieldset>
                                    <fieldset class="form-group">
                                        <textarea class="new-todo-item-desc form-control" rows="3" placeholder="Add description"></textarea>
                                    </fieldset>
                                </div>
                                <div class="modal-footer">
                                    <fieldset class="form-group position-relative has-icon-left mb-0">
                                        <button type="button" class="btn btn-primary add-todo-item" data-dismiss="modal"><i class="feather icon-edit d-block d-lg-none"></i>
                                            <span class="d-none d-lg-block">Update</span></button>
                                    </fieldset>
                                    <fieldset class="form-group position-relative has-icon-left mb-0">
                                        <button type="button" class="btn" data-dismiss="modal"><i class="feather icon-x d-block d-lg-none"></i>
                                            <span class="d-none d-lg-block">Cancel</span></button>
                                    </fieldset>
                                </div>
                            </form>
                        </section>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


@endsection

@section('after-scripts')
<script src="{{asset('app-assets/js/scripts/pages/app-todo.js')}}"></script>
    <script>
        $('#sale-order-datatable').DataTable();
    </script>
@endsection
