<?php

use App\Mail\PurchaseMail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/look-up/one', [App\Http\Controllers\LookupController::class, 'one'])->name('orders.one');
// Route::get('/look-up/two', [App\Http\Controllers\LookupController::class, 'two'])->name('orders.two');
// Route::get('/look-up/one-three', [App\Http\Controllers\LookupController::class, 'onethree'])->name('orders.three');

Route::get('/', function () {
    return redirect('login');
});


Route::get('/quick-access', function () {

    return view('quick-access');

});

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware('auth');

Route::get('/todo', function () {
    return view('taskmanagement.todo');
})->middleware('auth')->name('todo');
//  Auth::routes();
Route::get('/history', function () {
    return view('taskmanagement.history');
})->middleware('auth')->name('history');
//  Auth::routes();
Route::get('/calender', function () {
    return view('taskmanagement.calender');
})->middleware('auth')->name('calender');
//  Auth::routes();
Route::get('/chat', function () {
    return view('taskmanagement.chat');
})->middleware('auth')->name('chat');
//  Auth::routes();

Route::get('/dashboard/mush', function () {
    return view('dashboard.mush');
})->middleware('auth')->name('mush');
//  Auth::routes();

Route::get('/dashboard/sales', function () {
    return view('dashboard.sales');
})->middleware('auth')->name('sales');
//  Auth::routes();
Route::get('/dashboard/accounts', function () {
    return view('dashboard.accounts');
})->middleware('auth')->name('accounts');
//  Auth::routes();
Route::get('/dashboard/marketing', function () {
    return view('dashboard.marketing');
})->middleware('auth')->name('marketing');
//  Auth::routes();

Route::get('/inventory/all-products', function () {
    return view('inventory.all-products');
})->middleware('auth')->name('all-products');
//  Auth::routes();

Route::get('/inventory/add-product', function () {
    return view('inventory.add-product');
})->middleware('auth')->name('add-product');
//  Auth::routes();

Route::get('/inventory/add-category', function () {
    return view('inventory.add-category');
})->middleware('auth')->name('add-category');
//  Auth::routes();

Route::get('/inventory/all-categories', function () {
    return view('inventory.all-categories');
})->middleware('auth')->name('all-categories');
//  Auth::routes();

Route::get('/inventory/add-brand', function () {
    return view('inventory.add-brand');
})->middleware('auth')->name('add-brand');
//  Auth::routes();

Route::get('/inventory/all-brands', function () {
    return view('inventory.all-brands');
})->middleware('auth')->name('all-brands');
//  Auth::routes();


Route::
        namespace('Auth')->group(function () {
            Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'show_login_form'])->name('login');
            Route::post('/login', [App\Http\Controllers\Auth\LoginController::class, 'process_login'])->name('login');
            Route::get('/register', [App\Http\Controllers\Auth\LoginController::class, 'show_signup_form'])->name('register');
            Route::post('/register', [App\Http\Controllers\Auth\LoginController::class, 'process_signup']);
            Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
            // Route::post('/user/update-user-company', [App\Http\Controllers\Auth\LoginController::class, 'updateUserCompany'])->name('update_user_company');
            Route::post('/user/update-user-company', [App\Http\Controllers\HomeController::class, 'updateUserCompany'])->name('update_user_company');
            Route::post('/user/update-user-company-form', [App\Http\Controllers\HomeController::class, 'updateUserCompanyForm'])->name('update_user_company_form');

        });

Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/orders', [App\Http\Controllers\OrderController::class, 'index'])->name('orders.index');
Route::get('/orders/list-check', [App\Http\Controllers\OrderController::class, 'list_check'])->name('orders.list-check');





Route::post('/orders/upload-csv', [App\Http\Controllers\OrderController::class, 'processCSV'])->name('orders.processcsv');


//Route::get('/orders/create', [App\Http\Controllers\OrderController::class, 'create'])->name('orders.create');
Route::get('/orders/detail/{slug}', [App\Http\Controllers\OrderController::class, 'show'])->name('orders.show');
Route::post('/orders/customer-orders-limit', [App\Http\Controllers\OrderController::class, 'customerOrdersLimit'])->name('customer_orders_limit');
Route::post('/orders/brands', [App\Http\Controllers\OrderController::class, 'order_brands'])->name('order-brands');

Route::post('/orders/parts', [App\Http\Controllers\OrderController::class, 'order_parts'])->name('order-parts');


Route::get('/orders/no-inv-so', [App\Http\Controllers\OrderController::class, 'no_inv_so'])->name('orders.no_inv_so');


Route::get('/orders/create', [App\Http\Controllers\Orders\OrderController::class, 'create'])->name('orders.create');

//orders basic info
Route::get('/orders/create/user/autocomplete', [App\Http\Controllers\Orders\OrderController::class, 'autocomplete'])->name('orders.autocomplete');

Route::get('/orders/create/basic-information/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'create_basic'])->name('orders.create-basic');
Route::post('/orders/store/basic-information/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'store_basic'])->name('orders.store-basic');
Route::get('/orders/customer/payments-methods/{id}', [App\Http\Controllers\Orders\GeneralController::class, 'payment_methods']);
//orders address info
Route::get('/orders/create/address-information/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'create_address'])->name('orders.create-address');
Route::get('/orders/customer/shipping-address/{id}', [App\Http\Controllers\Orders\GeneralController::class, 'shipping_address']);
Route::get('/orders/customer/shipping-contact/{id}', [App\Http\Controllers\Orders\GeneralController::class, 'shipping_contact']);
Route::post('/orders/store/update-address/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'update_address'])->name('orders.update-address');

//line items
Route::get('/orders/create/line-items/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'create_line_items'])->name('orders.create-line-items');
Route::post('/orders/store/update-line-items/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'update_line_items'])->name('orders.update-address');

//other charges
Route::get('/orders/create/other-charges/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'create_other_charges'])->name('orders.create-other-charges');
Route::post('/orders/store/update-other-charges/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'update_other_charges'])->name('orders.update-charges');

//References
Route::get('/orders/create/references/{slug}', [App\Http\Controllers\Orders\OrderController::class, 'create_references'])->name('orders.create-references');

Route::get('/customers', [App\Http\Controllers\CustomerController::class, 'index'])->name('customer.index');
Route::get('/customers/create', [App\Http\Controllers\CustomerController::class, 'create'])->name('customer.create');
Route::get('/customers/edit/{id}', [App\Http\Controllers\CustomerController::class, 'edit'])->name('customer.edit');
Route::put('/customers/update/{id}', [App\Http\Controllers\CustomerController::class, 'update'])->name('customer.update');
Route::post('/customers/store', [App\Http\Controllers\CustomerController::class, 'store'])->name('customer.store');
Route::get('/customer/addresses/{id}', [App\Http\Controllers\CustomerController::class, 'customer_addresses'])->name('customer-addresses');
Route::post('/customer/address/{id}', [App\Http\Controllers\CustomerController::class, 'store_address'])->name('store-address');

Route::get('/customers/address/edit/{id}', [App\Http\Controllers\CustomerController::class, 'address_edit'])->name('customer-address.edit');
Route::put('/customers/address-update/{id}', [App\Http\Controllers\CustomerController::class, 'address_update'])->name('customer-address.update');

Route::get('/customer/contacts/{id}', [App\Http\Controllers\CustomerController::class, 'customer_contacts'])->name('customer-contacts');
Route::post('/customer/contact/{id}', [App\Http\Controllers\CustomerController::class, 'store_contact'])->name('store-contact');

Route::get('/customers/contact/edit/{id}', [App\Http\Controllers\CustomerController::class, 'contact_edit'])->name('customer-contact.edit');
Route::put('/customers/contact-update/{id}', [App\Http\Controllers\CustomerController::class, 'contact_update'])->name('customer-contact.update');
Route::get('/customers/credit-cards/{id}', [App\Http\Controllers\CustomerController::class, 'customer_cards'])->name('customer-creditcards');
Route::get('/customers/credit-card/edit/{id}', [App\Http\Controllers\CustomerController::class, 'card_edit'])->name('customer-card.edit');
Route::put('/customers/credit-update/{id}', [App\Http\Controllers\CustomerController::class, 'card_update'])->name('customer-card.update');
Route::get('/customers/credit-cards/{id}', [App\Http\Controllers\CustomerController::class, 'customer_cards'])->name('customer-creditcards');
Route::get('/customers/history/{id}', [App\Http\Controllers\CustomerController::class, 'customer_history'])->name('customer-history');
Route::post('/customers/credit-card/store/{id}', [App\Http\Controllers\CustomerController::class, 'store_card'])->name('customer-card.store');
Route::put('/customers/credit-card-update/{id}', [App\Http\Controllers\CustomerController::class, 'customer_payment_update'])->name('customer-payment.update');


//vendors
Route::get('/vendors', [App\Http\Controllers\VendorController::class, 'index'])->name('vendor.index');
Route::get('/vendors/create', [App\Http\Controllers\VendorController::class, 'create'])->name('vendor.create');
Route::get('/vendors/edit/{id}', [App\Http\Controllers\VendorController::class, 'edit'])->name('vendor.edit');
Route::put('/vendors/update/{id}', [App\Http\Controllers\VendorController::class, 'update'])->name('vendor.update');
Route::post('/vendors/store', [App\Http\Controllers\VendorController::class, 'store'])->name('vendor.store');

//permissions
Route::get('/permissions', [App\Http\Controllers\PermissionController::class, 'index'])->name('permission.index');
Route::get('/permissions/create', [App\Http\Controllers\PermissionController::class, 'create'])->name('permission.create');
Route::get('/permissions/edit/{id}', [App\Http\Controllers\PermissionController::class, 'edit'])->name('permission.edit');
Route::put('/permissions/update/{id}', [App\Http\Controllers\PermissionController::class, 'update'])->name('permission.update');
Route::post('/permissions/store', [App\Http\Controllers\PermissionController::class, 'store'])->name('permission.store');

//roles
Route::get('/roles', [App\Http\Controllers\RoleController::class, 'index'])->name('role.index');
Route::get('/roles/create', [App\Http\Controllers\RoleController::class, 'create'])->name('role.create');
Route::get('/roles/edit/{id}', [App\Http\Controllers\RoleController::class, 'edit'])->name('role.edit');
Route::get('/roles/permissions/{id}', [App\Http\Controllers\RoleController::class, 'rolePermissions'])->name('role.permission');
Route::put('/roles/update/{id}', [App\Http\Controllers\RoleController::class, 'update'])->name('role.update');
Route::post('/roles/store', [App\Http\Controllers\RoleController::class, 'store'])->name('role.store');

Route::get('/banks', [App\Http\Controllers\BankController::class, 'index'])->name('bank.index');
Route::get('/banks/create', [App\Http\Controllers\BankController::class, 'create'])->name('bank.create');
Route::get('/banks/edit/{id}', [App\Http\Controllers\BankController::class, 'edit'])->name('bank.edit');
Route::put('/banks/update/{id}', [App\Http\Controllers\BankController::class, 'update'])->name('bank.update');
Route::post('/banks/store', [App\Http\Controllers\BankController::class, 'store'])->name('bank.store');
Route::post('/update/bank/transaction/{id}', [App\Http\Controllers\Reports\BankController::class, 'update_transaction'])->name('update-transaction');

Route::get('payment-gateways', [App\Http\Controllers\PaymentGatewayController::class, 'index'])->name('gateways.index');
Route::get('payment-gateways/view/{id}', [App\Http\Controllers\PaymentGatewayController::class, 'show'])->name('gateways.show');
//Route::post('save-payment-gateway', [App\Http\Controllers\CreditApplicationController::class, 'store_gateway'])->name('store.gateway');
Route::get('new-payment-gateways', [App\Http\Controllers\PaymentGatewayController::class, 'create'])->name('add-new-gateway');
Route::post('save-payment-gateway', [App\Http\Controllers\PaymentGatewayController::class, 'store_gateway'])->name('store.gateway');

//Credit Applications
Route::get('/credit-card-applications', [App\Http\Controllers\CreditApplicationController::class, 'applications_index'])->name('credit-apps.index');
Route::get('/credit-card-application/{slug}', [App\Http\Controllers\CreditApplicationController::class, 'application_view'])->name('credit-app.view');
Route::post('/store-user-application/{slug}', [App\Http\Controllers\CreditApplicationController::class, 'store_contact'])->name('credit-app.store_contact');
Route::get('/credit-card-applications', [App\Http\Controllers\CreditApplicationController::class, 'applications_index'])->name('credit-apps.index');

Route::post('/create-company-link', [App\Http\Controllers\CreditApplicationController::class, 'create_company_link'])->name('create-company-link');
//Credit Authorizations
Route::get('/credit-card-authorizations', [App\Http\Controllers\CreditApplicationController::class, 'authorizations_index'])->name('credit-auths.index');

Route::get('/credit-card/auth-attachments/{slug}', [App\Http\Controllers\CreditApplicationController::class, 'authorizations_attchments'])->name('credit-authorizations-attachments');

Route::post('/create-authorization-link', [App\Http\Controllers\CreditApplicationController::class, 'create_authorization_link'])->name('create-authorization-link');
// companies


Route::get('/companies', [App\Http\Controllers\CompanyController::class, 'index'])->name('companies.index');
Route::get('/companies/create', [App\Http\Controllers\CompanyController::class, 'create'])->name('companies.create');
Route::get('/companies/edit/{id}', [App\Http\Controllers\CompanyController::class, 'edit'])->name('companies.edit');
Route::put('/companies/update/{id}', [App\Http\Controllers\CompanyController::class, 'update'])->name('companies.update');
Route::post('/companies/store', [App\Http\Controllers\CompanyController::class, 'store'])->name('companies.store');
Route::get('/load-admin-companies', [App\Http\Controllers\CompanyController::class, 'admin_companies'])->name('load-admin-companies');

//API's
Route::get('/orders/details/{slug}', [App\Http\Controllers\OrderController::class, 'details'])->name('orders.details');
Route::get('/orders/edit/{slug}', [App\Http\Controllers\OrderController::class, 'edit'])->name('orders.edit');

Route::get('/orders/purchases/{slug}', [App\Http\Controllers\OrderController::class, 'purchases'])->name('orders.purchases');
Route::get('/orders/attachments/{slug}', [App\Http\Controllers\OrderController::class, 'attachments'])->name('orders.attachments');
Route::get('/orders/modify/{slug}', [App\Http\Controllers\OrderController::class, 'modify'])->name('orders.modify');
Route::post('/orders/purchase-form/{slug}', [App\Http\Controllers\OrderController::class, 'purchase_form'])->name('orders.purchase-form');
Route::post('/orders/receivable-form/{slug}', [App\Http\Controllers\OrderController::class, 'receivable_form'])->name('orders.receivable-form');
Route::get('/orders/items/{slug}', [App\Http\Controllers\OrderController::class, 'deal_items'])->name('orders.deal-items');


Route::get('/orders/destroydelete-attachment/{id}', [App\Http\Controllers\AttachmentController::class, 'destroydelete'])->name('destroydelete-attachment');

Route::get('/orders/invoices/{slug}', [App\Http\Controllers\OrderController::class, 'invoices'])->name('orders.invoices');
Route::get('/orders/receivables/{slug}', [App\Http\Controllers\OrderController::class, 'receivables'])->name('orders.receivables');
Route::get('/orders/activities/{slug}', [App\Http\Controllers\OrderController::class, 'activities'])->name('orders.activities');
Route::post('/orders/proceed-order/{slug}', [App\Http\Controllers\OrderController::class, 'proceed_order'])->name('orders.proceed-order');
Route::get('/orders/returns/{slug}', [App\Http\Controllers\OrderController::class, 'order_returns'])->name('orders.returns');
Route::post('/orders/search-so', [App\Http\Controllers\OrderController::class, 'getDealByNumber'])->name('search-po');

//order attachmets
Route::post('/orders/save-attachments/{slug}', [App\Http\Controllers\AttachmentController::class, 'order_store'])->name('orders.order-attachments');
Route::post('/orders/reference-text/{slug}', [App\Http\Controllers\AttachmentController::class, 'reference_text'])->name('orders.order-reference-text');


Route::get('/orders/create-invoices/{slug}', [App\Http\Controllers\InvoiceController::class, 'create'])->name('invoices.create');
Route::post('/orders/save-invoice/{slug}', [App\Http\Controllers\InvoiceController::class, 'store'])->name('invoices.store');

Route::get('/invoice/edit/{slug}', [App\Http\Controllers\InvoiceModifyController::class, 'edit'])->name('invoice.edit');
Route::post('/orders/invoice-department-update', [App\Http\Controllers\InvoiceModifyController::class, 'department_update'])->name('invoice-department-update');

Route::post('/invoice/update-invoice', [App\Http\Controllers\InvoiceModifyController::class, 'updateInvoice'])->name('update_invoice');
Route::post('/invoice/update-invoice-line-item', [App\Http\Controllers\InvoiceModifyController::class, 'updateInvoiceLineItem'])->name('update_invoice_line_item');
Route::post('/invoice/insert-invoice-line-item', [App\Http\Controllers\InvoiceModifyController::class, 'insertInvoiceLineItem'])->name('insert_invoice_line_item');
Route::post('/invoice/item-delete', [App\Http\Controllers\InvoiceModifyController::class, 'itemDelete'])->name('invoices.item-delete');

// order purchase
Route::post('/orders/purchase-store/{slug}', [App\Http\Controllers\PurchaseController::class, 'store'])->name('orders.purchase-store');
Route::post('/orders/purchase-item-show', [App\Http\Controllers\PurchaseController::class, 'purchase_item_show'])->name('orders.purchase-item-show');
Route::post('/orders/purchase-item-update/{id}', [App\Http\Controllers\PurchaseController::class, 'purchase_item_update'])->name('orders.purchase-item-update');

Route::post('/orders/update-deal', [App\Http\Controllers\OrderModifyController::class, 'updateDeal'])->name('update_deal');
Route::post('/orders/update-deal-line-item', [App\Http\Controllers\OrderModifyController::class, 'updateDealLineItem'])->name('update_deal_line_item');
Route::post('/orders/insert-deal-line-item/{slug}', [App\Http\Controllers\OrderModifyController::class, 'insertDealLineItem'])->name('insert_deal_line_item');

Route::post('/orders/salesorder-month-year-update', [App\Http\Controllers\OrderModifyController::class, 'salesorder_month_year_update'])->name('salesorder-month-year-update');

Route::post('/orders/update-shipping-info/{slug}', [App\Http\Controllers\OrderModifyController::class, 'updateShippingInfo'])->name('update-shipping-info');
Route::post('/orders/update-shipping-method/{slug}', [App\Http\Controllers\OrderModifyController::class, 'updateShippingMethod'])->name('update-shipping-method');
Route::post('/orders/update-charges-method/{slug}', [App\Http\Controllers\OrderModifyController::class, 'updateChargesMethod'])->name('update-charges-method');
Route::post('/orders/update-payment-method/{slug}', [App\Http\Controllers\OrderModifyController::class, 'updatePaymentMethod'])->name('update-payment-method');
Route::post('/orders/update-sale-person/{slug}', [App\Http\Controllers\OrderModifyController::class, 'updateSalePerson'])->name('update-sale-person');


Route::post('/deal/store', [App\Http\Controllers\DealController::class, 'store'])->name('deal.store');


Route::post('/shipping_account/get_shipping_account_details', [App\Http\Controllers\ShippingAccountController::class, 'getShippingAccountDetails'])->name('get_shipping_account_details');

// Route::get('/orders/item-delete/{itemId}/{dealId}', [App\Http\Controllers\OrderModifyController::class, 'itemDelete'])->name('orders.item-delete');
Route::post('/orders/item-delete', [App\Http\Controllers\OrderModifyController::class, 'itemDelete'])->name('orders.item-delete');
// Route::post('/orders/update-deal-ref', [App\Http\Controllers\OrderModifyController::class, 'updateDealRef'])->name('update_deal_ref');
// Route::post('/orders/update-deal-created-at', [App\Http\Controllers\OrderModifyController::class, 'updateDealCreatedAt'])->name('update_deal_created_at');
// Route::post('/orders/update-deal-company-Name', [App\Http\Controllers\OrderModifyController::class, 'updateDealCompanyName'])->name('update_deal_ref');


// pdf
Route::get('/pdf/order/{slug}', [App\Http\Controllers\PdfController::class, 'order'])->name('pdf.order');
Route::get('/pdf/view/{slug}', [App\Http\Controllers\PdfController::class, 'view'])->name('pdf.view');
Route::get('/pdf/purchase/{slug}/{id}', [App\Http\Controllers\PdfController::class, 'purchase_view'])->name('pdf.purchase-view');
Route::get('/pdf/invoice/{slug}', [App\Http\Controllers\PdfController::class, 'invoice'])->name('pdf.invoice');

Route::get('/pdf/return/{slug}', [App\Http\Controllers\PdfController::class, 'order_return'])->name('pdf.return');

Route::get('/pdf/bank/transactions', [App\Http\Controllers\Reports\BankController::class, 'bank_pdf'])->name('pdf.bank');


Route::get('/reporting/receivables/aged/pdf', [App\Http\Controllers\Reports\ReceivableController::class, 'aged_pdf'])->name('aged-receivables-pdf');
Route::get('/reporting/receivable/aged/pdf/{slug}', [App\Http\Controllers\Reports\ReceivableController::class, 'aged_pdf_single'])->name('aged-receivable-pdf');
Route::get('/reporting/payable/aged/pdf', [App\Http\Controllers\Reports\PayableController::class, 'aged_pdf'])->name('aged-payables-pdf');
Route::get('/reporting/payable/aged/pdf/{slug}', [App\Http\Controllers\Reports\PayableController::class, 'aged_pdf_single'])->name('aged-payable-pdf');
Route::get('/reporting/expenses', [App\Http\Controllers\Reports\ExpenseController::class, 'index'])->name('expenses.index');

Route::get('/reporting/expenses/detail-search/{slug}', [App\Http\Controllers\Reports\ExpenseController::class, 'detail_search'])->name('detail-search');
Route::get('/reporting/bank/payment-gateway/{slug}', [App\Http\Controllers\Reports\BankController::class, 'get_payment_gateway'])->name('expense.get_payment_gateway');


Route::get('/reporting/expenses/vendors', [App\Http\Controllers\Reports\ExpenseController::class, 'vendors'])->name('expenses.vendors');
Route::get('/reporting/expenses/hoa', [App\Http\Controllers\Reports\ExpenseController::class, 'headofaccounts'])->name('expenses.headofaccounts');

Route::get('/reporting/expenses/create', [App\Http\Controllers\Reports\ExpenseController::class, 'create'])->name('expenses.create');
Route::get('/reporting/expenses/edit/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'edit'])->name('expenses.edit');
Route::post('/reporting/expenses/update-info/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'update_info'])->name('expenses.update-info');
Route::post('/reporting/expenses/update-item/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'update_item'])->name('expenses.update-item');
Route::post('/reporting/expenses/create-item/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'create_item'])->name('expenses.create-item');

Route::delete('/reporting/expenses/delete-item/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'delete_item'])->name('expenses.delete-item');

Route::post('/reporting/expenses/store', [App\Http\Controllers\Reports\ExpenseController::class, 'store'])->name('expenses.store');
Route::get('/reporting/expense/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'detail'])->name('expense.detail');
Route::get('/reporting/expense/vendors', [App\Http\Controllers\Reports\ExpenseController::class, 'vendors'])->name('expense.vendor');
Route::get('/expenses/hoav/create/{slug}', [App\Http\Controllers\Reports\HoavController::class, 'create'])->name('hoav.create');
Route::post('/expenses/hoav/store', [App\Http\Controllers\Reports\HoavController::class, 'store'])->name('hoav.store');
Route::get('/reporting/expenses/aged', [App\Http\Controllers\Reports\ExpenseController::class, 'aged'])->name('expenses.aged-payables');
Route::get('/reporting/expenses/aged-invoices/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'aged_invoices']);
Route::post('/reporting/expenses/selected-invoices', [App\Http\Controllers\Reports\ExpenseController::class, 'selected_invoices'])->name('expenses.unprecented-invoices');
Route::post('/reporting/expenses/single-transaction', [App\Http\Controllers\Reports\ExpenseController::class, 'single_transaction'])->name('expenses.single-transaction');
Route::get('/reporting/expenses/delete-transaction', [App\Http\Controllers\Reports\ExpenseController::class, 'delete_transaction'])->name('expenses.delete-transaction');
Route::get('/reporting/expenses/delete-expense/{id}', [App\Http\Controllers\Reports\ExpenseController::class, 'delete_expense'])->name('expenses.delete-expense');



Route::post('/orders/existing-customer-search', [App\Http\Controllers\CustomerController::class, 'existingCustomerSearch'])->name('existing_customer_search');
Route::post('/orders/get-customer-details', [App\Http\Controllers\CustomerController::class, 'getCustomerDetails'])->name('get_customer_details');
Route::post('/orders/customer-remaining-limit', [App\Http\Controllers\CustomerController::class, 'customerRemainingLimit'])->name('customer_remaining_limit');

//attachments


//income
Route::get('/reporting/incomes', [App\Http\Controllers\Reports\IncomeController::class, 'index'])->name('incomes.index');

Route::get('/reporting/incomes/detail-search/{slug}', [App\Http\Controllers\Reports\IncomeController::class, 'detail_search'])->name('incomes.detail-search');


Route::get('/reporting/incomes/hoa', [App\Http\Controllers\Reports\IncomeController::class, 'headofaccounts'])->name('incomes.hoa');
;

Route::get('/reporting/incomes/create', [App\Http\Controllers\Reports\IncomeController::class, 'create'])->name('incomes.create');
Route::get('/reporting/incomes/edit/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'edit'])->name('incomes.edit');
Route::post('/reporting/incomes/update-info/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'update_info'])->name('incomes.update-info');
Route::post('/reporting/incomes/update-item/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'update_item'])->name('incomes.update-item');
Route::post('/reporting/incomes/create-item/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'create_item'])->name('incomes.create-item');

Route::delete('/reporting/incomes/delete-item/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'delete_item'])->name('incomes.delete-item');

Route::post('/reporting/incomes/store', [App\Http\Controllers\Reports\IncomeController::class, 'store'])->name('incomes.store');
Route::get('/reporting/income/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'detail'])->name('incomes.detail');
Route::get('/reporting/incomes/vendors', [App\Http\Controllers\Reports\IncomeController::class, 'vendors'])->name('incomes.vendor');
Route::get('/reporting/incomes/aged', [App\Http\Controllers\Reports\IncomeController::class, 'aged'])->name('incomes.aged-receivables');
Route::get('/reporting/incomes/aged-invoices/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'aged_invoices']);
Route::post('/reporting/incomes/selected-invoices', [App\Http\Controllers\Reports\IncomeController::class, 'selected_invoices'])->name('incomes.unprecented-invoices');
Route::post('/reporting/incomes/single-transaction', [App\Http\Controllers\Reports\IncomeController::class, 'single_transaction'])->name('incomes.single-transaction');
Route::get('/reporting/incomes/delete-transaction', [App\Http\Controllers\Reports\IncomeController::class, 'delete_transaction'])->name('incomes.delete-transaction');
Route::get('/reporting/incomes/delete-income/{id}', [App\Http\Controllers\Reports\IncomeController::class, 'delete_expense'])->name('incomes.delete-income');




//purchases 
Route::get('/purchases', [App\Http\Controllers\Purchase\PurchaseController::class, 'index'])->name('purchases.index');

Route::get('/purchases/single/edit_purchase/{soid}/{gid}', [App\Http\Controllers\Purchase\PurchaseController::class, 'edit_purchase'])->name('purchases.edit-purchase');
Route::post('/purchases/single/update_purchase', [App\Http\Controllers\Purchase\PurchaseController::class, 'update_purchase'])->name('purchases.update-purchase');
Route::post('/purchases/item-delete', [App\Http\Controllers\PurchaseController::class, 'item_delete'])->name('purchases.item-delete');


//  invoice
Route::get('/invoice/create/{slug}', [App\Http\Controllers\InvoiceController::class, 'create'])->name('invoice.create');

Route::get('gp-report', function () {

    return view('reports.gp_report');

})->name('report.gross_profit');

Route::get('test-role', function () {

    $user = Auth::user(); //getting the current logged in user
    // dd($user->hasRole('user')); //will return true, if user has role
    // dd($user->givePermissionsTo('create-tasks'));// will return permission, if not null
    // dd($user->can('create-tasks')); // will return true, if user has permission

});

Route::get('/roles', [App\Http\Controllers\PermissionController::class, 'Permission']);
Route::get('/reports/profit-loss', [App\Http\Controllers\ReportingController::class, 'profit_loss'])->name('profit-loss');
Route::get('/reports/profit-loss-sheet', [App\Http\Controllers\ReportingController::class, 'profit_loss_sheet'])->name('profit-loss-sheet');
Route::get('/reports/profit-loss-amazon', [App\Http\Controllers\ReportingController::class, 'profit_loss_amazon'])->name('profit-loss-amazon');
Route::get('/reports/invoice-dateetc', [App\Http\Controllers\ReportingController::class, 'return_deal_dateetc'])->name('return_deal_dateetc');



Route::get('/reports/invoice-register-sheet', [App\Http\Controllers\ReportingController::class, 'invoice_register_sheet'])->name('invoice-register-sheet');

Route::get('/reports/invoice-register-ajax', [App\Http\Controllers\ReportingController::class, 'invoice_register_ajax'])->name('invoice-register-ajax');

Route::get('/reports/receivables-payables', [App\Http\Controllers\ReportingController::class, 'receivables_payables'])->name('reports.receivables-payables');


Route::get('/reports/sales/register', [App\Http\Controllers\ReportingController::class, 'sales_register'])->name('sales-register');
Route::get('/reports/purchase/register', [App\Http\Controllers\ReportingController::class, 'purchase_register'])->name('purchase-register');

Route::get('test', function () {

    $user = [
        'name' => 'Harsukh Makwana',
        'info' => 'Laravel & Python Devloper'
    ];

    \Mail::to('faizanarshadkhan@gmail.com')->send(new PurchaseMail($user));

    dd("success");

});


//api requests

Route::get('/orders/by-companies', [App\Http\Controllers\DealController::class, 'order_shipping_company']);

Route::get('/customers/get-companies', [App\Http\Controllers\DealController::class, 'get_companies'])->name('customer.companies');
Route::get('/customers/get-user', [App\Http\Controllers\DealController::class, 'get_user'])->name('customer.user');

Route::get('/deal-suggestionpart', [App\Http\Controllers\DealController::class, 'get_suggestionpart'])->name('deal-suggestionpart');

Route::post('/load-countries', [App\Http\Controllers\Settings\CountryController::class, 'countries_partials'])->name('load-countries');
Route::post('/load-states', [App\Http\Controllers\Settings\CountryController::class, 'states_partials'])->name('load-states');

Route::get('/customer/invoices/{slug}', [App\Http\Controllers\Reports\ReceivableController::class, 'customer_invoices'])->name('customer-invoices');

//reporting modules

Route::get('/reporting/receivables/aged', [App\Http\Controllers\Reports\ReceivableController::class, 'aged'])->name('aged-receivables');

Route::get('/reporting/receivables/test_aged', [App\Http\Controllers\Reports\ReceivableController::class, 'test_aged'])->name('test_aged-receivables');



Route::get('/reporting/receivables/aged-invoices/{id}', [App\Http\Controllers\Reports\ReceivableController::class, 'aged_invoices']);
Route::post('/reporting/receivables/unprecented-invoices', [App\Http\Controllers\Reports\ReceivableController::class, 'unprecented_invoices'])->name('unprecented-invoices');
Route::get('/reporting/receivables/unpresented', [App\Http\Controllers\Reports\ReceivableController::class, 'unpresented_list'])->name('receivables.unpresented_list');
Route::post('/reporting/receivables/save-unpresented', [App\Http\Controllers\Reports\ReceivableController::class, 'save_unpresented'])->name('receivables.save_unpresented');


Route::get('/reporting/payables/aged', [App\Http\Controllers\Reports\PayableController::class, 'aged'])->name('aged-payables');
Route::get('/reporting/payables/aged-invoices/{id}', [App\Http\Controllers\Reports\PayableController::class, 'aged_invoices']);
Route::post('/reporting/payables/selected-invoices', [App\Http\Controllers\Reports\PayableController::class, 'selected_invoices'])->name('payables.unprecented-invoices');
Route::post('/reporting/payables/save-unpresented', [App\Http\Controllers\Reports\PayableController::class, 'save_unpresented'])->name('payables.save_unpresented');
Route::get('/payables', [App\Http\Controllers\PayableController::class, 'index'])->name('payables.index');
Route::get('/payables/edit/{id}', [App\Http\Controllers\PayableController::class, 'edit'])->name('payables.edit');
Route::put('/payables/update/{id}', [App\Http\Controllers\PayableController::class, 'update'])->name('payables.update');
Route::get('/payables/remove/{id}', [App\Http\Controllers\PayableController::class, 'remove'])->name('payables.remove');


Route::get('/payables-two', [App\Http\Controllers\PayableController::class, 'index_two'])->name('payables.index-two');
Route::post('/payables/update2', [App\Http\Controllers\PayableController::class, 'update2'])->name('payables.update2');

Route::get('/reporting/bank/transactions', [App\Http\Controllers\Reports\BankController::class, 'index'])->name('bank.transactions');
Route::get('/reporting/banks/detail/{id}', [App\Http\Controllers\Reports\BankController::class, 'transaction_details'])->name('transaction.details');
Route::delete('/reporting/bank/delete-transaction/{id}', [App\Http\Controllers\Reports\BankController::class, 'destroy']);


Route::post('/reporting/bank/detail-invoices', [App\Http\Controllers\Reports\BankController::class, 'detail_invoices'])->name('bank.detail-invoices');
Route::post('/reporting/bank/detail-payables', [App\Http\Controllers\Reports\BankController::class, 'detail_payables'])->name('bank.detail-payables');

Route::get('/reporting/card/transactions', [App\Http\Controllers\Reports\CreditCardController::class, 'transactions'])->name('card.transactions');
Route::post('/update/card/transaction/{id}', [App\Http\Controllers\Reports\BankController::class, 'update_transaction'])->name('card.update-transaction');
Route::post('/reporting/paypal/store/{id}', [App\Http\Controllers\Reports\CreditCardController::class, 'paypal_store'])->name('paypal.store');
Route::get('/reporting/card/detail/{id}', [App\Http\Controllers\Reports\CreditCardController::class, 'transaction_details']);
Route::delete('/reporting/card/delete-transaction/{id}', [App\Http\Controllers\Reports\CreditCardController::class, 'destroy']);

Route::get('/reporting/paypal/detail/{id}', [App\Http\Controllers\Reports\PaypalController::class, 'transaction_details']);
Route::delete('/reporting/paypal/delete-transaction/{id}', [App\Http\Controllers\Reports\PaypalController::class, 'destroy']);

Route::get('/reporting/journal/entry', [App\Http\Controllers\Reports\JournalController::class, 'create'])->name('journal-entry.create');
Route::post('/reporting/journal-entry/store', [App\Http\Controllers\Reports\JournalController::class, 'store'])->name('journal-entry.store');
Route::get('/reporting/journals', [App\Http\Controllers\Reports\JournalController::class, 'index'])->name('journals.index');


Route::get('reporting/access', function () {
    $loginId = request()->get('login_status');
    //echo  $loginId;
    Auth::loginUsingId($loginId);
    return redirect()->route('reporting-dashboard');

});

Route::get('panel/access', function () {
    $loginId = request()->get('login_status');
    Auth::loginUsingId($loginId);
    $accessurl = request()->get('access_url');
    return redirect($accessurl);

});




Route::get('/reporting-dashboard', [App\Http\Controllers\ReportingController::class, 'index'])->name('reporting-dashboard');
Route::get('/reporting/load-account-balances', [App\Http\Controllers\ReportingController::class, 'account_balances'])->name('load-account-balances');
Route::get('/reporting/load-aged-payables', [App\Http\Controllers\ReportingController::class, 'aged_payables'])->name('load-aged-payables');

Route::get('/reporting/credit-card-report/{slug}', [App\Http\Controllers\Reports\CreditCardController::class, 'show'])->name('card.details');
Route::get('/reporting/bank-report/{slug}', [App\Http\Controllers\Reports\BankController::class, 'show'])->name('bank.details');

Route::get('/reporting/uninvoiced-orders', [App\Http\Controllers\OrderController::class, 'uninvoiced_orders'])->name('uninvoiced-orders');

Route::get('/reporting/unallocated-invoices', [App\Http\Controllers\InvoiceController::class, 'unallocated_invoices'])->name('unallocated-invoices');

Route::get('/reporting/invoice-transaction/{id}', [App\Http\Controllers\InvoiceController::class, 'invoice_transaction']);

Route::get('/reports/audit', [App\Http\Controllers\Reports\AuditController::class, 'index'])->name('audit.index');

Route::get('/reports/unclosed-orders', [App\Http\Controllers\OrderController::class, 'unclosed_orders'])->name('unclosed-orders');
Route::get('/reports/net-terms-orders', [App\Http\Controllers\OrderController::class, 'order_net_terms'])->name('orders-net-terms');
Route::get('/reports/monthwise-pl', [App\Http\Controllers\Reports\ProfitLossController::class, 'profit_loss_month'])->name('profit-loss-month');
Route::get('/reports/dashboard-payables', [App\Http\Controllers\StatisticsController::class, 'dashboard_payables'])->name('reports.dashboard-payables');
Route::get('/reports/dashboard-receivables', [App\Http\Controllers\StatisticsController::class, 'dashboard_receivables'])->name('reports.dashboard-receivables');

Route::get('/loan/other-receivables-loans', [App\Http\Controllers\Loan\LoanController::class, 'other_receivables_loans'])->name('other-receivables-loans');
Route::get('/loan/history/{id}', [App\Http\Controllers\Loan\LoanController::class, 'loan_history'])->name('user-loan-history');
Route::post('/loan/save', [App\Http\Controllers\Loan\LoanController::class, 'loan'])->name('user-save-loan');
Route::get('/loan/create', [App\Http\Controllers\Loan\LoanController::class, 'create'])->name('user-loan-create');



//->middleware('userType:admin,sale-admin');


Route::get('/customers/report/sales', [App\Http\Controllers\CustomerController::class, 'customer_sales_view'])->name('customers-sales');

Route::get('/customers/report/sales-ajax', [App\Http\Controllers\CustomerController::class, 'customer_sales']);

Route::get('/customers/report/invoices', [App\Http\Controllers\CustomerController::class, 'customer_invoices_view'])->name('customers-invoices');

Route::get('/customers/report/invoices-ajax', [App\Http\Controllers\CustomerController::class, 'customer_invoices']);



