<!DOCTYPE html>
<html>

<head>
	<title></title>
	<style>
	@page  {
		size: a4 portrait;
		margin: 0.5;
		padding: 0.5; // you can set margin and padding 0
	}

	body {
		margin: 0;
		font-family: 'Montserrat', Helvetica, Arial, serif;
		font-size: 1rem;
		font-weight: 400;
		line-height: 1.45;
		color: #626262;
		text-align: left;
		background-color: #ffffff;
	}

	.h2 {
		padding: 12px;
	}

	th,
	td {
		padding: 4px 0;
		text-align: left;
		vertical-align: middle;
	}

	h1,
	h2 {
		font-size: 1.74rem;
	}

	h2 {
		margin-bottom: 0.5rem;
		font-family: inherit;
		font-weight: 500;
		line-height: 1.2;
		color: #2C2C2C;
	}

	.table {
		width: 100%;
		/* margin-bottom: 1rem; */
	}

	.table th {
		font-size: 0.85rem;
	}
	/* .p {
    padding-right: 14px;
    padding-left: 14px;
} */

	.b-heading {
		background: #00a8ff;
		color: #fff;
	}

	.invoice-heading {
		padding: 8px 8px;
	}

	.border {
		border: 1px solid #cbcbcb;
		border-collapse: collapse;
	}

	.borderbottom {
		border-bottom: 1px solid #cbcbcb;
	}

	.invoice_heading {
		padding: 5px 8px;
	}
    .tw2,
    .tw3,
    .tw4,
    .tw5{
        width: 95%;
    }

    .tw1 {
        width: 80%;
    }
.invoice_top_right_tdth{
    padding:1px 8px;
    font-size: 0.85rem;
}
	/* Media Queries */
	@media  and only (max-width: 768px) {
		.table th {
			font-size: 0.85rem;
		}

        .tw1,
        .tw3,
        .tw4{
            width: 88%;
        }

        .tw5 {
            width: 89%;
        }
	}
	</style>
</head>

<body>
	<table class="tw1" align="center">
		<tr>
			<td width="50%">
			<?php
            $orderCompany = $order->company;
            $dealTaxValue = 0;
            $dealChargeAmount = 0;
            $dealShippingCharges = 0;
            $dealCreditCardCharges = 0;
            ?>
        <?php echo $__env->make('partials.company-info-pdf', ['info' => $orderCompany], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			</td>
			<td width="50%">
			<?php
                     $orderType = 'Quote';
                     $dealStatus = $order->dealStatus;
                     $proceedTo = '';

                     if($dealStatus == 'pending'){
                        $orderType = 'Quote';
                     }else{
                        $orderType = 'Sale Order';
                     }

                     if($dealStatus == 'pending'){

                        $proceedTo = 'confirmed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'confirmed'){

                        $proceedTo = 'purchase';
                        $proceedText = 'Proceed to Purchase';

                     }else if($dealStatus == 'purchase'){

                        $proceedTo = 'placed';
                        $proceedText = 'Proceed to Accounts';

                     }else if($dealStatus == 'placed'){

                        $proceedTo = 'closed';
                        $proceedText = 'Close Order';
                     }
                     else if($dealStatus == 'closed'){

                        $proceedTo = '';
                        $proceedText = '';
                        }

                     ?>
				<h2 class="p"><?php echo e($proceedText); ?></h2>
				<table class="table p">
					<tbody>
						<tr>
							<th class="invoice_top_right_tdth">Order</th>
							<td style="text-align: right" class="invoice_top_right_tdth"><?php echo e($order->dealName); ?></td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">SO#</th>
							<td style="text-align: right" class="invoice_top_right_tdth"> <?php echo e($order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-'); ?> </td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">Customer Ref#</th>
							<td style="text-align: right" class="invoice_top_right_tdth"><?php echo e($order->dealRef); ?></td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">Order Date</th>
							<td style="text-align: right" class="invoice_top_right_tdth"> <?php echo e(date('M d, yy', strtotime($order->dealCreatedAt))); ?></td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">Payment Term</th>
							<td style="text-align: right" class="invoice_top_right_tdth"><?php echo e($order->dealPaymentMethod); ?></td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</table>
	<table class="tw2" align="center">
		<tr>
			<td>
			<table class="table border">
                            <thead>
                                <tr class="b-heading ">
                                    <th colspan="3" class="invoice_heading">Billing Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth"><?php echo e($order->dealCompanyName); ?>

                                    </td>
                                    <td width="30%" class="invoice_top_right_tdth"><?php echo e($order->dealPrimaryContact); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth"><?php echo e($order->dealAddress); ?>

                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealCity); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealState); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealPostalCode); ?>

                                    </td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealPhone); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth"><?php echo e($order->dealEmail); ?></td>

                                </tr>
                            </tbody>
                        </table>
			</td>
            <td>
			<table class="table border">
                            <thead>
                                <tr class="b-heading">
                                    <th colspan="3" class="invoice_heading">Shipping Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th width="70%" class="invoice_top_right_tdth">Company Name</th>
                                    <th width="30%" class="invoice_top_right_tdth">Primary Contact</th>

                                </tr>
                                <tr>
                                    <td width="70%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingCompany); ?></td>
                                    <td width="30%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingContact); ?></td>
                                </tr>
                                <tr>
                                    <th width="100%" class="invoice_top_right_tdth">Address</th>
                                </tr>
                                <tr>
                                    <td width="100%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingAddress); ?>

                                </tr>
                                <tr>
                                    <th width="33%" class="invoice_top_right_tdth">City</th>
                                    <th width="33%" class="invoice_top_right_tdth">State</th>
                                    <th width="33%" class="invoice_top_right_tdth">Zip/Postal</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingCity); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingState); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingZip); ?></td>

                                </tr>
                                <tr>
                                    <th width="40%" class="invoice_top_right_tdth">Phone</th>
                                    <th width="60%" class="invoice_top_right_tdth">Email</th>
                                </tr>
                                <tr>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingPhone); ?></td>
                                    <td width="33%" class="invoice_top_right_tdth">
                                        <?php echo e($order->dealShippingEmail); ?></td>

                                </tr>
                            </tbody>
                        </table>
			</td>
		</tr>
	</table>
	<table class="tw3" align="center">
		<tr>
			<td>
				<table class="table border">
					<thead>
						<tr class="b-heading">
							<th class="invoice_heading">Sale Rep Name</th>
							<th class="invoice_heading">Sale Rep Phone </th>
							<th class="invoice_heading">Ship Via </th>
							<th class="invoice_heading">Sale Rep Email</th>
						</tr>
					</thead>
					<tbody>
						<tr>
						<td><?php echo e($order->created_users->firstName . ' ' . $order->created_users->lastName); ?></td>
                        <td><?php echo e($order->created_users->phone); ?></td>
                        <td><?php echo e($order->dealShippingType); ?></td>
                        <td><?php echo e($order->created_users->email); ?></td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</table>
	<table class="tw4" align="center">
		<tr>
			<td>
				<table class="table border">
					<thead>
						<tr class="b-heading">
							<th class="invoice_heading" width="20%">PART NO. </th>
							<th class="invoice_heading" width="40%">DESCRIPTION </th>
							<th class="invoice_heading" width="15%">UNIT PRICE </th>
							<th class="invoice_heading" width="10%">Qty</th>
							<th class="invoice_heading" width="15%">Total</th>
						</tr>
					</thead>
					<?php
					
					$subtotal = 0;
					
					?>
					<tbody> <?php $__currentLoopData = $order->dealItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td class="invoice_top_right_tdth"><?php echo e($item->dealItemName); ?></td>
							<td class="invoice_top_right_tdth"><?php echo e($item->dealItemDescription); ?></td>
							<td class="invoice_top_right_tdth">$ <?php echo e($item->dealItemUnitCost); ?></td>
							<td class="invoice_top_right_tdth"><?php echo e($item->dealItemQuantity); ?></td>
							<td class="invoice_top_right_tdth">$ <?php echo e($item->dealItemUnitCost * $item->dealItemQuantity); ?></td>
						</tr>
						
						<?php
                            $itemCost = $item->dealItemUnitCost * $item->dealItemQuantity;
                            $subtotal =  $subtotal + $itemCost;
                            ?>
						
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
					
						
					</tbody>
				</table>
			</td>
		</tr>
	</table>
	<table class="tw5" align="center">
		<tr>
			<td>
				<table class="table">
					<thead>
                        <!-- <tr class="borderbottom">
							<th class="tbhp invoice_top_right_tdth">Payment Due</th>
							<td colspan="3" class="tbhp">07-23-22</td>
						</tr> -->
						<tr class="borderbottom">
							<th colspan="4" class="invoice_top_right_tdth">ACH/Wire instructions (sample)</th>
						</tr>
                    </thead>
                    <tbody>
						<tr>
							<th class="invoice_top_right_tdth">Account Title</th>
							<td class="invoice_top_right_tdth">IT DEVICES ONLINE INC </td>
							<th class="invoice_top_right_tdth">Account Number</th>
							<td class="invoice_top_right_tdth">80010516542</td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">ABA / Routing Number</th>
							<td class="invoice_top_right_tdth">321081669</td>
							<th class="invoice_top_right_tdth">SWIFT Code</th>
							<td class="invoice_top_right_tdth">FRBBUS6S</td>
						</tr>
						<tr>
							<th class="invoice_top_right_tdth">Bank Name</th>
							<td class="invoice_top_right_tdth">First Republic Bank</td>
							<th class="invoice_top_right_tdth">Bank Address</th>
							<td class="invoice_top_right_tdth">111 Pine Street San Francisco, CA 94111</td>
						</tr>
					</tbody>
				</table>
			</td>
			<td >
				<table class="table border">
					<tbody>
					
					


						<?php if($order->dealCreditCardCharges > 0): ?>
                        <tr class="borderbottom">
                            <th class="invoice_heading">3.5% CC Charges (if any)</th>
                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?>  <?php echo e($order->dealCreditCardCharges); ?></td>
                            <?php 
                            $dealCreditCardCharge = $order->dealCreditCardCharge;
                            ?>
                        </tr>
                        <?php endif; ?>
                        <tr class="borderbottom">
                            <th class="invoice_heading">SubTotal</th>
                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?>  <?php echo e(number_format($subtotal, 2)); ?></td>
                        </tr>
                        <tr class="borderbottom">
                            <th class="invoice_heading">Shipping</th>
                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($order->dealShippingCharges); ?></td>
                            <?php  $dealShippingCharges =  $order->dealShippingCharges;  ?>
                        </tr>
                        <tr class="borderbottom">
                            <th class="invoice_heading">Charges</th>
							<?php  $dealChargeAmount =  $order->dealChargeAmount; 
                                if($order->dealChargeType == 'Amazon Charges'){
                                    $dealChargeAmount = $dealChargeAmount *-1;
                                }
                                ?>
                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($dealChargeAmount); ?></td>
                           
                        </tr>
                        <?php if($order->dealTaxValue > 0): ?>
                        <tr class="borderbottom">
                            <th class="invoice_heading">Tax(<?php echo e($order->dealTaxName); ?>)</th>

                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?> <?php echo e($order->dealTaxValue); ?></td>
                            <?php  $dealTaxValue =  $order->dealTaxValue;  ?>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <th class="invoice_heading">TOTAL</th>
                            <td class="invoice_heading"><?php echo e($orderCompany->companyCurrency); ?> <?php echo e(number_format($subtotal+$dealCreditCardCharges+$dealShippingCharges+$dealChargeAmount+$dealTaxValue, 2)); ?></td>
                        </tr>
					</tbody>
				</table>
			</td>
		</tr>
	</table>

            <table class="table tw5" align="center">
                <tbody>

                    <tr class="border ">
                        <th width="20%" class="tbhp">Tracking</th>
                        <td width="80%" class="tbhp">

						<?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php echo e($purchase->purchaseTracking); ?> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    NA
                                    <?php endif; ?>

						</td>
                    </tr>
                    <tr>
                        <th width="20%" class="tbhp">Serials</th>
                        <td width="80%" class="tbhp">
						<?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php echo e($purchase->purchaseSerial); ?> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    NA
                                    <?php endif; ?>
					
					</td>
                    </tr>
                </tbody>
            </table>
</body>

</html>
<?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/pdf/order.blade.php ENDPATH**/ ?>