
<?php $__env->startSection('leftbar-orders-active', 'active'); ?>



<?php $__env->startSection('breadcrumbs'); ?>
    <div class="content-header-left col-md-9 col-12 mb-2">
        <div class="row breadcrumbs-top">
            <div class="col-12">
                <h2 class="content-header-title float-left mb-0">Sales Orders</h2>
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a>
                        </li>
                        <li class="breadcrumb-item active">List
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
        <div class="form-group breadcrum-right">
            <div class="dropdown">
                <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                        class="feather icon-settings"></i></button>
                <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a
                        class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php

$dealStatusArray = ["all" => "Order Status", "pending" => "Pending", "confirmed" => "Proceed To Accounts", "purchase" => "Proceed To Purchase", "placed" => "Order Placed"];


?>
<?php $__env->startSection('content-body'); ?>

    <div class="content-body">
        <section id="sale-order-datatable">
            <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('search-po')); ?>"  style="display:none;">
                            <?php echo csrf_field(); ?> 
                            <div class="row ">
                                <div class="col-3">

                                    <fieldset class="form-group position-relative has-icon-left">
                                        <input type="text" class="form-control round" name="so_number"
                                            placeholder="Search SO #" required>
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>

                                </div>
                                <div class="col-2">
                                    <button type="submit"  class="btn btn-primary waves-effect waves-light">Go</button>
                                </div>
                            </div>
                         </form> 
                    </div>
                </div>
            </div>
            <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-3">
                                
                                    <fieldset class="form-group position-relative has-icon-left">
                                        <input type="text" class="form-control round" id="searchbar"
                                            placeholder="Search">
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>
                                
                            </div>
                        
                             
                            <div class="col-9">
                            <form method="GET" action=""> 
                            <div class="row ">
                             <div class="col-3 ">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealStatus" >
                                        <?php $__currentLoopData = $dealStatusArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealStatus") == $key): ?> selected="" <?php endif; ?> ><?php echo e($ds); ?></option>
                                        <!-- <option value="pending">Pending</option>
                                        <option value="confirmed">Proceed To Accounts</option>
                                        <option value="purchase">Proceed To Purchase</option>
                                        <option value="placed">Order Placed</option> -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-3 ">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealTermBy" id="dealTermBy">
                                      
                                        <?php $__currentLoopData = $dealTermByArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealTermBy") == $key): ?> selected="" <?php endif; ?> ><?php echo e($pt); ?></option>
                                        <!-- <option value="pending">Pending</option>
                                        <option value="confirmed">Proceed To Accounts</option>
                                        <option value="purchase">Proceed To Purchase</option>
                                        <option value="placed">Order Placed</option> -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                          
                          
                                <div class="col-2">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealMonth" id="dealMonth">
                                            <!-- <option value="all" selected="">All</option> -->
                                            <?php $__currentLoopData = $dealMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealMonth") == $key): ?> selected="" <?php elseif($key == date("m")): ?> selected="" <?php endif; ?> ><?php echo e($dm); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                    </div>
                                    <div class="col-2 ">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealYear" id="dealYear">
                                        <?php $__currentLoopData = $dealYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealYear") == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-2">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Orders List</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead class="bg-skyblue">
                                            <tr>
                                                <th width="5%">SO</th>
                                                <th width="10%">Date</th>
                                                <th width="20%">Customer</th>
                                                <th width="15%">Payment Type</th>
                                                <th width="20%">Status</th>
                             
                                                <th>-</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-lightgrey">
                                            <?php $__currentLoopData = $salesOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-'); ?>

                                                    </td>
                                                    <td><?php echo e(date('d-M-y', strtotime($order->dealEndDateTime))); ?></td>
                                                    <td><?php echo e($order->dealCompanyName); ?> </td>

                                                    <td><?php echo e($order->dealPaymentMethod); ?></td>
                                                    <?php if ($order->dealStatus == 'confirmed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="background: #c82796 !important;padding: 6px 6px; color: #fff !important;">Proceed
                                                            To Accounts</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'purchase') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="background: #27c8c8 !important; color: #fff !important;">Proceed
                                                            To Purchase</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'placed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="padding: 8px 5px; background:  #2759c8 !important; color: #fff !important;">Order
                                                            Placed</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'closed')  { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="padding: 8px 10px; background: #4fc827 !important; color: #fff !important;">Order
                                                            Closed</span>

                                                    </td>
                                                    <?php } else { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="padding: 8px 5px; background: #ff922c !important; color: #fff !important;">Pending
                                                            Order</span>

                                                    </td>
                                                    <?php } ?>
                                                    <!-- <td></td> -->
       
                                                    <td>
                                                        <div class="btn-dropdown mr-1 mb-1">
                                                            <div class="btn-group dropdown actions-dropodown">
                                                                <button type="button"
                                                                    class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                    data-toggle="dropdown" aria-haspopup="true"
                                                                    aria-expanded="false">
                                                                    Actions
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <a class="dropdown-item"
                                                                        href="<?php echo e(route('orders.show', bin2hex($order->dealName))); ?>"
                                                                        target="_blank"> <i
                                                                            class="feather icon-eye"></i>View</a>
                                                                    <!-- <a class="dropdown-item" href="#"><i
                                                                            class="feather icon-file"></i>Archive</a> -->
                                                                    <a class="dropdown-item" href="<?php echo e(route('pdf.order', bin2hex($order->dealName))); ?>"><i
                                                                            class="feather icon-paperclip"></i>PDF</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                        <tfoot class="bg-skyblue">
                                            <tr>
                                                <th width="5%">SO</th>
                                                <th width="10%">Date</th>
                                                <th width="20%">Customer</th>
                                                <th width="15%">Payment Type</th>
                                                <th width="20%">Status</th>
                                      
                                                <th>-</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <script>
        $('#sale-order-datatable').DataTable();

        function searchPONumber() {

            var so_number = $("#so_number").val();
            // alert(po_number);

            var actionUrl = "<?php echo e(route('search-po')); ?>";

            $.ajax({
                data: {
                    so_number: so_number,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    console.log(response);
                    if(response === "false")
                    {
                        Swal.fire({
                            title: "Sorry!",
                            text: "This Order is Not Available!",
                            type: "error",
                            confirmButtonClass: 'btn btn-primary',
                            buttonsStyling: false,
                        });
                    }
                    else {
                        var number = JSON.parse(response);
                        number = number.toString();
                        // console.log(number);
                        var url = '<?php echo e(route("orders.show", ":number")); ?>';
                        url = url.replace(':number', number);
                        window.open(url, "_blank");
                    }


                    // $('#dealShippingAccount').val(result.value);
                }
            })
        }

        $('#search-po').submit(function(event){
            event.preventDefault();

                var form = $(this);
                var actionUrl = form.attr('action');

                $.ajax({
                    type: "POST",
                    url: actionUrl,
                    data: form.serialize(), // serializes the form's elements.
                    success: function(data) {
                        alert(data); // show response from the php script.
                    }
                });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\itd-portal\resources\views/orders/index.blade.php ENDPATH**/ ?>