<?php $__env->startSection('leftbar-orders-active', 'active'); ?>


<?php $__env->startSection('after-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/datatables.min.css')); ?>">
<style>
.row-td-font{
    font-size: 12px;

}
</style>
<?php $__env->stopSection(); ?>
<?php

$dealStatusArray = ["all" => "All Orders", "pending" => "Pending", "confirmed" => "Proceed To Accounts", "purchase" => "Proceed To Purchase", "placed" => "Order Placed", "closed" => "Order Closed"];


?>
<?php $__env->startSection('content-body'); ?>

    <div class="content-body">

      

        <section id="sale-order-datatable">
            <div class="card m0 d-none">
                <div class="card-content">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('search-po')); ?>"  style="display:none;">
                            <?php echo csrf_field(); ?> 
                            <div class="row ">
                                <div class="col-3">

                                    <fieldset class="form-group position-relative has-icon-left">
                                        <input type="text" class="form-control round" name="so_number"
                                            placeholder="Search SO #" required>
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>

                                </div>
                                <div class="col-2">
                                    <button type="submit"  class="btn btn-primary waves-effect waves-light">Go</button>
                                </div>
                            </div>
                         </form> 
                    </div>
                </div>
            </div>
            <div class="card m0">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-md-4">
                                
                                    <fieldset class="form-group position-relative has-icon-left hide">
                                        <input type="text" class="form-control round" id="searchbar"
                                            placeholder="Search">
                                        <div class="form-control-position">
                                            <i class="feather icon-search px-1"></i>
                                        </div>
                                    </fieldset>
                                

                                <div id="cv-section" style="display: none;">

                                  <h3>Upload CSV</h3>
                                <form action="<?php echo e(route('orders.processcsv')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="file" name="csv_file" accept=".csv">
                                    <br><br>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light btn-sm">Upload</button>
                                    <a href="javascript:void(0)" id="cancelshowcsv">cancel</a>
                                </form>

                            </div>
                             <a href="javascript:void(0)" id="showcsv">find missing orders via csv</a>
                             </div>
                        
                             
                            <div class="col-md-8">
                            <form method="GET" action=""> 
                            <div class="row ">
                                 <div class="col-2">
                                <fieldset class="form-group">
                                    <select class="form-control" name="showZero" >
                                     
                                        <option value="0"  <?php if(request()->get('showZero') == 0): ?> selected="" <?php endif; ?> >All</option>
                                        <option value="1" <?php if(request()->get('showZero') == 1): ?> selected="" <?php endif; ?>>No Invoices</option>
                                   
                                     
                                    </select>
                                </fieldset>
                            </div>
                             <div class="col-2 ">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealStatus" >
                                        <?php $__currentLoopData = $dealStatusArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if($dealStatus == $key): ?> selected="" <?php endif; ?> ><?php echo e($ds); ?></option>
                                        <!-- <option value="pending">Pending</option>
                                        <option value="confirmed">Proceed To Accounts</option>
                                        <option value="purchase">Proceed To Purchase</option>
                                        <option value="placed">Order Placed</option> -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-3 hide">
                                <fieldset class="form-group">
                                    <select class="form-control" name="dealTermBy" id="dealTermBy">
                                      
                                        <?php $__currentLoopData = $dealTermByArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealTermBy") == $key): ?> selected="" <?php endif; ?> ><?php echo e($pt); ?></option>
                                      
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                          
                          
                                <div class="col-2">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealMonth" id="dealMonth">
                                            <option value="all" <?php if(request()->get("dealMonth") == 'all'): ?> selected=""  <?php endif; ?> >All</option>
                                            <?php $__currentLoopData = $dealMonthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealMonth") == $key): ?> selected=""  <?php endif; ?> ><?php echo e($dm); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                    </div>
                                    <div class="col-2">
                                    <fieldset class="form-group">
                                        <select class="form-control" name="dealYear" id="dealYear">
                                        <?php $__currentLoopData = $dealYearArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(request()->get("dealYear") == $key): ?> selected="" <?php elseif($key == date("y")): ?> selected="" <?php endif; ?> ><?php echo e($dy); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-2">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Show</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Orders <b>( <?php echo e(count($salesOrders)); ?> )</b></h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body card-dashboard">
                                <div class="table-responsive">
                                    <table class="table zero-configuration">
                                        <thead class="bg-skyblue">
                                            <tr>
                                                <th width="5%">SO</th>
                                                <th width="10%">Date</th>
                                                <th width="20%">Customer</th>
                                                <th width="20%">Customer PO#</th>
                                                
                                                <th width="15%">Payment Type</th>
                                                <th width="20%">Status</th>
                                                <th width="20%">Invoices</th>
                                                <th width="20%">Amount</th>
                                                <th>-</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-lightgrey">
                                            <?php $__currentLoopData = $salesOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="row-td-font"><?php echo e($order->dealSO ? $order->company->companyPrefix . '' . $order->dealSO : '-'); ?>

                                                    </td>
                                                    <td class="row-td-font"><?php echo e(date('d-M-y', strtotime($order->dealEndDateTime))); ?></td>
                                                    <td class="row-td-font"><?php echo e($order->dealCompanyName); ?> </td>
                                                    <td class="row-td-font"><?php echo e($order->dealRef); ?> </td>
                                                    
                                                    <td class="row-td-font"><?php echo e($order->dealPaymentMethod); ?> </td>
                                                    <?php if ($order->dealStatus == 'confirmed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #c82796 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Accounts</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'purchase') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color: #27c8c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Proceed
                                                            To Purchase</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'placed') { ?>
                                                    <td class="or-p-s"><span class="ord-status"
                                                            style="color:  #2759c8 !important;  font-size: 10px; font-weight: bold;
                                                            ">Placed</span>

                                                    </td>
                                                    <?php }else if ($order->dealStatus == 'closed')  { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #4fc827 !important;  font-size: 10px; font-weight: bold;
                                                            ">Closed</span>

                                                    </td>
                                                    <?php } else { ?>
                                                    <td class="or-p-s"><span class="st-pending ord-status"
                                                            style="color: #ff922c !important;  font-size: 10px; font-weight: bold;
                                                            ">Pending</span>

                                                    </td>
                                                    <?php } ?>
                                                    <!-- <td></td> -->
                                                    <td class="row-td-font">
                                                        <?php if($order->dealSO): ?>
                                                        <a href="https://erp.thetechit.com/admin/salesorder/create_invoice/<?php echo e($order->dealSO); ?>" target="_blank"><?php echo e($order->invoices->count()); ?> </a>
                                                        <?php else: ?> 
                                                        -
                                                        <?php endif; ?>
                                                    </td>
                                                    <?php
                                                    $subtotal = 0;
                                                    foreach($order->dealItems as $item):

                                                    $bsub = $item->dealItemQuantity*$item->dealItemUnitCost;
                                                    $subtotal += $bsub ? (float)$bsub : 0;
                                                   
                                                    endforeach;

                                                    $dealTaxValue = $order->dealTaxValue ? (float)$order->dealTaxValue:0;
                                                    $dealCreditCardCharges = $order->dealCreditCardCharges ? (float)$order->dealCreditCardCharges:0;
                                                    $dealShippingCharges = $order->dealShippingCharges ? (float)$order->dealShippingCharges:0;
                                                    $dealChargeAmount = $order->dealChargeAmount ? (float)$order->dealChargeAmount:0;
                                                    ?>
                                                    <td><b><?php echo e(auth()->user()->company->companyCurrency); ?><?php echo e($subtotal+$dealTaxValue+$dealCreditCardCharges+$dealShippingCharges+$dealChargeAmount); ?></b></td>
                                                    <td>
                                                       

                                                       <?php if($order->dealSO): ?>
                                                        <a href="https://erp.thetechit.com/admin/salesorder/view_salesorder/<?php echo e($order->dealSO); ?>" target="_blank">view</a>
                                                       <?php else: ?>
                                                       -

                                                       <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                      
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>




    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>

    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/datatables.min.js')); ?>"></script>

    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')); ?>"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>

    <script>
     


        function searchPONumber() {

            var so_number = $("#so_number").val();
            // alert(po_number);

            var actionUrl = "<?php echo e(route('search-po')); ?>";

            $.ajax({
                data: {
                    so_number: so_number,
                },
                url: actionUrl,
                type: 'POST',
                beforeSend: function(request) {
                    return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr(
                        'content'));
                },
                success: function(response) {
                    console.log(response);
                    if(response === "false")
                    {
                        Swal.fire({
                            title: "Sorry!",
                            text: "This Order is Not Available!",
                            type: "error",
                            confirmButtonClass: 'btn btn-primary',
                            buttonsStyling: false,
                        });
                    }
                    else {
                        var number = JSON.parse(response);
                        number = number.toString();
                        // console.log(number);
                        var url = '<?php echo e(route("orders.show", ":number")); ?>';
                        url = url.replace(':number', number);
                        window.open(url, "_blank");
                    }


                    // $('#dealShippingAccount').val(result.value);
                }
            })
        }

        $('#search-po').submit(function(event){
            event.preventDefault();

                var form = $(this);
                var actionUrl = form.attr('action');

                $.ajax({
                    type: "POST",
                    url: actionUrl,
                    data: form.serialize(), // serializes the form's elements.
                    success: function(data) {
                        alert(data); // show response from the php script.
                    }
                });
        });

        $("#showcsv").click(function(){
  $("#cv-section").show();
  $("#showcsv").hide();
  
});
                $("#cancelshowcsv").click(function(){

    $("#cv-section").hide();
  $("#showcsv").show();
});

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/orders/list-check.blade.php ENDPATH**/ ?>