<?php $__env->startSection('leftbar-orders-active', 'active'); ?>
<?php $__env->startSection('after-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/datatables.min.css')); ?>">
<style>
.row-td-font{
    font-size: 12px;

}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content-body'); ?>

<div class="content-body">
    <section id="sale-order-datatable">
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Customers</h4>
                        <a href="<?php echo e(route('customer.create')); ?>" target="_blank" class="btn btn-success  waves-effect waves-light float-right btn-sm"><i class="feather icon-user-plus"></i> </a>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table zero-configuration">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>City</th>
                                            <th>State</th>
                                            <th>-</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($customer->userCompany); ?></td>
                                                <td><?php echo e($customer->email); ?> </td>
                                                <td><?php echo e($customer->userCity); ?> </td>
                                                <td><?php echo e($customer->userState); ?></td>
                                                <td>
                                               
                                                    <div class="btn-dropdown mr-1 mb-1">
                                                        <div class="btn-group dropdown actions-dropodown">
                                                            <button type="button"
                                                                class="btn btn-white px-1 py-1 dropdown-toggle waves-effect waves-light text-bold-600"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('customer.edit', $customer->userId)); ?>"
                                                                    target="_blank">Edit</a>
                                                                <!-- <a class="dropdown-item" href="#"><i
                                                                        class="feather icon-file"></i>Archive</a> -->
                                                                
                                                                    <a class="dropdown-item hide" href="javascript:void(0)" data-toggle="modal" data-target="#defaultt2<?php echo e($customer->userId); ?>" 
                                                                        >Credit Card Form</a>
                                                                    <a class="dropdown-item hide" href="javascript:void(0)" data-toggle="modal" data-target="#default<?php echo e($customer->userId); ?>" 
                                                                        >Credit Card Authorization</a>
                                                            </div>

                                                            <div class="modal fade text-left" id="defaultt2<?php echo e($customer->userId); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                                <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                                    <div class="modal-content">
                                                                        <form action="<?php echo e(route('create-company-link')); ?>" method="POST">
                                                                            <?php echo csrf_field(); ?>
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title" id="myModalLabel1">Generate Credit Card Application Form</h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                           
                                                                            <div class="row">
                                                                                <div class="col-md-12 col-12 mb-3">
                                                                                    <label for="validationTooltip01">Company Name</label>
                                                                                    <input type="text" class="form-control" name="companyName"  required="" value="<?php echo e($customer->userCompany); ?>">
                                                                                    
                                                                                </div>
                                                                              
                                                                            </div>
                                                                     
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="submit" class="btn btn-primary" >Generate Link</button>
                                                    
                                                                        </div>
                                                                    </form>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="modal fade text-left" id="default<?php echo e($customer->userId); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                                                                <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                                    <div class="modal-content">
                                                                        <form action="<?php echo e(route('create-authorization-link')); ?>" method="POST">
                                                                            <?php echo csrf_field(); ?>
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title" id="myModalLabel1">Generate Credit Card Authorization Form</h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                           
                                                                            <div class="row">
                                                                                <div class="col-md-12 col-12 mb-3">
                                                                                    <label for="validationTooltip01">Company Name</label>
                                                                                    <input type="text" class="form-control" name="companyName"  required="" value="<?php echo e($customer->userCompany); ?>">
                                                                                    
                                                                                </div>
                                                                              
                                                                            </div>
                                                                     
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="submit" class="btn btn-primary" >Generate Link</button>
                                                    
                                                                        </div>
                                                                    </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    
                                </table>
                                <?php echo e($customers->links('pagination::bootstrap-4')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('after-scripts'); ?>




    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>

    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/datatables.min.js')); ?>"></script>

    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')); ?>"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/itdevic1/public_html/erpreporting/resources/views/customers/index.blade.php ENDPATH**/ ?>